/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaMethod;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaParameter;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.util.TypeUtil;

public class ReflectionHelper {
    public static TypeNodeData createTypeData(String string, Object object) {
        return ReflectionHelper.createTypeData(string, null, object);
    }

    public static TypeNodeData createTypeData(String string, String string2) {
        return ReflectionHelper.createTypeData(string, string2, null);
    }

    public static TypeNodeData createTypeData(String string, String string2, Object object) {
        int n = ReflectionHelper.separateGenericType(string);
        String string3 = string.substring(0, n);
        String string4 = null;
        if (n != string.length()) {
            string4 = string.substring(n + 1, string.length() - 1);
        }
        TypeNodeData typeNodeData = new TypeNodeData(string3, string4, string2, object);
        if (ReflectionHelper.isArray(string3)) {
            typeNodeData.setGenericType(string3.substring(0, string3.indexOf("[]")));
        }
        return typeNodeData;
    }

    private static int separateGenericType(String string) {
        int n = string.length();
        if (n < 2 || string.charAt(n - 1) != '>') {
            return n;
        }
        int n2 = 1;
        for (int i = n - 2; i >= 0; --i) {
            if (string.charAt(i) == '>') {
                ++n2;
            } else if (string.charAt(i) == '<') {
                --n2;
            }
            if (n2 != 0) continue;
            return i;
        }
        return n;
    }

    public static boolean isArray(String string) {
        return string != null && string.indexOf("[]") >= 0;
    }

    public static boolean isComplexType(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            Class<?> clazz2 = Class.forName(XmlType.class.getName(), true, classLoader);
            Object obj = clazz.getAnnotation(clazz2);
            boolean bl = ReflectionHelper.isEnumeration(string, classLoader);
            return obj != null && !bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isCollection(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            return Collection.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isHolder(String string) {
        return "javax.xml.ws.Holder".equals(string);
    }

    public static boolean isJAXBElement(String string) {
        return "javax.xml.bind.JAXBElement".equals(string);
    }

    public static boolean isEnumeration(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            Class<?> clazz2 = Class.forName(Enum.class.getName(), true, classLoader);
            return clazz2.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isSimpleType(String string, ClassLoader classLoader) {
        try {
            if (ReflectionHelper.isPrimitiveClass(string)) {
                return true;
            }
            Class.forName(string, true, classLoader);
            return !ReflectionHelper.isCollection(string, classLoader) && !ReflectionHelper.isHolder(string) && !ReflectionHelper.isComplexType(string, classLoader) && !ReflectionHelper.isEnumeration(string, classLoader) && !ReflectionHelper.isJAXBElement(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Object makeGenericArray(String string, int n, ClassLoader classLoader) throws WebServiceReflectionException {
        try {
            Class<?> clazz = null;
            clazz = ReflectionHelper.isPrimitiveClass(string) ? ReflectionHelper.getPrimitiveClass(string) : Class.forName(string, true, classLoader);
            return Array.newInstance(clazz, n);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static Object makeJAXBElement(String string, String string2, Object object, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            if (string == null || classLoader == null) {
                Object var5_5 = null;
                return var5_5;
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> clazz = null;
            clazz = ReflectionHelper.isPrimitiveClass(string) ? ReflectionHelper.getPrimitiveClass(string) : Class.forName(string, true, classLoader);
            Class<?> clazz2 = Class.forName(QName.class.getName(), true, classLoader);
            Class<?> clazz3 = Class.forName(JAXBElement.class.getName(), true, classLoader);
            Constructor<?> constructor = clazz2.getConstructor(String.class);
            Object obj = constructor.newInstance(string2);
            Constructor<?> constructor2 = clazz3.getConstructor(clazz2, Class.class, Object.class);
            Object obj2 = constructor2.newInstance(obj, clazz, object);
            return obj2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebServiceReflectionException("ClassNotFoundException", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new WebServiceReflectionException("InstantiationException", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WebServiceReflectionException("IllegalAccessException", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WebServiceReflectionException("InvocationTargetException", invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new WebServiceReflectionException("NoSuchMethodException", noSuchMethodException);
        }
        finally {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
    }

    public static Object makeEnumeration(String string, ClassLoader classLoader) throws WebServiceReflectionException {
        try {
            List<String> list = ReflectionHelper.getEnumerationValues(string, classLoader);
            Class<?> clazz = Class.forName(string, true, classLoader);
            return Enum.valueOf(clazz, list.get(0));
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static Object getEnumeration(String string, String string2, ClassLoader classLoader) throws WebServiceReflectionException {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            return Enum.valueOf(clazz, string2);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static Object makeHolder(ClassLoader classLoader) throws WebServiceReflectionException {
        return ReflectionHelper.makeComplexType("javax.xml.ws.Holder", classLoader);
    }

    public static Object makeCollection(String string, ClassLoader classLoader) throws WebServiceReflectionException {
        Object obj;
        block11: {
            ClassLoader classLoader2 = null;
            try {
                Object obj2;
                if (!ReflectionHelper.isCollection(string, classLoader)) {
                    Object var3_3 = null;
                    return var3_3;
                }
                Class<?> clazz = Class.forName(string, true, classLoader);
                if (clazz.isInterface()) {
                    ArrayList arrayList = new ArrayList();
                    if (classLoader2 != null) {
                        Thread.currentThread().setContextClassLoader(classLoader2);
                    }
                    return arrayList;
                }
                classLoader2 = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                obj = obj2 = clazz.newInstance();
                if (classLoader2 == null) break block11;
            }
            catch (Exception exception) {
                throw new WebServiceReflectionException(exception.getClass().getName(), exception);
            }
            finally {
                if (classLoader2 != null) {
                    Thread.currentThread().setContextClassLoader(classLoader2);
                }
            }
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        return obj;
    }

    public static Object makeComplexType(String string, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            Object obj;
            if (string == null || classLoader == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> clazz = Class.forName(string, true, classLoader);
            Object obj2 = obj = clazz.newInstance();
            return obj2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebServiceReflectionException("ClassNotFoundException", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new WebServiceReflectionException("InstantiationException", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WebServiceReflectionException("IllegalAccessException", illegalAccessException);
        }
        finally {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
    }

    public static List<String> getEnumerationValues(String string, ClassLoader classLoader) throws WebServiceReflectionException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Class<?> clazz = Class.forName(string, true, classLoader);
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (!field.isEnumConstant()) continue;
                arrayList.add(field.getName());
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static List<String> getPropertyNames(String string, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader classLoader2 = null;
        try {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            classLoader2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> clazz = Class.forName(XmlType.class.getName(), true, classLoader);
            for (Class<?> clazz2 = Class.forName(string, true, classLoader); clazz2 != null && (arrayList = clazz2.getAnnotation(clazz)) != null; clazz2 = clazz2.getSuperclass()) {
                try {
                    Method method = arrayList.getClass().getMethod("propOrder", new Class[0]);
                    String[] stringArray = (String[])method.invoke(arrayList, null);
                    for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                        if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                        arrayList2.add(stringArray[i]);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            arrayList = arrayList2;
            return arrayList;
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
        finally {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
    }

    public static String getPropertyType(String string, String string2, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader classLoader2 = null;
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            char[] cArray = string2.toCharArray();
            String string3 = null;
            Method method = null;
            for (int i = 0; i < string2.length() && method == null; ++i) {
                cArray[i] = Character.toUpperCase(cArray[i]);
                string3 = new String(cArray);
                try {
                    method = clazz.getMethod("get" + string3, new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = clazz.getMethod("is" + string3, new Class[0]);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                }
            }
            if (method == null) {
                throw new NoSuchMethodException("Method not found for property " + string2 + " in class " + string);
            }
            String string4 = TypeUtil.typeToString((Type)method.getGenericReturnType());
            return string4;
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
        finally {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
    }

    public static Object getHolderValue(Object object) throws WebServiceReflectionException {
        try {
            Field field = object.getClass().getField("value");
            return field.get(object);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static void setHolderValue(Object object, Object object2) throws WebServiceReflectionException {
        try {
            Field field = object.getClass().getField("value");
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static Object getJAXBElementValue(Object object) throws WebServiceReflectionException {
        try {
            Method method = object.getClass().getMethod("getValue", new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static String getQNameLocalPart(Object object) throws WebServiceReflectionException {
        try {
            Method method = object.getClass().getMethod("getName", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method2 = object2.getClass().getMethod("getLocalPart", new Class[0]);
            return (String)method2.invoke(object2, new Object[0]);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static void setJAXBElementValue(Object object, Object object2) throws WebServiceReflectionException {
        try {
            Method method = object.getClass().getMethod("setValue", Object.class);
            method.invoke(object, object2);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPropertySettable(String string, String string2, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader classLoader2 = null;
        try {
            int n;
            char[] cArray = string2.toCharArray();
            cArray[0] = Character.toUpperCase(cArray[0]);
            String string3 = new String(cArray);
            String string4 = "set" + string3;
            classLoader2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> clazz = Class.forName(string, true, classLoader);
            Method[] methodArray = clazz.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                Method method = methodArray[n];
                if (!method.getName().equals(string4) || method.getParameterTypes().length != 1) continue;
                boolean bl = true;
                if (classLoader2 != null) {
                    Thread.currentThread().setContextClassLoader(classLoader2);
                }
                return bl;
            }
            n = 0;
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            return n != 0;
        }
        catch (Exception exception) {
            try {
                throw new WebServiceReflectionException(exception.getClass().getName(), exception);
            }
            catch (Throwable throwable) {
                if (classLoader2 != null) {
                    Thread.currentThread().setContextClassLoader(classLoader2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertyValue(Object object, String string, String string2, Object object2, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader classLoader2 = null;
        try {
            Class<?> clazz = object.getClass();
            Class<?> clazz2 = null;
            classLoader2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                clazz2 = ReflectionHelper.isPrimitiveClass(string2) ? ReflectionHelper.referenceClass2PrimitiveClass(object2.getClass()) : Class.forName(string2, true, classLoader);
                Class[] classArray = new Class[]{clazz2};
                char[] cArray = string.toCharArray();
                String string3 = null;
                Method method = null;
                for (int i = 0; i < string.length() && method == null; ++i) {
                    cArray[i] = Character.toUpperCase(cArray[i]);
                    string3 = "set" + new String(cArray);
                    try {
                        method = clazz.getMethod(string3, classArray);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (method == null) {
                    throw new NoSuchMethodException("Method setter for property " + string + " not found in class " + clazz);
                }
                Object[] objectArray = new Object[]{object2};
                method.invoke(object, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WebServiceReflectionException("ClassNotFoundException", classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new WebServiceReflectionException("NoSuchMethodException", noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WebServiceReflectionException("IllegalAccessException", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WebServiceReflectionException("InvocationTargetException", invocationTargetException);
            }
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
        catch (Throwable throwable) {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            throw throwable;
        }
    }

    public static Object getPropertyValue(Object object, String string, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader classLoader2 = null;
        Class<?> clazz = object.getClass();
        Method method = null;
        classLoader2 = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        char[] cArray = string.toCharArray();
        String string2 = null;
        for (int i = 0; i < string.length() && method == null; ++i) {
            cArray[i] = Character.toUpperCase(cArray[i]);
            string2 = new String(cArray);
            try {
                method = clazz.getMethod("get" + string2, new Class[0]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getMethod("is" + string2, new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
        }
        try {
            if (method == null) {
                throw new NoSuchMethodException("Method not found for property " + string + " in class " + clazz);
            }
            Object object2 = method.invoke(object, new Object[0]);
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            return object2;
        }
        catch (Exception exception) {
            try {
                throw new WebServiceReflectionException(exception.getClass().getName(), exception);
            }
            catch (Throwable throwable) {
                if (classLoader2 != null) {
                    Thread.currentThread().setContextClassLoader(classLoader2);
                }
                throw throwable;
            }
        }
    }

    public static Object getArrayValue(Object object, int n) throws WebServiceReflectionException {
        try {
            return Array.get(object, n);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    public static int getArrayLength(Object object) throws WebServiceReflectionException {
        try {
            return Array.getLength(object);
        }
        catch (Exception exception) {
            throw new WebServiceReflectionException(exception.getClass().getName(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callMethodWithParams(String string, LinkedList linkedList, JavaMethod javaMethod, URLClassLoader uRLClassLoader, WsdlData wsdlData, WSPort wSPort) throws WebServiceReflectionException {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        if (null == uRLClassLoader) {
            return null;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object;
            Class clazz3;
            int n;
            Object object2;
            Serializable serializable;
            Object object3;
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            try {
                clazz2 = Class.forName(string, true, uRLClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WebServiceReflectionException("ClassNotFoundException", classNotFoundException);
            }
            Object object4 = null;
            try {
                object3 = new File(wsdlData.getWsdlFile());
                if (object3 != null) {
                    object3 = ((File)object3).getCanonicalFile();
                }
                boolean bl = object3 != null && JaxWsUtils.isRPCEncoded((URI)((File)object3).toURI());
                serializable = null;
                serializable = bl ? wsdlData.getJaxRpcDescriptor().getWsdlUrl() : wsdlData.getJaxWsDescriptor().getWsdlUrl();
                object2 = ((URL)serializable).getPath();
                n = ((URL)serializable).getProtocol().toLowerCase().startsWith("file") ? ((n = ((String)object2).lastIndexOf(System.getProperty("path.separator"))) < 0 ? ((String)object2).lastIndexOf("/") : n) : ((String)object2).lastIndexOf("/");
                n = n < 0 || n >= ((String)object2).length() - 1 ? 0 : n + 1;
                clazz3 = ((String)object2).substring(n);
                object = null;
                object = bl ? wsdlData.getJaxRpcDescriptor().getModel().getNamespaceURI() : wsdlData.getJaxWsDescriptor().getModel().getNamespaceURI();
                String string2 = null;
                string2 = bl ? wsdlData.getJaxRpcDescriptor().getName() : wsdlData.getJaxWsDescriptor().getName();
                URL uRL = clazz2.getResource((String)((Object)clazz3));
                QName qName = new QName((String)object, string2);
                Constructor<?> constructor = null;
                Object object5 = null;
                if (bl) {
                    object5 = clazz2.newInstance();
                } else {
                    constructor = clazz2.getConstructor(URL.class, QName.class);
                    object5 = constructor.newInstance(uRL, qName);
                }
                String string3 = wSPort.getPortGetter();
                Method method = object5.getClass().getMethod(string3, new Class[0]);
                object4 = method.invoke(object5, new Object[0]);
                clazz = object4.getClass();
            }
            catch (InstantiationException instantiationException) {
                throw new WebServiceReflectionException("InstantiationExceptoin", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WebServiceReflectionException("IllegalAccessException", illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new WebServiceReflectionException("NoSuchMethodException", noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WebServiceReflectionException("InvocationTargetException", invocationTargetException);
            }
            catch (IOException iOException) {
                throw new WebServiceReflectionException("IOException", iOException);
            }
            object3 = null;
            Object[] objectArray = linkedList.toArray();
            serializable = new LinkedList();
            object2 = javaMethod.getParametersList();
            for (n = 0; null != objectArray && n < objectArray.length; ++n) {
                clazz3 = null;
                if (null != object2 && n < object2.size()) {
                    object = (JavaParameter)object2.get(n);
                    if (ReflectionHelper.isPrimitiveClass(object.getType().getFormalName())) {
                        clazz3 = ReflectionHelper.referenceClass2PrimitiveClass(objectArray[n].getClass());
                    } else if (object.getType().getFormalName().equals("java.util.Calendar") && !object.isHolder()) {
                        clazz3 = Calendar.class;
                    } else if (objectArray[n] == null) {
                        try {
                            clazz3 = Class.forName(object.getType().getFormalName(), true, uRLClassLoader);
                        }
                        catch (Exception exception) {
                            throw new WebServiceReflectionException("Exception", exception);
                        }
                    } else {
                        clazz3 = objectArray[n].getClass();
                    }
                }
                ((LinkedList)serializable).add(clazz3);
            }
            Class[] classArray = ((LinkedList)serializable).toArray(new Class[0]);
            try {
                object3 = clazz.getMethod(javaMethod.getName(), classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new WebServiceReflectionException("NoSuchMethodException", noSuchMethodException);
            }
            clazz3 = null;
            try {
                clazz3 = ((Method)object3).invoke(object4, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WebServiceReflectionException("InvocationTargetException", invocationTargetException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new WebServiceReflectionException("IllegalArgumentException", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WebServiceReflectionException("IllegalAccessException", illegalAccessException);
            }
            catch (Exception exception) {
                throw new WebServiceReflectionException("Exception", exception);
            }
            object = clazz3;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static boolean isPrimitiveClass(String string) {
        if (string.equalsIgnoreCase("int")) {
            return true;
        }
        if (string.equalsIgnoreCase("byte")) {
            return true;
        }
        if (string.equalsIgnoreCase("boolean")) {
            return true;
        }
        if (string.equalsIgnoreCase("float")) {
            return true;
        }
        if (string.equalsIgnoreCase("double")) {
            return true;
        }
        if (string.equalsIgnoreCase("long")) {
            return true;
        }
        return string.equalsIgnoreCase("short");
    }

    public static Class getPrimitiveClass(String string) {
        if (string.equalsIgnoreCase("int")) {
            return Integer.TYPE;
        }
        if (string.equalsIgnoreCase("byte")) {
            return Byte.TYPE;
        }
        if (string.equalsIgnoreCase("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equalsIgnoreCase("float")) {
            return Float.TYPE;
        }
        if (string.equalsIgnoreCase("double")) {
            return Double.TYPE;
        }
        if (string.equalsIgnoreCase("long")) {
            return Long.TYPE;
        }
        if (string.equalsIgnoreCase("short")) {
            return Short.TYPE;
        }
        return null;
    }

    public static Class referenceClass2PrimitiveClass(Class clazz) {
        if (null == clazz) {
            return clazz;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Boolean")) {
            return Boolean.TYPE;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Byte")) {
            return Byte.TYPE;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Double")) {
            return Double.TYPE;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Float")) {
            return Float.TYPE;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Integer")) {
            return Integer.TYPE;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Long")) {
            return Long.TYPE;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Short")) {
            return Short.TYPE;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Character")) {
            return Character.TYPE;
        }
        return clazz;
    }
}

