/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.ui.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.identity.profile.ui.support.WsdlData;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlParser {
    public static final String TNS = "targetNamespace";
    public static final String ADDRESS = "soapAddress";
    public static final String PORT = "port";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsdlData parseWSDLFile(File xmlFile, String svc) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(xmlFile));
        InputSource is = new InputSource(br);
        try {
            WsdlData wsdlData = WsdlParser.parseWSDLFile(is, svc);
            return wsdlData;
        }
        finally {
            br.close();
        }
    }

    public static WsdlData parseWSDLFile(InputSource xmlFile, String svc) throws IOException {
        WsdlData wsdlData = null;
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            SAXParser parser = saxFactory.newSAXParser();
            WsdlHandler handler = new WsdlHandler(svc);
            parser.parse(xmlFile, (DefaultHandler)handler);
            wsdlData = handler.getWsdlData();
        }
        catch (ParserConfigurationException excp) {
            IOException ioe = new IOException();
            ioe.initCause(excp);
            throw ioe;
        }
        catch (SAXException excp) {
            IOException ioe = new IOException();
            ioe.initCause(excp);
            throw ioe;
        }
        return wsdlData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getWsdlSvcNames(File xmlFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(xmlFile));
        InputSource is = new InputSource(br);
        try {
            ArrayList arrayList = WsdlParser.getWsdlSvcNames(is);
            return arrayList;
        }
        finally {
            br.close();
        }
    }

    public static ArrayList getWsdlSvcNames(InputSource xmlFile) throws IOException {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            SAXParser parser = saxFactory.newSAXParser();
            SvcNameHandler handler = new SvcNameHandler();
            parser.parse(xmlFile, (DefaultHandler)handler);
            return handler.getWsdlSvcNames();
        }
        catch (ParserConfigurationException excp) {
            IOException ioe = new IOException();
            ioe.initCause(excp);
            throw ioe;
        }
        catch (SAXException excp) {
            IOException ioe = new IOException();
            ioe.initCause(excp);
            throw ioe;
        }
    }

    private static class SvcNameHandler
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        ArrayList wsdlSvcNames = new ArrayList();

        public ArrayList getWsdlSvcNames() {
            return this.wsdlSvcNames;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ((W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) && localName.equals("service")) {
                String name = attributes.getValue("name");
                this.wsdlSvcNames.add(name);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private static class WsdlHandler
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        private String svcName;
        WsdlData wsdlData = new WsdlData();
        boolean found = false;

        public WsdlHandler(String svc) {
            this.svcName = svc;
        }

        public WsdlData getWsdlData() {
            return this.wsdlData;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) {
                if (localName.equals("definitions")) {
                    this.wsdlData.setTargetNameSpace(attributes.getValue(WsdlParser.TNS));
                }
                if (localName.equals("service") && this.svcName.equalsIgnoreCase(attributes.getValue("name"))) {
                    this.found = true;
                }
                if (this.found && localName.equals(WsdlParser.PORT)) {
                    this.wsdlData.setPort(attributes.getValue("name"));
                }
            }
            if (this.found && localName.equals("address")) {
                this.wsdlData.setAddress(attributes.getValue("location"));
                this.found = false;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }
}

