/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.execution;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.impl.DLightTargetAccessor;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.windows.InputOutput;

public abstract class DLightTarget {
    private final List<DLightTargetListener> listeners;
    private final Info info;
    private final DLightTargetExecutionService<? extends DLightTarget> executionService;

    protected DLightTarget(DLightTargetExecutionService<? extends DLightTarget> executionService) {
        this.executionService = executionService;
        this.listeners = new ArrayList<DLightTargetListener>();
        this.info = new Info();
    }

    private final DLightTargetExecutionService<? extends DLightTarget> getExecutionService() {
        return this.executionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTargetListener(DLightTargetListener listener) {
        if (listener == null) {
            return;
        }
        DLightTarget dLightTarget = this;
        synchronized (dLightTarget) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTargetListener(DLightTargetListener listener) {
        DLightTarget dLightTarget = this;
        synchronized (dLightTarget) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(final DLightTargetChangeEvent event) {
        DLightTargetListener[] ll;
        DLightTarget dLightTarget = this;
        synchronized (dLightTarget) {
            ll = this.listeners.toArray(new DLightTargetListener[0]);
        }
        final CountDownLatch doneFlag = new CountDownLatch(ll.length);
        for (final DLightTargetListener l : ll) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        l.targetStateChanged(event);
                    }
                    finally {
                        doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + l));
        }
        try {
            doneFlag.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    protected final String putToInfo(String name, String value) {
        return this.info.put(name, value);
    }

    protected final String getInfo(String name) {
        return this.info.getInfo().get(name);
    }

    public abstract ExecutionEnvironment getExecEnv();

    public abstract State getState();

    public abstract int getExitCode() throws InterruptedException;

    static {
        DLightTargetAccessor.setDefault(new DLightTargetAccessorImpl());
    }

    public static final class Info {
        private Map<String, String> map = new ConcurrentHashMap<String, String>();

        Info() {
        }

        public Map<String, String> getInfo() {
            return this.map;
        }

        String put(String name, String value) {
            return this.map.put(name, value);
        }
    }

    private static final class DLightTargetAccessorImpl
    extends DLightTargetAccessor<DLightTarget> {
        private DLightTargetAccessorImpl() {
        }

        @Override
        public DLightTargetExecutionService<DLightTarget> getDLightTargetExecution(DLightTarget target) {
            DLightTargetExecutionService executionService = target.getExecutionService();
            return executionService;
        }

        @Override
        public Info getDLightTargetInfo(DLightTarget target) {
            return target.info;
        }
    }

    public static interface ExecutionEnvVariablesProvider {
        public void setupEnvironment(DLightTarget var1, MacroMap var2) throws ConnectException;
    }

    public static interface DLightTargetExecutionService<T extends DLightTarget> {
        public InputOutput start(T var1, ExecutionEnvVariablesProvider var2);

        public void terminate(T var1);
    }

    public static enum State {
        INIT,
        STARTING,
        RUNNING,
        DONE,
        FAILED,
        STOPPED,
        TERMINATED;

    }
}

