/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.datafilter.support;

import java.util.Arrays;
import java.util.Collection;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.spi.datafilter.DataFilterFactory;
import org.netbeans.modules.dlight.util.Range;

public final class TimeIntervalDataFilterFactory
implements DataFilterFactory {
    public static final String TIME_INTERVAL_FILTER = "datafilter.timeinterval";

    @Override
    public DataFilter createFilter(String filterID, String filterSpec) {
        if (!TIME_INTERVAL_FILTER.equals(filterID)) {
            return null;
        }
        int index = filterSpec.indexOf("..");
        if (index == -1) {
            return null;
        }
        Long startTime = Long.valueOf(filterSpec.substring(0, index - 1));
        Long endtime = Long.valueOf(filterSpec.substring(index + "..".length(), filterSpec.length()));
        return TimeIntervalDataFilterFactory.create((Range<Long>)new Range((Number)startTime, (Number)endtime));
    }

    public static TimeIntervalDataFilter create(Range<Long> timeInterval) {
        return new TimeIntervalDataFilter(timeInterval);
    }

    @Override
    public Collection<String> getSupportedFilterIDs() {
        return Arrays.asList(TIME_INTERVAL_FILTER);
    }
}

