/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class ExpressionScanner
extends TreeScanner<List<Tree>, ExpressionsInfo> {
    private int lineNumber;
    private CompilationUnitTree tree;
    private SourcePositions positions;
    private LineMap lineMap;
    private boolean checkBounds = true;

    public ExpressionScanner(int lineNumber, CompilationUnitTree tree, SourcePositions positions) {
        this.tree = tree;
        this.lineNumber = lineNumber;
        this.positions = positions;
        this.lineMap = tree.getLineMap();
    }

    private boolean acceptsTree(Tree aTree) {
        if (!this.checkBounds) {
            return true;
        }
        int startLine = (int)this.lineMap.getLineNumber(this.positions.getStartPosition(this.tree, aTree));
        return startLine == this.lineNumber;
    }

    private boolean isCurrentTree(Tree aTree) {
        int startLine = (int)this.lineMap.getLineNumber(this.positions.getStartPosition(this.tree, aTree));
        if ((long)startLine == -1L) {
            return false;
        }
        int endLine = (int)this.lineMap.getLineNumber(this.positions.getEndPosition(this.tree, aTree));
        if ((long)endLine == -1L) {
            return false;
        }
        return startLine <= this.lineNumber && this.lineNumber <= endLine;
    }

    @Override
    public List<Tree> reduce(List<Tree> r1, List<Tree> r2) {
        if (r1 == null || r1.size() == 0) {
            return r2;
        }
        if (r2 == null || r2.size() == 0) {
            return r1;
        }
        r1.addAll(r2);
        return r1;
    }

    @Override
    public List<Tree> scan(Iterable<? extends Tree> nodes, ExpressionsInfo p) {
        List<Tree> r = null;
        if (nodes != null) {
            boolean first = true;
            for (Tree tree : nodes) {
                r = first ? (List<Tree>)this.scan(tree, p) : this.reduce(r, (List)this.scan(tree, p));
                first = false;
            }
        }
        return r;
    }

    private List<Tree> scan(Tree t1, Tree t2, ExpressionsInfo p) {
        List<Tree> result = (List<Tree>)this.scan(t1, p);
        result = this.reduce(result, (List)this.scan(t2, p));
        return result;
    }

    @Override
    public List<Tree> visitAnnotation(AnnotationTree node, ExpressionsInfo p) {
        return null;
    }

    @Override
    public List<Tree> visitMethodInvocation(MethodInvocationTree node, ExpressionsInfo p) {
        List<Tree> result = this.scan((Iterable<? extends Tree>)node.getTypeArguments(), p);
        result = this.reduce(result, (List)this.scan(node.getMethodSelect(), p));
        if ((result = this.reduce(result, this.scan((Iterable<? extends Tree>)node.getArguments(), p))) == null) {
            result = new ArrayList<Tree>();
        }
        result.add(node);
        return result;
    }

    @Override
    public List<Tree> visitAssert(AssertTree node, ExpressionsInfo p) {
        if (this.acceptsTree(node)) {
            List<Tree> result = (List<Tree>)this.scan(node.getCondition(), p);
            result = this.reduce(result, (List)this.scan(node.getDetail(), p));
            return result;
        }
        return null;
    }

    @Override
    public List<Tree> visitAssignment(AssignmentTree node, ExpressionsInfo p) {
        return this.scan(node.getVariable(), node.getExpression(), p);
    }

    @Override
    public List<Tree> visitCompoundAssignment(CompoundAssignmentTree node, ExpressionsInfo p) {
        return this.scan(node.getVariable(), node.getExpression(), p);
    }

    @Override
    public List<Tree> visitBinary(BinaryTree node, ExpressionsInfo p) {
        return this.scan(node.getLeftOperand(), node.getRightOperand(), p);
    }

    @Override
    public List<Tree> visitCase(CaseTree node, ExpressionsInfo p) {
        List<Tree> result = (List<Tree>)this.scan(node.getExpression(), p);
        result = this.reduce(result, this.scan((Iterable<? extends Tree>)node.getStatements(), p));
        return result;
    }

    @Override
    public List<Tree> visitConditionalExpression(ConditionalExpressionTree node, ExpressionsInfo p) {
        List cond = (List)this.scan(node.getCondition(), p);
        Tree lastCond = null;
        if (cond != null) {
            lastCond = (Tree)cond.get(cond.size() - 1);
        }
        List rT = (List)this.scan(node.getTrueExpression(), p);
        List rF = (List)this.scan(node.getFalseExpression(), p);
        if (lastCond != null) {
            if (rT != null) {
                p.addNextExpression(lastCond, (Tree)rT.get(0));
            }
            if (rF != null) {
                p.addNextExpression(lastCond, (Tree)rF.get(0));
            }
        }
        return this.reduce(this.reduce(cond, rT), rF);
    }

    @Override
    public List<Tree> visitDoWhileLoop(DoWhileLoopTree node, ExpressionsInfo p) {
        List statements = (List)this.scan(node.getStatement(), p);
        List cond = null;
        if (this.acceptsTree(node.getCondition())) {
            cond = (List)this.scan(node.getCondition(), p);
        }
        if (cond != null && cond.size() > 0 && statements != null && statements.size() > 0) {
            Tree lastCond = (Tree)cond.get(cond.size() - 1);
            p.addNextExpression(lastCond, (Tree)statements.get(0));
        }
        return this.reduce(statements, cond);
    }

    @Override
    public List<Tree> visitExpressionStatement(ExpressionStatementTree node, ExpressionsInfo p) {
        if (this.acceptsTree(node)) {
            return (List)this.scan(node.getExpression(), p);
        }
        return null;
    }

    @Override
    public List<Tree> visitEnhancedForLoop(EnhancedForLoopTree node, ExpressionsInfo p) {
        List expr = null;
        if (this.acceptsTree(node.getExpression())) {
            expr = (List)this.scan(node.getExpression(), p);
        }
        List bodyr = (List)this.scan(node.getStatement(), p);
        if (expr != null && expr.size() > 0 && bodyr != null && bodyr.size() > 0) {
            p.addNextExpression((Tree)expr.get(expr.size() - 1), (Tree)bodyr.get(0));
            p.addNextExpression((Tree)bodyr.get(bodyr.size() - 1), (Tree)expr.get(0));
        }
        return this.reduce(expr, bodyr);
    }

    @Override
    public List<Tree> visitForLoop(ForLoopTree node, ExpressionsInfo p) {
        if (!this.isCurrentTree(node)) {
            return null;
        }
        List<Tree> initr = this.scan((Iterable<? extends Tree>)node.getInitializer(), p);
        this.checkBounds = false;
        List condra = (List)this.scan(node.getCondition(), p);
        List<Tree> updtra = this.scan((Iterable<? extends Tree>)node.getUpdate(), p);
        this.checkBounds = true;
        List condr = null;
        if (this.acceptsTree(node.getCondition())) {
            condr = (List)this.scan(node.getCondition(), p);
        }
        List<Tree> updtr = this.scan((Iterable<? extends Tree>)node.getUpdate(), p);
        List bodyr = (List)this.scan(node.getStatement(), p);
        if (initr != null) {
            if (condra != null) {
                p.addNextExpression(initr.get(initr.size() - 1), (Tree)condra.get(0));
            } else if (bodyr != null) {
                p.addNextExpression(initr.get(initr.size() - 1), (Tree)bodyr.get(0));
            } else if (updtra != null) {
                p.addNextExpression(initr.get(initr.size() - 1), updtra.get(0));
            }
        }
        if (condr != null) {
            if (bodyr != null) {
                p.addNextExpression((Tree)condr.get(condr.size() - 1), (Tree)bodyr.get(0));
            } else if (updtra != null) {
                p.addNextExpression((Tree)condr.get(condr.size() - 1), updtra.get(0));
            }
        }
        if (bodyr != null) {
            if (updtra != null) {
                p.addNextExpression((Tree)bodyr.get(bodyr.size() - 1), updtra.get(0));
            } else if (condra != null) {
                p.addNextExpression((Tree)bodyr.get(bodyr.size() - 1), (Tree)condra.get(0));
            }
        }
        if (updtr != null) {
            if (condra != null) {
                p.addNextExpression(updtr.get(updtr.size() - 1), (Tree)condra.get(0));
            } else if (bodyr != null) {
                p.addNextExpression(updtr.get(updtr.size() - 1), (Tree)bodyr.get(0));
            }
        }
        return this.reduce(this.reduce(this.reduce(initr, condr), bodyr), updtr);
    }

    @Override
    public List<Tree> visitIf(IfTree node, ExpressionsInfo p) {
        List cond = null;
        Tree lastCond = null;
        if (this.acceptsTree(node) && (cond = (List)this.scan(node.getCondition(), p)) != null) {
            lastCond = (Tree)cond.get(cond.size() - 1);
        }
        StatementTree thent = node.getThenStatement();
        StatementTree elset = node.getElseStatement();
        List thenr = null;
        if (this.isCurrentTree(thent)) {
            thenr = (List)this.scan(thent, p);
            if (lastCond != null && thenr != null) {
                p.addNextExpression(lastCond, (Tree)thenr.get(0));
            }
        }
        List elser = null;
        if (this.isCurrentTree(elset)) {
            elser = (List)this.scan(elset, p);
            if (lastCond != null && elser != null) {
                p.addNextExpression(lastCond, (Tree)elser.get(0));
            }
        }
        return this.reduce(this.reduce(cond, thenr), elser);
    }

    @Override
    public List<Tree> visitArrayAccess(ArrayAccessTree node, ExpressionsInfo p) {
        return this.scan(node.getExpression(), node.getIndex(), p);
    }

    @Override
    public List<Tree> visitModifiers(ModifiersTree node, ExpressionsInfo p) {
        return null;
    }

    @Override
    public List<Tree> visitNewArray(NewArrayTree node, ExpressionsInfo p) {
        List<Tree> result = (List<Tree>)this.scan(node.getType(), p);
        result = this.reduce(result, this.scan((Iterable<? extends Tree>)node.getDimensions(), p));
        result = this.reduce(result, this.scan((Iterable<? extends Tree>)node.getInitializers(), p));
        return result;
    }

    @Override
    public List<Tree> visitNewClass(NewClassTree node, ExpressionsInfo p) {
        List<Tree> result = this.scan(node.getEnclosingExpression(), node.getIdentifier(), p);
        result = this.reduce(result, this.scan((Iterable<? extends Tree>)node.getArguments(), p));
        if ((result = this.reduce(result, (List)this.scan(node.getClassBody(), p))) == null) {
            result = new ArrayList<Tree>();
        }
        result.add(node);
        return result;
    }

    @Override
    public List<Tree> visitSwitch(SwitchTree node, ExpressionsInfo p) {
        List result = null;
        if (this.acceptsTree(node)) {
            result = (List)this.scan(node.getExpression(), p);
        }
        return this.reduce(result, this.scan((Iterable<? extends Tree>)node.getCases(), p));
    }

    @Override
    public List<Tree> visitSynchronized(SynchronizedTree node, ExpressionsInfo p) {
        List result = null;
        if (this.acceptsTree(node)) {
            result = (List)this.scan(node.getExpression(), p);
        }
        return this.reduce(result, (List)this.scan(node.getBlock(), p));
    }

    @Override
    public List<Tree> visitThrow(ThrowTree node, ExpressionsInfo p) {
        List result = null;
        if (this.acceptsTree(node)) {
            result = (List)this.scan(node.getExpression(), p);
        }
        return result;
    }

    @Override
    public List<Tree> visitParameterizedType(ParameterizedTypeTree node, ExpressionsInfo p) {
        return null;
    }

    @Override
    public List<Tree> visitTypeCast(TypeCastTree node, ExpressionsInfo p) {
        return (List)this.scan(node.getExpression(), p);
    }

    @Override
    public List<Tree> visitInstanceOf(InstanceOfTree node, ExpressionsInfo p) {
        return this.scan(node.getExpression(), node.getType(), p);
    }

    @Override
    public List<Tree> visitUnary(UnaryTree node, ExpressionsInfo p) {
        return (List)this.scan(node.getExpression(), p);
    }

    @Override
    public List<Tree> visitVariable(VariableTree node, ExpressionsInfo p) {
        if (this.acceptsTree(node)) {
            return (List)this.scan(node.getInitializer(), p);
        }
        return null;
    }

    @Override
    public List<Tree> visitWhileLoop(WhileLoopTree node, ExpressionsInfo p) {
        List cond = null;
        if (this.acceptsTree(node.getCondition())) {
            cond = (List)this.scan(node.getCondition(), p);
        }
        List statements = (List)this.scan(node.getStatement(), p);
        if (cond != null && statements != null && statements.size() > 0) {
            p.addNextExpression((Tree)statements.get(statements.size() - 1), (Tree)cond.get(0));
        }
        return this.reduce(cond, statements);
    }

    @Override
    public List<Tree> visitReturn(ReturnTree node, ExpressionsInfo p) {
        if (this.acceptsTree(node)) {
            return (List)this.scan(node.getExpression(), p);
        }
        return null;
    }

    @Override
    public List<Tree> visitOther(Tree node, ExpressionsInfo p) {
        return null;
    }

    public static final class ExpressionsInfo {
        private Map<Tree, Set<Tree>> nextExpressions = new HashMap<Tree, Set<Tree>>();
        Stack<StatementTree> wrappingStatements = new Stack();

        synchronized void addNextExpression(Tree expression, Tree next) {
            Set<Tree> nexts = this.nextExpressions.get(expression);
            if (nexts == null) {
                nexts = new HashSet<Tree>();
                this.nextExpressions.put(expression, nexts);
            }
            nexts.add(next);
        }

        synchronized Set<Tree> getNextExpressions(Tree expression) {
            Set<Tree> nexts = this.nextExpressions.get(expression);
            if (nexts == null) {
                return Collections.emptySet();
            }
            return nexts;
        }
    }
}

