/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class ConstantPool {
    private static final byte TAG_UTF8 = 1;
    private static final byte TAG_INTEGER = 3;
    private static final byte TAG_FLOAT = 4;
    private static final byte TAG_LONG = 5;
    private static final byte TAG_DOUBLE = 6;
    private static final byte TAG_CLASS = 7;
    private static final byte TAG_STRING = 8;
    private static final byte TAG_FIELDREF = 9;
    private static final byte TAG_METHODREF = 10;
    private static final byte TAG_INTERFACEREF = 11;
    private static final byte TAG_NAMETYPE = 12;
    private final List<Entry> entries;

    private ConstantPool(List<Entry> entries) {
        this.entries = entries;
    }

    public Entry getEntry(int index) {
        return this.entries.get(index);
    }

    public String getMethodName(int index) {
        EntryFieldMethodRef methodRef = (EntryFieldMethodRef)this.entries.get(index);
        return ((EntryUTF8)this.entries.get(((EntryNameType)this.entries.get(methodRef.nameAndTypeIndex)).getNameIndex())).getUTF8();
    }

    public static ConstantPool parse(byte[] bytes) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        entries.add(new EntryNULL());
        try {
            while (true) {
                Entry entry;
                byte tagByte;
                try {
                    tagByte = in.readByte();
                }
                catch (EOFException eof) {
                    break;
                }
                switch (tagByte) {
                    case 1: {
                        entry = new EntryUTF8(in.readUTF());
                        break;
                    }
                    case 3: {
                        entry = new EntryInteger(in.readInt());
                        break;
                    }
                    case 5: {
                        entry = new EntryLong(in.readLong());
                        entries.add(entry);
                        entry = new EntryNULL();
                        break;
                    }
                    case 4: {
                        entry = new EntryFloat(in.readFloat());
                        break;
                    }
                    case 6: {
                        entry = new EntryDouble(in.readDouble());
                        entries.add(entry);
                        entry = new EntryNULL();
                        break;
                    }
                    case 7: {
                        entry = new EntryClass(in.readShort());
                        break;
                    }
                    case 8: {
                        entry = new EntryString(in.readShort());
                        break;
                    }
                    case 12: {
                        entry = new EntryNameType(in.readShort(), in.readShort());
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        entry = new EntryFieldMethodRef(tagByte, in.readShort(), in.readShort());
                        break;
                    }
                    default: {
                        Logger.getLogger(ConstantPool.class.getName()).warning("Unknown tag byte: " + tagByte);
                        entry = new EntryNULL();
                    }
                }
                entries.add(entry);
            }
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
        }
        return new ConstantPool(entries);
    }

    public static class EntryFieldMethodRef
    extends Entry {
        private short classIndex;
        private short nameAndTypeIndex;

        public EntryFieldMethodRef(byte type, short classIndex, short nameAndTypeIndex) {
            super(type);
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }
    }

    public static class EntryNameType
    extends Entry {
        private short nameIndex;
        private short descriptorIndex;

        public EntryNameType(short nameIndex, short descriptorIndex) {
            super((byte)12);
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
        }

        public short getNameIndex() {
            return this.nameIndex;
        }

        public short getDescriptorIndex() {
            return this.descriptorIndex;
        }
    }

    public static class EntryString
    extends Entry {
        private short stringRef;

        public EntryString(short stringRef) {
            super((byte)8);
            this.stringRef = stringRef;
        }

        public short getStringRef() {
            return this.stringRef;
        }
    }

    public static class EntryClass
    extends Entry {
        private short classRef;

        public EntryClass(short classRef) {
            super((byte)7);
            this.classRef = classRef;
        }

        public short getClassRef() {
            return this.classRef;
        }
    }

    public static class EntryDouble
    extends Entry {
        private double d;

        public EntryDouble(double d) {
            super((byte)6);
            this.d = d;
        }

        public double getDouble() {
            return this.d;
        }
    }

    public static class EntryFloat
    extends Entry {
        private float f;

        public EntryFloat(float f) {
            super((byte)4);
            this.f = f;
        }

        public float getFloat() {
            return this.f;
        }
    }

    public static class EntryLong
    extends Entry {
        private long l;

        public EntryLong(long l) {
            super((byte)5);
            this.l = l;
        }

        public long getLong() {
            return this.l;
        }
    }

    public static class EntryInteger
    extends Entry {
        private int i;

        public EntryInteger(int i) {
            super((byte)3);
            this.i = i;
        }

        public int getInteger() {
            return this.i;
        }
    }

    public static class EntryUTF8
    extends Entry {
        private String utf8;

        public EntryUTF8(String utf8) {
            super((byte)1);
            this.utf8 = utf8;
        }

        public String getUTF8() {
            return this.utf8;
        }
    }

    public static class EntryNULL
    extends Entry {
        public EntryNULL() {
            super((byte)0);
        }
    }

    public static abstract class Entry {
        private final byte tag;

        protected Entry(byte tag) {
            this.tag = tag;
        }

        public final byte getTag() {
            return this.tag;
        }
    }
}

