/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.libraries.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.project.libraries.DefaultLibraryImplementation;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class LibrariesSupport {
    private LibrariesSupport() {
    }

    public static LibraryImplementation createLibraryImplementation(String libraryType, String[] volumeTypes) {
        return new DefaultLibraryImplementation(libraryType, volumeTypes);
    }

    public static LibraryTypeProvider getLibraryTypeProvider(String libraryType) {
        return LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryType);
    }

    public static LibraryTypeProvider[] getLibraryTypeProviders() {
        return LibraryTypeRegistry.getDefault().getLibraryTypeProviders();
    }

    public static URI convertFilePathToURI(String path) {
        try {
            File f = new File(path);
            if (f.isAbsolute()) {
                return f.toURI();
            }
            return new URI(null, null, path.replace('\\', '/'), null);
        }
        catch (URISyntaxException ex) {
            IllegalArgumentException y = new IllegalArgumentException();
            y.initCause(ex);
            throw y;
        }
    }

    public static String convertURIToFilePath(URI uri) {
        if (uri.isAbsolute()) {
            return new File(uri).getPath();
        }
        return uri.getPath().replace('/', File.separatorChar);
    }

    public static FileObject resolveLibraryEntryFileObject(URL libraryLocation, URI libraryEntry) {
        URI u = LibrariesSupport.resolveLibraryEntryURI(libraryLocation, libraryEntry);
        try {
            return URLMapper.findFileObject((URL)u.toURL());
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static URI resolveLibraryEntryURI(URL libraryLocation, URI libraryEntry) {
        Parameters.notNull((CharSequence)"libraryEntry", (Object)libraryEntry);
        if (libraryEntry.isAbsolute()) {
            return libraryEntry;
        }
        if (libraryLocation == null) {
            throw new IllegalArgumentException("cannot resolve relative URL without library location");
        }
        if (!"file".equals(libraryLocation.getProtocol())) {
            throw new IllegalArgumentException("not file: protocol - " + libraryLocation.toExternalForm());
        }
        File libLocation = new File(URI.create(libraryLocation.toExternalForm()));
        if (!libLocation.getName().endsWith(".properties")) {
            throw new IllegalArgumentException("library location must be a file - " + libraryLocation.toExternalForm());
        }
        File libBase = libLocation.getParentFile();
        String jarFolder = null;
        String libEntryPath = libraryEntry.getPath();
        int index = libEntryPath.indexOf("!/");
        if (index != -1) {
            libEntryPath = libEntryPath.substring(0, index);
            jarFolder = libraryEntry.getRawPath().substring(libraryEntry.getRawPath().indexOf("!/") + 2);
        }
        URI resolvedPath = FileUtil.normalizeFile((File)new File(libBase, libEntryPath)).toURI();
        if (jarFolder != null) {
            return URI.create("jar:" + resolvedPath.toString() + "!/" + jarFolder);
        }
        boolean relativeEndsWithSlash = libEntryPath.endsWith("/");
        String suri = resolvedPath.toString();
        boolean absoluteEndsWithSlash = suri.endsWith("/");
        if (relativeEndsWithSlash && !absoluteEndsWithSlash) {
            resolvedPath = URI.create(suri + '/');
        }
        return resolvedPath;
    }

    public static URI getArchiveFile(URI uri) {
        String u = uri.toString();
        int index = u.indexOf("!/");
        if (index != -1) {
            try {
                return new URI(u.substring(u.startsWith("jar:") ? 4 : 0, index));
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public static URI getArchiveRoot(URI uri) {
        assert (!uri.toString().contains("!/")) : uri;
        try {
            return new URI((uri.isAbsolute() ? "jar:" : "") + uri.toString() + "!/");
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

