/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.FolderList;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private final Panel firer;
    private WizardDescriptor wizardDescriptor;
    public static final String INITIAL_SOURCE_ROOT = "EXISTING_SOURCES_CURRENT_DIRECTORY";
    private JLabel description;
    private JPanel sourcePanel;
    private JPanel testsPanel;

    PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(PanelSourceFolders.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_JavaExtSourcesProjectLocation"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel);
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("files".equals(evt.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(evt.getPropertyName())) {
            if (evt.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)evt.getNewValue());
            } else if (evt.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)evt.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    @Override
    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        File projectLocation = (File)settings.getProperty("projdir");
        ((FolderList)this.sourcePanel).setProjectFolder(projectLocation);
        ((FolderList)this.testsPanel).setProjectFolder(projectLocation);
        File[] srcRoot = (File[])settings.getProperty("sourceRoot");
        assert (srcRoot != null) : "sourceRoot property must be initialized!";
        ((FolderList)this.sourcePanel).setFiles(srcRoot);
        File[] testRoot = (File[])settings.getProperty("testRoot");
        assert (testRoot != null) : "testRoot property must be initialized!";
        ((FolderList)this.testsPanel).setFiles(testRoot);
        File currentDirectory = null;
        FileObject folder = Templates.getExistingSourcesFolder((WizardDescriptor)this.wizardDescriptor);
        if (folder != null) {
            currentDirectory = FileUtil.toFile((FileObject)folder);
        }
        if (currentDirectory != null && currentDirectory.isDirectory()) {
            ((FolderList)this.sourcePanel).setLastUsedDir(currentDirectory);
            ((FolderList)this.testsPanel).setLastUsedDir(currentDirectory);
        }
    }

    @Override
    void store(WizardDescriptor settings) {
        File[] sourceRoots = ((FolderList)this.sourcePanel).getFiles();
        File[] testRoots = ((FolderList)this.testsPanel).getFiles();
        settings.putProperty("sourceRoot", (Object)sourceRoots);
        settings.putProperty("testRoot", (Object)testRoots);
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        File[] testRoots;
        File[] sourceRoots;
        File projectLocation = (File)settings.getProperty("projdir");
        String result = PanelSourceFolders.checkValidity(projectLocation, sourceRoots = ((FolderList)this.sourcePanel).getFiles(), testRoots = ((FolderList)this.testsPanel).getFiles());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    static String checkValidity(File projectLocation, File[] sources, File[] tests) {
        int i;
        String ploc = projectLocation.getAbsolutePath();
        for (i = 0; i < sources.length; ++i) {
            if (!sources[i].isDirectory() || !sources[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalSources"), sources[i].getAbsolutePath());
            }
            String sloc = sources[i].getAbsolutePath();
            if (!ploc.equals(sloc) && !ploc.startsWith(sloc + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (i = 0; i < tests.length; ++i) {
            if (!tests[i].isDirectory() || !tests[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalTests"), sources[i].getAbsolutePath());
            }
            String tloc = tests[i].getAbsolutePath();
            if (!ploc.equals(tloc) && !ploc.startsWith(tloc + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private static void findClassFiles(File folder, List<File> files) {
        File[] kids = folder.listFiles();
        if (kids == null) {
            return;
        }
        for (File kid : kids) {
            if (kid.isFile() && kid.getName().endsWith(".class")) {
                files.add(kid);
                continue;
            }
            if (!kid.isDirectory()) continue;
            PanelSourceFolders.findClassFiles(kid, files);
        }
    }

    private void searchClassFiles(File[] folders) throws WizardValidationException {
        ArrayList<File> classFiles = new ArrayList<File>();
        for (File folder : folders) {
            PanelSourceFolders.findClassFiles(folder, classFiles);
        }
        if (!classFiles.isEmpty()) {
            JButton DELETE_OPTION = new JButton(NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DeleteOption"));
            JButton KEEP_OPTION = new JButton(NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_KeepOption"));
            JButton CANCEL_OPTION = new JButton(NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_CancelOption"));
            DELETE_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_DeleteOption"));
            KEEP_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_KeepOption"));
            CANCEL_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_CancelOption"));
            NotifyDescriptor desc = new NotifyDescriptor((Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{DELETE_OPTION, KEEP_OPTION, CANCEL_OPTION}, (Object)DELETE_OPTION);
            Object result = DialogDisplayer.getDefault().notify(desc);
            if (DELETE_OPTION.equals(result)) {
                for (File f : classFiles) {
                    f.delete();
                }
            } else if (!KEEP_OPTION.equals(result)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void initComponents() {
        this.description = new JLabel();
        this.sourcePanel = this.createSourcePanel();
        this.testsPanel = this.createTestPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.description, (String)NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_SourceDirectoriesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.description, gridBagConstraints);
        this.description.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSN_jLabel3"));
        this.description.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSD_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.testsPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_PanelSourceFolders"));
    }

    private JPanel createSourcePanel() {
        return new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_RemoveSourceFolder"));
    }

    private JPanel createTestPanel() {
        return new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_RemoveTestFolder"));
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private ArrayList<ChangeListener> listeners;
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public void addChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public void readSettings(Object settings) {
            this.settings = (WizardDescriptor)settings;
            this.component.read(this.settings);
            Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.settings.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object settings) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PanelSourceFolders.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            Iterator it = null;
            Panel panel = this;
            synchronized (panel) {
                if (this.listeners == null) {
                    return;
                }
                it = ((ArrayList)this.listeners.clone()).iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }
    }
}

