/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public abstract class BaseRubyCustomizerProvider
implements CustomizerProvider {
    private final Project project;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFileHelper;
    private static Map<Project, Dialog> project2Dialog = new HashMap<Project, Dialog>();

    public BaseRubyCustomizerProvider(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper, GeneratedFilesHelper genFileHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.genFileHelper = genFileHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    protected abstract SharedRubyProjectProperties createUiProperties(Project var1, UpdateHelper var2, PropertyEvaluator var3, ReferenceHelper var4, GeneratedFilesHelper var5);

    protected abstract String getCustomizerFolderPath();

    public void showCustomizer(String preselectedCategory, String preselectedSubCategory) {
        Dialog dialog = project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        SharedRubyProjectProperties uiProperties = this.createUiProperties(this.project, this.updateHelper, this.evaluator, this.refHelper, this.genFileHelper);
        Lookup context = Lookups.fixed((Object[])new Object[]{this.project, uiProperties, new SubCategoryProvider(preselectedCategory, preselectedSubCategory)});
        OptionListener listener = new OptionListener(this.project, uiProperties);
        dialog = ProjectCustomizer.createCustomizerDialog((String)this.getCustomizerFolderPath(), (Lookup)context, (String)preselectedCategory, (ActionListener)listener, null);
        dialog.addWindowListener(listener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage(BaseRubyCustomizerProvider.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.setVisible(true);
    }

    static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String category, String subcategory) {
            this.category = category;
            this.subcategory = subcategory;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private SharedRubyProjectProperties uiProperties;

        OptionListener(Project project, SharedRubyProjectProperties uiProperties) {
            this.project = project;
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.uiProperties.save();
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            project2Dialog.remove(this.project);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }
}

