/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.bundler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.RequiredGems;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.bundler.BundlerAction;
import org.netbeans.modules.ruby.rubyproject.bundler.BundlerLineConvertor;
import org.netbeans.modules.ruby.rubyproject.spi.PropertiesProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public final class BundlerSupport {
    private static final List<Task> DEFAULT_TASKS = new ArrayList<Task>();
    private static final String[] FILTERED_TASKS;
    private static final String BUNDLE = "bundle";
    private static final String BUNDLER_GEM = "bundler";
    private final RubyBaseProject project;
    private static final Map<RubyPlatform, List<Task>> TASKS_CACHE;
    private String bundle;
    private Future<Integer> result;
    private boolean installed;
    private boolean initialized;

    public BundlerSupport(RubyBaseProject project) {
        this.project = project;
    }

    public void initialize() {
        this.initialized = true;
        RubyPlatform platform = this.getPlatform();
        if (platform == null) {
            return;
        }
        this.bundle = platform.findExecutable(BUNDLE);
        if (this.bundle == null) {
            return;
        }
        GemManager gemManager = platform.getGemManager();
        if (gemManager == null) {
            return;
        }
        this.installed = gemManager.isGemInstalled(BUNDLER_GEM);
        if (this.installed) {
            this.fetchTasks();
        }
    }

    public boolean installed() {
        assert (this.initialized) : "not initialized";
        return this.installed;
    }

    private RubyPlatform getPlatform() {
        return RubyPlatform.platformFor((Project)this.project);
    }

    public Action createAction() {
        return new BundlerAction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Task> getTasks() {
        assert (this.initialized) : "not initialized";
        RubyPlatform platform = this.getPlatform();
        Map<RubyPlatform, List<Task>> map = TASKS_CACHE;
        synchronized (map) {
            List<Task> tasks;
            if (TASKS_CACHE.containsKey(platform) && !(tasks = TASKS_CACHE.get(platform)).isEmpty()) {
                return BundlerSupport.filter(tasks);
            }
        }
        return DEFAULT_TASKS;
    }

    Future<Integer> runBundlerTask(String name, LineConvertor convertor, boolean displayOutput, Runnable postBuild) {
        assert (this.initialized);
        RubyExecutionDescriptor descriptor = new RubyExecutionDescriptor(this.getPlatform(), NbBundle.getMessage(BundlerSupport.class, (String)"Bundler"), FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        descriptor.cmd(new File(this.bundle));
        descriptor.additionalArgs(new String[]{name});
        if (convertor != null) {
            descriptor.addOutConvertor(convertor);
        }
        if (postBuild != null) {
            descriptor = descriptor.postBuild(postBuild);
        }
        descriptor.setOutProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.ansiStripping((InputProcessor)defaultProcessor);
            }
        });
        RubyProcessCreator rpc = new RubyProcessCreator(descriptor);
        ExecutionDescriptor ed = descriptor.toExecutionDescriptor();
        if (!displayOutput) {
            ed = ed.inputOutput(InputOutput.NULL);
        }
        return ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)ed, (String)descriptor.getDisplayName()).run();
    }

    void updateIndices() {
        final BundlerLineConvertor convertor = new BundlerLineConvertor();
        Runnable updateTask = new Runnable(){

            @Override
            public void run() {
                if (!convertor.getGems().isEmpty()) {
                    RequiredGems requiredGems = null;
                    for (RequiredGems each : BundlerSupport.this.project.getLookup().lookupAll(RequiredGems.class)) {
                        if (each.isForTests()) continue;
                        requiredGems = each;
                        break;
                    }
                    requiredGems.setRequiredGems(convertor.getGems());
                    SharedRubyProjectProperties properties = ((PropertiesProvider)BundlerSupport.this.project.getLookup().lookup(PropertiesProvider.class)).getProperties();
                    properties.setGemRequirements(requiredGems.getGemRequirements());
                    properties.save();
                }
            }
        };
        this.runBundlerTask("show", convertor, true, updateTask);
    }

    boolean canUpdateIndices() {
        return !(this.project instanceof RubyProject);
    }

    private static List<Task> filter(List<Task> toFilter) {
        ArrayList<Task> result = new ArrayList<Task>(toFilter.size());
        for (Task each : toFilter) {
            for (String filtered : FILTERED_TASKS) {
                if (filtered.equals(each.name)) continue;
                result.add(each);
            }
        }
        return result;
    }

    private void fetchTasks() {
        final RubyPlatform platform = this.getPlatform();
        if (TASKS_CACHE.containsKey(platform)) {
            return;
        }
        if (this.result == null) {
            final TaskCollector collector = new TaskCollector();
            this.result = this.runBundlerTask("help", collector, false, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = TASKS_CACHE;
                    synchronized (map) {
                        TASKS_CACHE.put(platform, collector.tasks);
                    }
                }
            });
        }
    }

    static {
        DEFAULT_TASKS.add(new Task("check", "Checks if the dependencies listed in Gemfile are satisfied by currently installed gems"));
        DEFAULT_TASKS.add(new Task("init", "Generates a Gemfile into the current working directory"));
        DEFAULT_TASKS.add(new Task("install", "Install the current environment to the system"));
        DEFAULT_TASKS.add(new Task("lock", "Locks the bundle to the current set of dependencies, including all child dependencies."));
        DEFAULT_TASKS.add(new Task("pack", "Packs all the gems to vendor/cache"));
        DEFAULT_TASKS.add(new Task("show", "Shows all gems that are part of the bundle."));
        DEFAULT_TASKS.add(new Task("unlock", "Unlock the bundle. This allows gem versions to be changed."));
        FILTERED_TASKS = new String[]{"exec"};
        TASKS_CACHE = new WeakHashMap<RubyPlatform, List<Task>>();
    }

    static final class TaskCollector
    implements LineConvertor {
        private static final Pattern PATTERN = Pattern.compile("\\s*bundle\\s(\\S+)\\s+.*#\\s(.+)");
        private final List<Task> tasks = new ArrayList<Task>();

        TaskCollector() {
        }

        public List<ConvertedLine> convert(String line) {
            Task task = TaskCollector.parse(line);
            if (task != null) {
                this.tasks.add(task);
            }
            return null;
        }

        static Task parse(String line) {
            Matcher matcher = PATTERN.matcher(line);
            if (!matcher.matches()) {
                return null;
            }
            return new Task(matcher.group(1), matcher.group(2));
        }
    }

    static class Task {
        final String name;
        final String descriptor;

        public Task(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }
    }
}

