/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubyProjectProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectGenerator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RubyProjectGenerator {
    public static final String DEFAULT_SRC_NAME = "src.dir";
    public static final String DEFAULT_TEST_SRC_NAME = "test.src.dir";
    public static final String DEFAULT_SPEC_SRC_NAME = "spec.src.dir";

    private RubyProjectGenerator() {
    }

    public static RakeProjectHelper createProject(File dir, String prjName, String mainClass, RubyPlatform platform) throws IOException {
        FileObject dirFO = FileUtil.createFolder((File)dir);
        RakeProjectHelper helper = RubyProjectGenerator.createBasicProjectMetadata(dirFO, prjName, "lib", "test", "spec", mainClass, platform);
        Project project = ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject(project);
        FileObject srcFolder = dirFO.createFolder("lib");
        dirFO.createFolder("test");
        dirFO.createFolder("spec");
        if (mainClass != null) {
            RubyProjectGenerator.createFromTemplate(mainClass, srcFolder, "Templates/Ruby/main.rb");
        }
        HashMap<String, String> rakeProps = new HashMap<String, String>();
        rakeProps.put("PROJECT_NAME", dir.getName());
        if (RSpecSupport.hasRSpecInstalled(platform)) {
            rakeProps.put("REQUIRE_SPEC_TASK", "require 'spec/rake/spectask'\n");
            StringBuilder dirLibs = new StringBuilder();
            RubyBaseProject baseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
            FileObject[] roots = baseProject.getSourceRootFiles();
            for (int i = 0; i < roots.length; ++i) {
                dirLibs.append("\"");
                dirLibs.append(roots[i].getName());
                dirLibs.append("\"");
                if (i + 1 >= roots.length) continue;
                dirLibs.append(",");
            }
            String specTaskDef = "\nSpec::Rake::SpecTask.new do |t|\n  t.spec_files = FileList['spec/**/*.rb']\n  t.libs << Dir[" + dirLibs.toString() + "]\n" + "end";
            rakeProps.put("SPEC_TASK_DEF", specTaskDef);
        } else {
            rakeProps.put("REQUIRE_SPEC_TASK", "");
            rakeProps.put("SPEC_TASK_DEF", "");
        }
        RubyProjectGenerator.createFromTemplate("Rakefile", dirFO, "Templates/Ruby/Rakefile", rakeProps);
        RubyProjectGenerator.createFileWithContent(dirFO, "README", "TXT_README_Content", prjName);
        RubyProjectGenerator.createFileWithContent(dirFO, "LICENSE", "TXT_LICENSE_Content", prjName);
        RakeSupport.refreshTasks(project);
        return helper;
    }

    public static RakeProjectHelper createProject(File dir, final String prjName, final File[] sourceFolders, final File[] testFolders, RubyPlatform platform) throws IOException {
        assert (sourceFolders != null && testFolders != null) : "Package roots can't be null";
        FileObject dirFO = FileUtil.createFolder((File)dir);
        final RakeProjectHelper helper = RubyProjectGenerator.createBasicProjectMetadata(dirFO, prjName, null, null, null, null, platform);
        final RubyProject project = (RubyProject)ProjectManager.getDefault().findProject(dirFO);
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    RubyProjectGenerator.createProjectMetadata(project, helper, sourceFolders, testFolders, prjName);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            ErrorManager.getDefault().notify((Throwable)me);
        }
        RakeSupport.refreshTasks(project);
        return helper;
    }

    private static void createProjectMetadata(RubyProject project, RakeProjectHelper helper, File[] sourceFolders, File[] testFolders, String prjName) throws IOException {
        Element root;
        EditableProperties props;
        int rootIndex;
        String propName;
        int i;
        ReferenceHelper refHelper = project.getReferenceHelper();
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", "source-roots");
        assert (nl.getLength() == 1);
        Element sourceRoots = (Element)nl.item(0);
        nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", "test-roots");
        assert (nl.getLength() == 1);
        Element testRoots = (Element)nl.item(0);
        for (i = 0; i < sourceFolders.length; ++i) {
            if (i == 0) {
                propName = DEFAULT_SRC_NAME;
            } else {
                String name = sourceFolders[i].getName();
                propName = name + ".dir";
            }
            rootIndex = 1;
            props = helper.getProperties("nbproject/project.properties");
            while (props.containsKey((Object)propName)) {
                propName = prjName + ++rootIndex + ".dir";
            }
            String srcReference = refHelper.createForeignFileReference(sourceFolders[i], "ruby");
            root = doc.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            root.setAttribute("id", propName);
            sourceRoots.appendChild(root);
            props = helper.getProperties("nbproject/project.properties");
            props.put(propName, srcReference);
            helper.putProperties("nbproject/project.properties", props);
        }
        for (i = 0; i < testFolders.length; ++i) {
            if (!testFolders[i].exists()) {
                testFolders[i].mkdirs();
            }
            if (i == 0) {
                propName = DEFAULT_TEST_SRC_NAME;
            } else {
                String name = testFolders[i].getName();
                propName = "test." + name + ".dir";
            }
            rootIndex = 1;
            props = helper.getProperties("nbproject/project.properties");
            while (props.containsKey((Object)propName)) {
                propName = "test." + prjName + ++rootIndex + ".dir";
            }
            String testReference = refHelper.createForeignFileReference(testFolders[i], "ruby");
            root = doc.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            root.setAttribute("id", propName);
            testRoots.appendChild(root);
            props = helper.getProperties("nbproject/project.properties");
            props.put(propName, testReference);
            helper.putProperties("nbproject/project.properties", props);
        }
        helper.putPrimaryConfigurationData(data, true);
        ProjectManager.getDefault().saveProject((Project)project);
    }

    private static RakeProjectHelper createBasicProjectMetadata(FileObject dirFO, String name, String srcRoot, String testRoot, String specRoot, String mainClass, RubyPlatform platform) throws IOException {
        Element root;
        RakeProjectHelper helper = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.ruby.rubyproject");
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "source-roots");
        if (srcRoot != null) {
            Element root2 = doc.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            root2.setAttribute("id", DEFAULT_SRC_NAME);
            sourceRoots.appendChild(root2);
            ep.setProperty(DEFAULT_SRC_NAME, srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "test-roots");
        if (testRoot != null) {
            root = doc.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            root.setAttribute("id", DEFAULT_TEST_SRC_NAME);
            testRoots.appendChild(root);
            ep.setProperty(DEFAULT_TEST_SRC_NAME, testRoot);
        }
        if (specRoot != null) {
            root = doc.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            root.setAttribute("id", DEFAULT_SPEC_SRC_NAME);
            testRoots.appendChild(root);
            ep.setProperty(DEFAULT_SPEC_SRC_NAME, specRoot);
        }
        data.appendChild(testRoots);
        helper.putPrimaryConfigurationData(data, true);
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        ep.setProperty("main.file", mainClass == null ? "" : mainClass);
        RubyProjectProperties.storePlatform(ep, platform);
        helper.putProperties("nbproject/project.properties", ep);
        Util.logUsage(RubyProjectGenerator.class, "USG_PROJECT_CREATE_RUBY", platform.getInfo().getKind(), platform.getInfo().getPlatformVersion(), platform.getInfo().getGemVersion());
        return helper;
    }

    private static DataObject createFromTemplate(String mainClassName, FileObject srcFolder, String templateName) throws IOException {
        return RubyProjectGenerator.createFromTemplate(mainClassName, srcFolder, templateName, null);
    }

    private static DataObject createFromTemplate(String mainClassName, FileObject srcFolder, String templateName, Map<String, ? extends Object> props) throws IOException {
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(47);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return null;
        }
        FileObject mainTemplate = FileUtil.getConfigFile((String)templateName);
        if (mainTemplate == null) {
            return null;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        mName = Util.stripExtension(mName, ".rb");
        if (props != null) {
            return mt.createFromTemplate(pDf, mName, props);
        }
        return mt.createFromTemplate(pDf, mName);
    }

    private static void createFileWithContent(FileObject dirFO, String fileName, String contentKey, String prjName) throws IOException {
        FileObject newFile = dirFO.createData(fileName);
        RubyProjectGenerator.writeLines(newFile, NbBundle.getMessage(RubyProjectGenerator.class, (String)contentKey, (Object)prjName));
    }

    private static void writeLines(FileObject readme, String ... lines) throws FileAlreadyLockedException, IOException {
        PrintWriter readmeW = new PrintWriter(new OutputStreamWriter(readme.getOutputStream(), "UTF-8"));
        for (String line : lines) {
            readmeW.println(line);
        }
        readmeW.close();
    }
}

