/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.MessageFormat;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.NbBundle;

class QueryResultHandleImpl
extends QueryResultHandle
implements ActionListener {
    private final Query query;
    private final String label;
    private final String tooltip;
    private final Filter filter;
    private final QueryResultHandle.ResultType type;
    private static MessageFormat totalFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultTotal"));
    private static MessageFormat unseenFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultUnseen"));
    private static MessageFormat newFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultNew"));
    private static MessageFormat totalTooltipFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultTotalTooltip"));
    private static MessageFormat unseenTooltipFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultUnseenTooltip"));
    private static MessageFormat newTooltipFormat = new MessageFormat(NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultNewTooltip"));

    QueryResultHandleImpl(Query query, String label, String tooltip, Filter filter, QueryResultHandle.ResultType type) {
        this.query = query;
        this.label = label;
        this.tooltip = tooltip;
        this.filter = filter;
        this.type = type;
    }

    public String getText() {
        return this.label;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public QueryResultHandle.ResultType getResultType() {
        return this.type;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BugtrackingConnector[] connectors;
        for (BugtrackingConnector c : connectors = BugtrackingUtil.getBugtrackingConnectors()) {
            KenaiSupport support = (KenaiSupport)c.getLookup().lookup(KenaiSupport.class);
            support.setFilter(this.query, this.filter);
        }
        BugtrackingUtil.openQuery((Query)this.query, null, (boolean)true);
    }

    static QueryResultHandleImpl forStatus(Query query, int status) {
        switch (status) {
            case 14: {
                Issue[] issues = query.getIssues(status);
                int issueCount = issues != null ? issues.length : 0;
                return new QueryResultHandleImpl(query, totalFormat.format(new Object[]{issueCount}, new StringBuffer(), (FieldPosition)null).toString(), QueryResultHandleImpl.getTotalTooltip(issueCount), Filter.getAllFilter((Query)query), QueryResultHandle.ResultType.NAMED_RESULT);
            }
            case 12: {
                int unseenIssues = 0;
                Issue[] issues = query.getIssues(12);
                if (issues == null || issues.length == 0) {
                    return null;
                }
                unseenIssues = issues.length;
                String label = unseenFormat.format(new Object[]{unseenIssues}, new StringBuffer(), (FieldPosition)null).toString();
                String tooltip = QueryResultHandleImpl.getUnseenTooltip(unseenIssues);
                return new QueryResultHandleImpl(query, label, tooltip, Filter.getNotSeenFilter((Query)query), QueryResultHandle.ResultType.NAMED_RESULT);
            }
            case 4: {
                int newIssues = 0;
                Issue[] issues = query.getIssues(4);
                if (issues == null || issues.length == 0) {
                    return null;
                }
                newIssues = issues.length;
                String tooltip = QueryResultHandleImpl.getNewTooltip(newIssues);
                String label = newFormat.format(new Object[]{newIssues}, new StringBuffer(), (FieldPosition)null).toString();
                return new QueryResultHandleImpl(query, label, tooltip, Filter.getNewFilter((Query)query), QueryResultHandle.ResultType.NAMED_RESULT);
            }
        }
        throw new IllegalStateException("wrong status value [" + status + "]");
    }

    static QueryResultHandle getAllChangedResult(Query query) {
        int notIssues = 0;
        Issue[] issues = query.getIssues(12);
        notIssues = issues != null ? issues.length : 0;
        return new QueryResultHandleImpl(query, Integer.toString(notIssues), QueryResultHandleImpl.getUnseenTooltip(notIssues), Filter.getNotSeenFilter((Query)query), QueryResultHandle.ResultType.ALL_CHANGES_RESULT);
    }

    private static String getTotalTooltip(int issueCount) {
        if (issueCount == 1) {
            return NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultTotal1Tooltip");
        }
        return totalTooltipFormat.format(new Object[]{issueCount}, new StringBuffer(), (FieldPosition)null).toString();
    }

    private static String getNewTooltip(int newIssues) {
        if (newIssues == 1) {
            return NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultNew1Tooltip");
        }
        return newTooltipFormat.format(new Object[]{newIssues}, new StringBuffer(), (FieldPosition)null).toString();
    }

    private static String getUnseenTooltip(int unseenIssues) {
        if (unseenIssues == 1) {
            return NbBundle.getMessage(QueryResultHandleImpl.class, (String)"LBL_QueryResultUnseen1Tooltip");
        }
        return unseenTooltipFormat.format(new Object[]{unseenIssues}, new StringBuffer(), (FieldPosition)null).toString();
    }
}

