/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.resource;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.openide.util.Utilities;

public class ResourceItemPanel
extends JLabel
implements MouseListener {
    private static Border SELECTED_RESOURCE_BORDER = new LineBorder(MainPanel.SELECT_COLOR, 2, false);
    private static Border HOVER_RESOURCE_BORDER = new LineBorder(MainPanel.HOVER_COLOR, 2, false);
    private static Border RESOURCE_BORDER = new EmptyBorder(2, 2, 2, 2);
    private DesignComponent component;
    private boolean selected;
    private boolean hovered;
    private DragSource dragSource;
    private DragListener listener;
    private DropTarget dropTarget;

    public ResourceItemPanel(DesignComponent component) {
        this.component = component;
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.listener = new DragListener();
        this.initDragAndDrop();
    }

    private void initDragAndDrop() {
        this.dragSource = new DragSource();
        this.dropTarget = new DropTarget(this, new DropListener());
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this.listener);
    }

    public void reload() {
        InfoPresenter infoPresenter = (InfoPresenter)this.component.getPresenter(InfoPresenter.class);
        ScreenResourceItemPresenter itemPresenter = (ScreenResourceItemPresenter)this.component.getPresenter(ScreenResourceItemPresenter.class);
        assert (infoPresenter != null) : "Null InfoPresenter";
        assert (itemPresenter != null) : "Null ScreenResourceItemPresenter";
        InfoPresenter.NameType nameType = itemPresenter.getNameType();
        Image image = infoPresenter.getIcon(InfoPresenter.IconType.COLOR_16x16);
        this.setIcon(image != null ? new ImageIcon(image) : null);
        this.selected = this.component.getDocument().getSelectedComponents().contains(this.component);
        this.resolveBorder();
        this.setText(infoPresenter.getDisplayName(nameType));
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.doSelect(e);
    }

    private void doSelect(final MouseEvent e) {
        final DesignDocument doc = this.component.getDocument();
        final ArrayList newSelection = new ArrayList();
        doc.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                if ((e.getModifiersEx() & 0x80) == 128) {
                    Collection currentSelection = doc.getSelectedComponents();
                    newSelection.addAll(currentSelection);
                    if (currentSelection.contains(ResourceItemPanel.this.component)) {
                        newSelection.remove(ResourceItemPanel.this.component);
                    } else {
                        newSelection.add(ResourceItemPanel.this.component);
                    }
                } else {
                    newSelection.add(ResourceItemPanel.this.component);
                }
                doc.setSelectedComponents("screen", newSelection);
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doSelect(e);
            Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)this.component), (Component)this).show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doSelect(e);
            Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)this.component), (Component)this).show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hovered = true;
        this.resolveBorder();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hovered = false;
        this.resolveBorder();
    }

    private void resolveBorder() {
        if (this.hovered) {
            this.setBorder(HOVER_RESOURCE_BORDER);
        } else {
            this.setBorder(this.selected ? SELECTED_RESOURCE_BORDER : RESOURCE_BORDER);
        }
    }

    private class ScreenTransferable
    implements Transferable {
        private DesignComponent component;

        public ScreenTransferable(DesignComponent component) {
            this.component = component;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR) {
                return this.component;
            }
            return null;
        }
    }

    private class DropListener
    implements DropTargetListener {
        private DropListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            ResourceItemPanel.this.hovered = true;
            ResourceItemPanel.this.resolveBorder();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            dtde.rejectDrag();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            ResourceItemPanel.this.hovered = false;
            ResourceItemPanel.this.resolveBorder();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
        }
    }

    private class DragListener
    implements DragGestureListener {
        private ScreenTransferable flavor;

        private DragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dgEvent) {
            if (this.flavor == null) {
                this.flavor = new ScreenTransferable(ResourceItemPanel.this.component);
            }
            try {
                dgEvent.startDrag(null, this.flavor);
            }
            catch (InvalidDnDOperationException e) {
                e.printStackTrace();
            }
        }
    }
}

