/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Map<ClassLoader, ConcurrentMap<String, MetaData>> REFLECTION_CACHE = new WeakHashMap<ClassLoader, ConcurrentMap<String, MetaData>>();

    private ReflectionUtils() {
    }

    public static synchronized void clearCache(ClassLoader loader) {
        REFLECTION_CACHE.remove(loader);
    }

    public static synchronized void initCache(ClassLoader loader) {
        if (REFLECTION_CACHE.get(loader) == null) {
            REFLECTION_CACHE.put(loader, new ConcurrentHashMap());
        }
    }

    public static Constructor lookupConstructor(Class<?> clazz, Class<?> ... params) {
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupConstructor(params);
    }

    public static Method lookupMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupMethod(methodName, params);
    }

    public static Object newInstance(String className) throws InstantiationException, IllegalAccessException {
        ClassLoader loader = Util.getCurrentLoader(null);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, className).lookupClass().newInstance();
    }

    public static Class<?> lookupClass(String className) {
        ClassLoader loader = Util.getCurrentLoader(null);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, className).lookupClass();
    }

    private static MetaData getMetaData(ClassLoader loader, Class<?> clazz) {
        MetaData meta;
        ConcurrentMap<String, MetaData> cache = REFLECTION_CACHE.get(loader);
        if (cache == null) {
            ReflectionUtils.initCache(loader);
            cache = REFLECTION_CACHE.get(loader);
        }
        if ((meta = (MetaData)cache.get(clazz.getName())) == null) {
            meta = new MetaData(clazz);
            cache.put(clazz.getName(), meta);
        }
        return meta;
    }

    private static MetaData getMetaData(ClassLoader loader, String className) {
        MetaData meta;
        ConcurrentMap<String, MetaData> cache = REFLECTION_CACHE.get(loader);
        if (cache == null) {
            ReflectionUtils.initCache(loader);
            cache = REFLECTION_CACHE.get(loader);
        }
        if ((meta = (MetaData)cache.get(className)) == null) {
            try {
                Class clazz = Util.loadClass(className, cache);
                meta = new MetaData(clazz);
                cache.put(className, meta);
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return meta;
    }

    public static class ReflectionUtilsListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent servletContextEvent) {
            ReflectionUtils.initCache(Thread.currentThread().getContextClassLoader());
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
            ReflectionUtils.clearCache(Thread.currentThread().getContextClassLoader());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetaData {
        Map<Integer, Constructor> constructors;
        Map<String, HashMap<Integer, Method>> methods;
        Map<String, HashMap<Integer, Method>> declaredMethods;
        Class<?> clazz;

        public MetaData(Class<?> clazz) {
            int i;
            String name = null;
            this.clazz = clazz;
            Constructor<?>[] ctors = clazz.getConstructors();
            this.constructors = new HashMap<Integer, Constructor>(ctors.length, 1.0f);
            int len = ctors.length;
            for (int i2 = 0; i2 < len; ++i2) {
                this.constructors.put(MetaData.getKey(ctors[i2].getParameterTypes()), ctors[i2]);
            }
            Method[] meths = clazz.getMethods();
            this.methods = new HashMap<String, HashMap<Integer, Method>>(meths.length, 1.0f);
            int len2 = meths.length;
            for (i = 0; i < len2; ++i) {
                name = meths[i].getName();
                HashMap<Integer, Method> methodsMap = this.methods.get(name);
                if (methodsMap == null) {
                    methodsMap = new HashMap(4, 1.0f);
                    this.methods.put(name, methodsMap);
                }
                methodsMap.put(MetaData.getKey(meths[i].getParameterTypes()), meths[i]);
            }
            meths = clazz.getDeclaredMethods();
            this.declaredMethods = new HashMap<String, HashMap<Integer, Method>>(meths.length, 1.0f);
            len2 = meths.length;
            for (i = 0; i < len2; ++i) {
                name = meths[i].getName();
                HashMap<Integer, Method> declaredMethodsMap = this.declaredMethods.get(name);
                if (declaredMethodsMap == null) {
                    declaredMethodsMap = new HashMap(4, 1.0f);
                    this.declaredMethods.put(name, declaredMethodsMap);
                }
                declaredMethodsMap.put(MetaData.getKey(meths[i].getParameterTypes()), meths[i]);
            }
        }

        public Constructor lookupConstructor(Class<?> ... params) {
            return this.constructors.get(MetaData.getKey(params));
        }

        public Method lookupMethod(String name, Class<?> ... params) {
            Map map = this.methods.get(name);
            Integer key = MetaData.getKey(params);
            Method result = null;
            if ((null == map || null == (result = (Method)map.get(key))) && null != (map = (Map)this.declaredMethods.get(name))) {
                result = (Method)map.get(key);
            }
            return result;
        }

        public Class<?> lookupClass() {
            return this.clazz;
        }

        private static Integer getKey(Class<?> ... params) {
            return Arrays.deepHashCode(params);
        }
    }
}

