/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.Clusterize;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerJavadoc;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerSources;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsSupport;
import org.netbeans.modules.apisupport.project.universe.SourceRootsSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class EditClusterPanel
extends JPanel
implements DocumentListener {
    private NbPlatformCustomizerSources sourcesPanel;
    private NbPlatformCustomizerJavadoc javadocPanel;
    private JButton okButton;
    private File prjDir;
    private Project prj;
    private JButton browseButton;
    private JLabel clusterDir;
    private JTextField clusterDirText;
    private JPanel javadocPanelContainer;
    private JPanel mainPanel;
    private JPanel sourcesPanelContainer;
    private JTabbedPane tabbedPanel;

    static ClusterInfo showAddDialog(Project prj) {
        EditClusterPanel panel = new EditClusterPanel();
        panel.prjDir = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        panel.prj = prj;
        SourceRootsSupport srs = new SourceRootsSupport(new URL[0], null);
        panel.sourcesPanel.setSourceRootsProvider(srs);
        JavadocRootsSupport jrs = new JavadocRootsSupport(new URL[0], null);
        panel.javadocPanel.setJavadocRootsProvider(jrs);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(EditClusterPanel.class, (String)"CTL_AddCluster_Title"), true, new Object[]{panel.okButton, NotifyDescriptor.CANCEL_OPTION}, (Object)panel.okButton, 0, new HelpCtx(EditClusterPanel.class), null);
        descriptor.setClosingOptions(null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        panel.updateDialog();
        dlg.setVisible(true);
        ClusterInfo retVal = null;
        if (descriptor.getValue() == panel.okButton) {
            retVal = ClusterInfo.createExternal(panel.getAbsoluteClusterPath(), srs.getSourceRoots(), jrs.getJavadocRoots(), true);
        }
        dlg.dispose();
        return retVal;
    }

    static ClusterInfo showEditDialog(ClusterInfo ci, Project prj) {
        EditClusterPanel panel = new EditClusterPanel();
        panel.prjDir = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        panel.prj = prj;
        SourceRootsSupport srs = new SourceRootsSupport(ci.getSourceRoots() == null ? new URL[]{} : ci.getSourceRoots(), null);
        panel.sourcesPanel.setSourceRootsProvider(srs);
        JavadocRootsSupport jrs = new JavadocRootsSupport(ci.getJavadocRoots() == null ? new URL[]{} : ci.getJavadocRoots(), null);
        panel.javadocPanel.setJavadocRootsProvider(jrs);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(EditClusterPanel.class, (String)"CTL_EditCluster_Title"), true, new Object[]{panel.okButton, NotifyDescriptor.CANCEL_OPTION}, (Object)panel.okButton, 0, new HelpCtx(EditClusterPanel.class), null);
        descriptor.setClosingOptions(null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        panel.clusterDirText.setText(ci.getClusterDir().toString());
        panel.updateDialog();
        panel.browseButton.setEnabled(false);
        dlg.setVisible(true);
        ClusterInfo retVal = null;
        if (descriptor.getValue() == panel.okButton) {
            retVal = ClusterInfo.createExternal(panel.getAbsoluteClusterPath(), srs.getSourceRoots(), jrs.getJavadocRoots(), true);
        }
        dlg.dispose();
        return retVal;
    }

    public EditClusterPanel() {
        this.initComponents();
        this.sourcesPanel = new NbPlatformCustomizerSources();
        this.sourcesPanelContainer.add(this.sourcesPanel);
        this.javadocPanel = new NbPlatformCustomizerJavadoc();
        this.javadocPanelContainer.add(this.javadocPanel);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(EditClusterPanel.class, (String)"CTL_OK"));
    }

    private File getAbsoluteClusterPath() {
        String maybeRelPath = this.clusterDirText.getText();
        return PropertyUtils.resolveFile((File)this.prjDir, (String)maybeRelPath);
    }

    private void initComponents() {
        this.tabbedPanel = new JTabbedPane();
        this.mainPanel = new JPanel();
        this.browseButton = new JButton();
        this.clusterDir = new JLabel();
        this.clusterDirText = new JTextField();
        this.sourcesPanelContainer = new JPanel();
        this.javadocPanelContainer = new JPanel();
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditClusterPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.clusterDir.setLabelFor(this.clusterDirText);
        Mnemonics.setLocalizedText((JLabel)this.clusterDir, (String)NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.clusterDir.text"));
        this.clusterDirText.setEditable(false);
        this.clusterDirText.setText(NbBundle.getMessage(EditClusterPanel.class, (String)"MSG_BrowseForCluster"));
        this.clusterDirText.getDocument().addDocumentListener(this);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.clusterDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clusterDirText, -1, 292, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clusterDir).addComponent(this.clusterDirText, -2, -1, -2).addComponent(this.browseButton)).addContainerGap(470, Short.MAX_VALUE)));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.browseButton.AccessibleContext.accessibleDescription"));
        this.clusterDirText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.clusterDirText.AccessibleContext.accessibleDescription"));
        this.tabbedPanel.addTab(NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.mainPanel.TabConstraints.tabTitle"), this.mainPanel);
        this.sourcesPanelContainer.setLayout(new BorderLayout());
        this.tabbedPanel.addTab(NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.sourcesPanelContainer.TabConstraints.tabTitle"), this.sourcesPanelContainer);
        this.javadocPanelContainer.setLayout(new BorderLayout());
        this.tabbedPanel.addTab(NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.javadocPanelContainer.TabConstraints.tabTitle"), this.javadocPanelContainer);
        this.add((Component)this.tabbedPanel, "Center");
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.AccessibleContext.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        block2: {
            JFileChooser chooser = new JFileChooser(ModuleUISettings.getDefault().getLastUsedClusterLocation());
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileSelectionMode(1);
            int ret = chooser.showOpenDialog(this);
            if (ret != 0) break block2;
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            while (!file.exists() || file.isFile() || !ClusterUtils.isValidCluster(file)) {
                if (Clusterize.clusterize(this.prj, file)) {
                    continue;
                }
                break block2;
            }
            ModuleUISettings.getDefault().setLastUsedClusterLocation(file.getParentFile().getAbsolutePath());
            String relPath = PropertyUtils.relativizeFile((File)this.prjDir, (File)file);
            this.clusterDirText.setText(relPath != null ? relPath : file.getAbsolutePath());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateDialog();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateDialog();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateDialog();
    }

    private void updateDialog() {
        this.okButton.setEnabled(this.getAbsoluteClusterPath().exists());
    }
}

