/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.text.Collator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.ModuleDependency;

final class AddModuleFilter {
    private final Set<ModuleDependency> universe;
    private final String dependingModuleCNB;

    public AddModuleFilter(Set<ModuleDependency> universe, String dependingModuleCNB) {
        this.universe = universe;
        this.dependingModuleCNB = dependingModuleCNB;
        for (ModuleDependency dep : universe) {
            if (Thread.interrupted()) break;
            dep.getFilterTokens(dependingModuleCNB);
        }
    }

    public Set<ModuleDependency> getMatches(String text) {
        String textLC = text.toLowerCase(Locale.ENGLISH);
        ArrayList<TreeSet<ModuleDependency>> matches = new ArrayList<TreeSet<ModuleDependency>>(3);
        for (int i = 0; i < 3; ++i) {
            matches.add(new TreeSet<ModuleDependency>(ModuleDependency.LOCALIZED_NAME_COMPARATOR));
        }
        for (ModuleDependency dep : this.universe) {
            if (Thread.interrupted()) break;
            int n = 3;
            for (String tok : dep.getFilterTokens(this.dependingModuleCNB)) {
                String token = tok.toLowerCase(Locale.ENGLISH);
                if (token.equals(textLC) || token.endsWith("." + textLC)) {
                    n = Math.min(0, n);
                    continue;
                }
                if (token.indexOf("." + textLC) != -1) {
                    n = Math.min(1, n);
                    continue;
                }
                if (token.indexOf(textLC) == -1) continue;
                n = Math.min(2, n);
            }
            if (n >= 3) continue;
            ((Set)matches.get(n)).add(dep);
        }
        LinkedHashSet<ModuleDependency> result = new LinkedHashSet<ModuleDependency>();
        for (Set set : matches) {
            result.addAll(set);
        }
        return result;
    }

    public Set<String> getMatchesFor(String text, ModuleDependency dep) {
        String textLC = text.toLowerCase(Locale.US);
        TreeSet<Object> tokens = new TreeSet<Object>(Collator.getInstance());
        for (String token : dep.getFilterTokens(this.dependingModuleCNB)) {
            if (token.toLowerCase(Locale.US).indexOf(textLC) == -1) continue;
            tokens.add(token);
        }
        return tokens;
    }
}

