/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.charset.Charset;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.progress.Progress;

public class StreamUtils {
    public static void transferData(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[65536];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    public static void transferData(RandomAccessFile in, OutputStream out) throws IOException {
        StreamUtils.transferData(in, out, in.length());
    }

    public static void transferData(RandomAccessFile in, OutputStream out, Progress progress) throws IOException {
        StreamUtils.transferData(in, out, in.length(), progress);
    }

    public static void transferData(RandomAccessFile in, OutputStream out, long max) throws IOException {
        StreamUtils.transferData(in, out, max, new Progress());
    }

    public static void transferData(RandomAccessFile in, OutputStream out, long max, Progress progress) throws IOException {
        byte[] buffer = new byte[65536];
        long total = 0L;
        int length = 0;
        progress.setPercentage(0);
        while ((length = in.read(buffer)) != -1 && total < max) {
            out.write(buffer, 0, (int)((total += (long)length) < max ? (long)length : (long)length - (total - max)));
            if (total >= max) continue;
            progress.setPercentage(100L * total / max);
        }
        progress.setPercentage(100);
        out.flush();
    }

    public static void transferFile(File file, OutputStream out) throws IOException {
        StreamUtils.transferFile(file, out, new Progress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferFile(File file, OutputStream out, Progress progress) throws IOException {
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(file, "r");
            StreamUtils.transferData(in, out, progress);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    ErrorManager.notifyDebug("Cannot close raf", e);
                }
            }
        }
    }

    public static CharSequence readStream(InputStream input) throws IOException {
        return StreamUtils.readStream(input, Charset.forName("UTF-8"));
    }

    public static CharSequence readStream(InputStream input, Charset charset) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));
        return StreamUtils.readReader(reader);
    }

    public static CharSequence readReader(Reader reader) throws IOException {
        int readLength;
        char[] buffer = new char[65536];
        StringBuilder stringBuilder = new StringBuilder();
        while ((readLength = reader.read(buffer)) != -1) {
            stringBuilder.append(buffer, 0, readLength);
        }
        return stringBuilder;
    }

    public static CharSequence readFile(File file) throws IOException {
        return StreamUtils.readFile(file, Charset.forName("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence readFile(File file, Charset charset) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            CharSequence charSequence = StreamUtils.readReader(new InputStreamReader((InputStream)in, charset));
            return charSequence;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException ignord) {}
        }
    }

    public static void writeChars(OutputStream out, CharSequence chars) throws IOException {
        StreamUtils.writeChars(out, chars, Charset.forName("UTF-8"));
    }

    public static void writeChars(OutputStream out, CharSequence chars, Charset charset) throws IOException {
        out.write(((Object)chars).toString().getBytes(charset.name()));
    }

    public static void writeChars(File file, CharSequence chars) throws IOException {
        StreamUtils.writeChars(file, chars, Charset.forName("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeChars(File file, CharSequence chars, Charset charset) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            StreamUtils.writeChars(out, chars, charset);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ignord) {}
        }
    }
}

