/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.impl;

import java.util.Collections;
import java.util.List;
import org.netbeans.installer.downloader.Pumping;
import org.netbeans.installer.downloader.impl.PumpingImpl;
import org.netbeans.installer.utils.helper.Pair;
import org.netbeans.installer.utils.xml.DomExternalizable;
import org.netbeans.installer.utils.xml.DomUtil;
import org.netbeans.installer.utils.xml.visitors.DomVisitor;
import org.netbeans.installer.utils.xml.visitors.RecursiveDomVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionImpl
implements Pumping.Section,
DomExternalizable {
    protected long start;
    protected long length;
    protected long offset;
    private PumpingImpl owner;

    protected SectionImpl(PumpingImpl owner, long start, long length) {
        this.owner = owner;
        this.start = start;
        this.length = length;
        this.offset = start;
    }

    protected SectionImpl(PumpingImpl owner) {
        this.owner = owner;
    }

    @Override
    public Pair<Long, Long> getRange() {
        return Pair.create(this.start, this.start + this.length);
    }

    @Override
    public long offset() {
        return this.offset;
    }

    public long length() {
        return this.length;
    }

    public long start() {
        return this.start;
    }

    public void shiftOffset(long delta) {
        this.offset += delta;
        this.owner.fireChanges("pumpingUpdate");
    }

    public List<Pair<String, String>> headers() {
        if (this.owner.acceptBytes) {
            if (this.length > 0L) {
                long end = this.start + this.length - 1L;
                return Collections.singletonList(Pair.create("Range", "bytes=" + this.offset + "-" + end));
            }
            if (this.length == -1L) {
                return Collections.singletonList(Pair.create("Range", "bytes=" + this.offset + "-"));
            }
        } else {
            this.offset = this.start;
        }
        return Collections.emptyList();
    }

    @Override
    public void readXML(Element element) {
        RecursiveDomVisitor visitor = new RecursiveDomVisitor(){

            public void visit(Element element) {
                String name = element.getNodeName();
                if ("start".equals(name)) {
                    SectionImpl.this.start = Long.valueOf(element.getTextContent());
                } else if ("length".equals(name)) {
                    SectionImpl.this.length = Long.valueOf(element.getTextContent());
                } else if ("offset".equals(name)) {
                    SectionImpl.this.offset = Long.valueOf(element.getTextContent());
                } else {
                    super.visit(element);
                }
            }
        };
        ((DomVisitor)visitor).visit(element);
    }

    @Override
    public Element writeXML(Document document) {
        Element root = document.createElement("section");
        DomUtil.addElement(root, "start", String.valueOf(this.start));
        DomUtil.addElement(root, "length", String.valueOf(this.length));
        DomUtil.addElement(root, "offset", String.valueOf(this.offset));
        return root;
    }
}

