/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.samples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.maven.samples.CRUDSampleDbPersistencePanel;
import org.netbeans.modules.maven.samples.MavenSamplesWizardIterator;
import org.netbeans.modules.maven.samples.MavenSamplesWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MavenCRUDSampleWizardIterator
extends MavenSamplesWizardIterator {
    private static final long serialVersionUID = 1L;
    private CRUDSampleDbPersistencePanel configurationPanel;

    public static MavenCRUDSampleWizardIterator createIterator() {
        return new MavenCRUDSampleWizardIterator();
    }

    @Override
    protected WizardDescriptor.Panel[] createPanels() {
        this.configurationPanel = new CRUDSampleDbPersistencePanel();
        return new WizardDescriptor.Panel[]{new MavenSamplesWizardPanel(this.configurationPanel.isValid()), this.configurationPanel};
    }

    @Override
    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(MavenCRUDSampleWizardIterator.class, (String)"LBL_CreateProjectStep"), NbBundle.getMessage(MavenCRUDSampleWizardIterator.class, (String)"LBL_CreatePersistenceStep")};
    }

    @Override
    protected void configureProject(FileObject fileObject) throws IOException {
        try {
            this.copyPersistenceLibraries(this.configurationPanel.getSelectedLibrary(), fileObject);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException(illegalStateException);
        }
        this.configureDerby(this.configurationPanel.getDerbyLocation(), fileObject);
    }

    private void copyPersistenceLibraries(Library library, FileObject fileObject) throws URISyntaxException, IllegalStateException, FileNotFoundException, IOException {
        String string = library.getName();
        File file = new File(FileUtil.toFile((FileObject)fileObject), "crudsample" + File.separator + string + ".xml");
        Logger.getLogger(MavenCRUDSampleWizardIterator.class.getName()).log(Level.FINE, "pom.xml found at {0}", new Object[]{file});
        assert (file.exists()) : file + " exists.";
        File file2 = new File(FileUtil.toFile((FileObject)fileObject), "crudsample" + File.separator + "pom.xml");
        file.renameTo(file2);
        File file3 = new File(FileUtil.toFile((FileObject)fileObject), "crudsample" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "META-INF" + File.separator + library.getName() + ".xml");
        Logger.getLogger(MavenCRUDSampleWizardIterator.class.getName()).log(Level.FINE, "META-INF/peristence.xml found at {0}", new Object[]{file3});
        assert (file3.exists()) : file3 + " exists.";
        File file4 = new File(file3.getParent(), "persistence.xml");
        file3.renameTo(file4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureDerby(String string, FileObject fileObject) throws FileNotFoundException, IOException {
        File file = new File(FileUtil.toFile((FileObject)fileObject), "crudsample" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "org" + File.separator + "netbeans" + File.separator + "modules" + File.separator + "crudsampleapplication" + File.separator + "dbaccess" + File.separator + "Bundle.properties");
        FileObject fileObject2 = FileUtil.toFileObject((File)file);
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = fileObject2.getInputStream();
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        properties.setProperty("javadb.home", string);
        OutputStream outputStream = null;
        try {
            outputStream = fileObject2.getOutputStream();
            properties.store(outputStream, null);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        Logger.getLogger(MavenCRUDSampleWizardIterator.class.getName()).log(Level.FINE, "JavaDB home is {0}", new Object[]{string});
    }
}

