/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.properties.common;

import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.properties.PropertiesNodesManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.lookup.InstanceContent;

public final class PropertiesSupport {
    public static final String DO_NOT_OPEN_PROPERTIES_WINDOW_TAG = "DO_NOT_OPEN_PROPERTIES_WINDOW";

    private PropertiesSupport() {
    }

    public static Sheet getSheet(DataEditorView view, DesignComponent component) {
        return PropertiesNodesManager.getInstance(view).getSheet(component);
    }

    public static void addInstanceContent(DataEditorView view, InstanceContent ic) {
        PropertiesNodesManager.getInstance(view).add(ic);
    }

    public static synchronized void showCustomPropertyEditor(DesignComponent component, String propertyName) {
        boolean propertyEditorExists = false;
        if (component.getDocument().getTransactionManager().isWriteAccess()) {
            Debug.warning((Object[])new Object[]{"Calling PropertiesSupport.showPropertyEditorForCurrentComponent form write transaction may generate problems"});
        }
        DataEditorView view = ActiveViewSupport.getDefault().getActiveView();
        assert (view != null);
        Sheet sheet = PropertiesNodesManager.getInstance(view).getSheet(component);
        for (Node.PropertySet propertySet : sheet.toArray()) {
            for (Node.Property property : propertySet.getProperties()) {
                if (!propertyName.equals(property.getName())) continue;
                PropertyPanel propertyPanel = new PropertyPanel(property, 2);
                propertyEditorExists = true;
                propertyPanel.setChangeImmediate(false);
                DialogDescriptor dd = new DialogDescriptor((Object)propertyPanel, property.getDisplayName(), true, null);
                Object helpID = property.getValue("helpID");
                if (helpID != null) {
                    assert (helpID instanceof String);
                    HelpCtx helpCtx = new HelpCtx((String)helpID);
                    dd.setHelpCtx(helpCtx);
                }
                property.getPropertyEditor().getCustomEditor();
                Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (res == DialogDescriptor.OK_OPTION) {
                    ((DesignPropertyEditor)property.getPropertyEditor()).customEditorOKButtonPressed();
                    try {
                        property.setValue(property.getPropertyEditor().getValue());
                    }
                    catch (IllegalAccessException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return;
            }
        }
        if (!propertyEditorExists) {
            throw new IllegalArgumentException("PropertyEditor for " + propertyName + " not found in the component " + component);
        }
    }
}

