/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.css.lexer.LexerCharStream;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.css.parser.CssParserTokenManager;
import org.netbeans.modules.css.parser.PatchedCssParserTokenManager;
import org.netbeans.modules.css.parser.TokenMgrError;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public final class CssLexer
implements Lexer<CssTokenId> {
    private boolean inOptionsDialog;
    private LexerInput input;
    private int lexerState;
    private final TokenFactory<CssTokenId> tokenFactory;
    private CssParserTokenManager tokenManager;
    private LexerRestartInfo<CssTokenId> lexerRestartInfo;
    private static final int JCCTOKEN_TO_TOKENID_INDEX_DIFF = 8 - CssTokenId.LBRACE.ordinal();
    private static CssTokenId[] tokens = new CssTokenId[]{CssTokenId.COMMENT, CssTokenId.ATKEYWORD, CssTokenId.CDO, CssTokenId.URL, CssTokenId.SEMICOLON, CssTokenId.SELECTOR_NMSTART, CssTokenId.COLON, CssTokenId.CDO, CssTokenId.SELECTOR_NMSTART, CssTokenId.CDO, CssTokenId.GT, CssTokenId.CDO, CssTokenId.SELECTOR_NMSTART, CssTokenId.CDO, CssTokenId.LBRACE, CssTokenId.CDO, CssTokenId.NAME, CssTokenId.CDO, CssTokenId.SEMICOLON, CssTokenId.CDO, CssTokenId.NUMBER, CssTokenId.SEMICOLON, CssTokenId.CDO, CssTokenId.NAME, CssTokenId.SEMICOLON, CssTokenId.FUNCTION, CssTokenId.STRING, CssTokenId.RBRACE, CssTokenId.SEMICOLON, CssTokenId.CDO, CssTokenId.RBRACE};
    private static int[] lengths = new int[]{36, 6, 0, 14, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 2, 4, 0, 0, 0, 6, 0, 2, 15, 0, 3, 25, 0, 0, 0, 0};

    public Object state() {
        return this.lexerState;
    }

    public CssLexer(LexerRestartInfo<CssTokenId> info) {
        this.lexerRestartInfo = info;
        this.input = info.input();
        this.tokenManager = info.state() != null ? new PatchedCssParserTokenManager(new LexerCharStream(info), (Integer)info.state()) : new PatchedCssParserTokenManager(new LexerCharStream(info));
        this.tokenFactory = info.tokenFactory();
        this.inOptionsDialog = info.getAttributeValue((Object)"OptionsDialog") != null;
        Integer state = (Integer)this.lexerRestartInfo.state();
        this.lexerState = state == null ? 0 : state;
    }

    public Token<CssTokenId> nextToken() {
        if (this.inOptionsDialog) {
            int next = this.input.read();
            if (next == -1) {
                return null;
            }
            if (this.lexerState >= lengths.length) {
                return this.tokenFactory.createToken((TokenId)CssTokenId.CDO);
            }
            for (int i = 0; i < lengths[this.lexerState]; ++i) {
                this.input.read();
            }
            return this.tokenFactory.createToken((TokenId)tokens[this.lexerState++]);
        }
        org.netbeans.modules.css.parser.Token token = null;
        try {
            token = this.tokenManager.getNextToken();
            if (token.image.length() > 0) {
                int idx = token.kind;
                int diff = 0;
                switch (idx) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 4: {
                        diff = idx - CssTokenId.COMMENT.ordinal();
                        break;
                    }
                    case 6: {
                        diff = idx - CssTokenId.MSE.ordinal();
                        break;
                    }
                    default: {
                        diff = JCCTOKEN_TO_TOKENID_INDEX_DIFF;
                    }
                }
                return this.tokenFactory.createToken((TokenId)CssTokenId.values()[idx -= diff]);
            }
        }
        catch (TokenMgrError tokenMgrError) {
            // empty catch block
        }
        if (this.lexerRestartInfo.input().readLength() > 0) {
            return this.tokenFactory.createToken((TokenId)CssTokenId.UNKNOWN);
        }
        return null;
    }

    public void release() {
        this.tokenManager = null;
    }
}

