/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.SelectedItemsTable;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.spi.customizer.SelectedItemsTablePersister;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PublicPackagesPanel
extends JPanel
implements SelectedItemsTablePersister {
    private static final String ALL_SUBPACKAGES = ".*";
    private static final String ALL_SUBPACKAGES_2 = ".**";
    private static final int COALESCE_LIMIT = 2;
    private static final String NBM_ARTIFACT_ID = "nbm-maven-plugin";
    private static final String NBM_GROUP_ID = "org.codehaus.mojo";
    private static final String PUBLIC_PACKAGE = "publicPackage";
    private static final String PUBLIC_PACKAGES = "publicPackages";
    private final SelectedItemsTable.SelectedItemsTableModel tableModel;
    private final ModelHandle handle;
    private final Project project;
    private JTable exportTable;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    public PublicPackagesPanel(ModelHandle modelHandle, Project project) {
        this.handle = modelHandle;
        this.project = project;
        this.tableModel = new SelectedItemsTable.SelectedItemsTableModel((SelectedItemsTablePersister)this);
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(this.exportTable.getBackground());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.exportTable = new SelectedItemsTable(this.tableModel);
        this.jLabel1.setLabelFor(this.exportTable);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PublicPackagesPanel.class, (String)"PublicPackagesPanel.jLabel1.text"));
        this.jScrollPane1.setViewportView(this.exportTable);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(411, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 517, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 211, Short.MAX_VALUE)));
    }

    public SortedMap<String, Boolean> read() {
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        SortedSet sortedSet = FileUtilities.getPackageNames((Project)this.project);
        for (String string : sortedSet) {
            treeMap.put(string, Boolean.FALSE);
        }
        String[] stringArray = PluginPropertyUtils.getPluginPropertyList((Project)this.project, (String)NBM_GROUP_ID, (String)NBM_ARTIFACT_ID, (String)PUBLIC_PACKAGES, (String)PUBLIC_PACKAGE, (String)"manifest");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = null;
                String string2 = stringArray[i];
                if (string2.endsWith(ALL_SUBPACKAGES)) {
                    string = string2.substring(0, string2.length() - ALL_SUBPACKAGES.length());
                } else if (string2.endsWith(ALL_SUBPACKAGES_2)) {
                    string = string2.substring(0, string2.length() - ALL_SUBPACKAGES_2.length());
                }
                if (string == null) {
                    treeMap.put(string2, Boolean.TRUE);
                    continue;
                }
                for (String string3 : sortedSet) {
                    if (!string3.startsWith(string)) continue;
                    treeMap.put(string3, Boolean.TRUE);
                }
            }
        }
        return treeMap;
    }

    public void write(SortedMap<String, Boolean> sortedMap) {
        Object object2;
        Boolean bl3;
        POMModel pOMModel = this.handle.getPOMModel();
        Build build = pOMModel.getProject().getBuild();
        boolean bl2 = true;
        for (Boolean bl3 : sortedMap.values()) {
            if (!bl3.booleanValue()) continue;
            bl2 = false;
            break;
        }
        Plugin plugin = null;
        if (build != null) {
            plugin = build.findPluginById(NBM_GROUP_ID, NBM_ARTIFACT_ID);
        } else {
            build = pOMModel.getFactory().createBuild();
            pOMModel.getProject().setBuild(build);
        }
        bl3 = null;
        if (plugin != null) {
            bl3 = plugin.getConfiguration();
        } else {
            plugin = pOMModel.getFactory().createPlugin();
            plugin.setGroupId(NBM_GROUP_ID);
            plugin.setArtifactId(NBM_ARTIFACT_ID);
            plugin.setExtensions(Boolean.TRUE);
            build.addPlugin(plugin);
        }
        if (bl3 == null) {
            bl3 = pOMModel.getFactory().createConfiguration();
            plugin.setConfiguration((Configuration)bl3);
        }
        List list = bl3.getConfigurationElements();
        POMExtensibilityElement pOMExtensibilityElement = null;
        for (Object object2 : list) {
            if (!PUBLIC_PACKAGES.equals(object2.getQName().getLocalPart())) continue;
            pOMExtensibilityElement = object2;
            break;
        }
        if (bl2) {
            if (pOMExtensibilityElement != null) {
                bl3.removeExtensibilityElement(pOMExtensibilityElement);
                this.handle.markAsModified((Object)pOMModel);
            }
            return;
        }
        pOMExtensibilityElement = ModelUtils.getOrCreateChild((POMComponent)bl3, (String)PUBLIC_PACKAGES, (POMModel)pOMModel);
        List list2 = pOMExtensibilityElement.getAnyElements();
        object2 = list2.iterator();
        while (object2.hasNext()) {
            POMExtensibilityElement pOMExtensibilityElement2 = (POMExtensibilityElement)object2.next();
            pOMExtensibilityElement.removeAnyElement(pOMExtensibilityElement2);
        }
        for (String string : PublicPackagesPanel.getPublicPackagesForPlugin(sortedMap)) {
            object2 = pOMModel.getFactory().createPOMExtensibilityElement(new QName(PUBLIC_PACKAGE));
            object2.setElementText(string);
            pOMExtensibilityElement.addExtensibilityElement((POMExtensibilityElement)object2);
        }
        this.handle.markAsModified((Object)pOMModel);
    }

    public static SortedSet<String> getPublicPackagesForPlugin(SortedMap<String, Boolean> sortedMap) {
        TreeSet<String> treeSet = new TreeSet<String>();
        HashSet hashSet = new HashSet();
        for (Map.Entry<String, Boolean> entry : sortedMap.entrySet()) {
            if (!entry.getValue().booleanValue() || hashSet.contains(entry.getKey())) continue;
            boolean bl = true;
            HashSet<String> hashSet2 = new HashSet<String>();
            String string = entry.getKey() + ".";
            for (String string2 : sortedMap.keySet()) {
                if (!string2.startsWith(string)) continue;
                if (((Boolean)sortedMap.get(string2)).booleanValue()) {
                    hashSet2.add(string2);
                    continue;
                }
                bl = false;
                break;
            }
            if (bl && hashSet2.size() > 2) {
                treeSet.add(entry.getKey() + ALL_SUBPACKAGES);
                hashSet.addAll(hashSet2);
                continue;
            }
            treeSet.add(entry.getKey());
        }
        return treeSet;
    }
}

