/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import hidden.org.codehaus.plexus.util.DirectoryScanner;
import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.apisupport.AdaptNbVersion;
import org.netbeans.modules.maven.apisupport.ExamineManifest;
import org.netbeans.modules.maven.apisupport.SelectPlatformAppModulePanel;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class MavenNbModuleImpl
implements NbModuleProvider {
    private Project project;
    private DependencyAdder dependencyAdder = new DependencyAdder();
    private RequestProcessor.Task tsk = RequestProcessor.getDefault().create((Runnable)this.dependencyAdder);
    public static final String PROP_NETBEANS_INSTALL = "netbeans.installation";

    public MavenNbModuleImpl(Project project) {
        this.project = project;
    }

    private File getModuleXmlLocation() {
        File file;
        String string = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"descriptor", null);
        if (string == null) {
            string = "src/main/nbm/module.xml";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), string);
        }
        return FileUtil.normalizeFile((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xpp3Dom getModuleDom() throws UnsupportedEncodingException, IOException, XmlPullParserException {
        if (!this.getModuleXmlLocation().exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(this.getModuleXmlLocation());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        try {
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)inputStreamReader);
            return xpp3Dom;
        }
        finally {
            IOUtil.close((Reader)inputStreamReader);
        }
    }

    public String getSpecVersion() {
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        String string = AdaptNbVersion.adaptVersion(nbMavenProject.getMavenProject().getVersion(), "spec");
        return string;
    }

    public String getCodeNameBase() {
        Object object;
        Xpp3Dom xpp3Dom;
        try {
            xpp3Dom = this.getModuleDom();
            if (xpp3Dom != null && (object = xpp3Dom.getChild("codeNameBase")) != null) {
                String string = object.getValue();
                if (string.indexOf("/") > -1) {
                    string = string.substring(0, string.indexOf("/"));
                }
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        xpp3Dom = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        object = xpp3Dom.getGroupId() + "." + xpp3Dom.getArtifactId();
        object = ((String)object).replaceAll("-", ".");
        return object;
    }

    public String getSourceDirectoryPath() {
        return "src/main/java";
    }

    public FileObject getSourceDirectory() {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(this.getSourceDirectoryPath());
        if (fileObject == null) {
            try {
                fileObject = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)this.getSourceDirectoryPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return fileObject;
    }

    public FileObject getManifestFile() {
        String string = "src/main/nbm/manifest.mf";
        try {
            Xpp3Dom xpp3Dom;
            Xpp3Dom xpp3Dom2 = this.getModuleDom();
            if (xpp3Dom2 != null && (xpp3Dom = xpp3Dom2.getChild("manifest")) != null) {
                string = xpp3Dom.getValue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.project.getProjectDirectory().getFileObject(string);
    }

    public String getResourceDirectoryPath(boolean bl) {
        if (bl) {
            return "src/test/resources";
        }
        return "src/main/resources";
    }

    public boolean addDependency(String string, String string2, SpecificationVersion specificationVersion, boolean bl) throws IOException {
        List list;
        String string3 = string.replaceAll("\\.", "-");
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (this.hasDependency(string)) {
            return false;
        }
        Dependency dependency = null;
        File file = this.lookForModuleInPlatform(string3);
        if (file != null) {
            try {
                list = RepositoryQueries.findBySHA1((File)file, (RepositoryInfo[])new RepositoryInfo[0]);
                Iterator iterator = list.iterator();
                if (iterator.hasNext()) {
                    NBVersionInfo nBVersionInfo = (NBVersionInfo)iterator.next();
                    dependency = new Dependency();
                    dependency.setArtifactId(nBVersionInfo.getArtifactId());
                    dependency.setGroupId(nBVersionInfo.getGroupId());
                    dependency.setVersion(nBVersionInfo.getVersion());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (dependency == null) {
            dependency = new Dependency();
            dependency.setGroupId("org.netbeans.api");
            dependency.setArtifactId(string3);
            if (specificationVersion != null) {
                dependency.setVersion(specificationVersion.toString());
            } else {
                list = nbMavenProject.getMavenProject().getModel().getDependencies();
                if (list != null) {
                    for (NBVersionInfo nBVersionInfo : list) {
                        if (!"org.netbeans.api".equals(nBVersionInfo.getGroupId())) continue;
                        dependency.setVersion(nBVersionInfo.getVersion());
                    }
                }
            }
        }
        if (dependency.getVersion() == null) {
            dependency.setVersion("RELEASE68");
        }
        this.dependencyAdder.addDependency(dependency);
        this.tsk.schedule(200);
        return true;
    }

    public File getModuleJarLocation() {
        return null;
    }

    public boolean hasDependency(String string) throws IOException {
        String string2 = string.replaceAll("\\.", "-");
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Set set = nbMavenProject.getMavenProject().getDependencyArtifacts();
        if (set != null) {
            for (Artifact artifact : set) {
                if (!artifact.getGroupId().startsWith("org.netbeans") || !artifact.getArtifactId().equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean prepareContext(String string) throws IllegalStateException {
        File file = this.findPlatformFolder();
        if (null == file) {
            if (SelectPlatformAppModulePanel.findAppModule(this.project)) {
                file = this.findPlatformFolder();
            } else {
                return false;
            }
        }
        if (!(null == file || file.exists() && file.list().length != 0)) {
            this.notifyBuildNeeded(string);
            return false;
        }
        return true;
    }

    private void notifyBuildNeeded(String string) {
        if (!NbPreferences.forModule(MavenNbModuleImpl.class).getBoolean("showNextTime_BuildNeeded", true)) {
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)new JLabel(NbBundle.getMessage(MavenNbModuleImpl.class, (String)"Lbl_BuildNeeded")), "Center");
        JCheckBox jCheckBox = new JCheckBox(NbBundle.getMessage(MavenNbModuleImpl.class, (String)"Lbl_ShowNextTime"));
        jCheckBox.setSelected(true);
        jPanel.add((Component)jCheckBox, "South");
        JButton jButton = new JButton(NbBundle.getMessage(MavenNbModuleImpl.class, (String)"Lbl_Close"));
        DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)jPanel, string, -1, 1, new Object[]{jButton}, (Object)jButton));
        NbPreferences.forModule(MavenNbModuleImpl.class).putBoolean("showNextTime_BuildNeeded", jCheckBox.isSelected());
    }

    public NbModuleProvider.NbModuleType getModuleType() {
        return NbModuleProvider.STANDALONE;
    }

    public String getProjectFilePath() {
        return "pom.xml";
    }

    public SpecificationVersion getDependencyVersion(String string) throws IOException {
        Object object;
        Object object2;
        String string2 = string.replaceAll("\\.", "-");
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Set set = nbMavenProject.getMavenProject().getDependencyArtifacts();
        if (set != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (Artifact)object2.next();
                if (!object.getGroupId().startsWith("org.netbeans") || !object.getArtifactId().equals(string2)) continue;
                ExamineManifest examineManifest = new ExamineManifest();
                examineManifest.setJarFile(object.getFile());
                if (examineManifest.getSpecVersion() == null) continue;
                return new SpecificationVersion(examineManifest.getSpecVersion());
            }
        }
        if ((object2 = this.lookForModuleInPlatform(string2)) != null) {
            object = new ExamineManifest();
            ((ExamineManifest)object).setJarFile((File)object2);
            if (((ExamineManifest)object).getSpecVersion() != null) {
                return new SpecificationVersion(((ExamineManifest)object).getSpecVersion());
            }
        }
        return null;
    }

    private File lookForModuleInPlatform(String string) {
        File file = this.getActivePlatformLocation();
        if (file != null) {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(file);
            directoryScanner.setIncludes(new String[]{"**/" + string + ".jar"});
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            assert (stringArray != null && stringArray.length <= 1);
            if (stringArray.length > 0) {
                return new File(file, stringArray[0]);
            }
        }
        return null;
    }

    public File getActivePlatformLocation() {
        File file;
        File file2 = this.findPlatformFolder();
        if (null != file2 && file2.exists() && file2.isDirectory()) {
            return file2;
        }
        Project project = this.project;
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        String string = nbMavenProject.getMavenProject().getProperties().getProperty(PROP_NETBEANS_INSTALL);
        if (string == null) {
            string = PluginPropertyUtils.getPluginProperty((MavenProject)nbMavenProject.getMavenProject(), (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"netbeansInstallation", (String)"run-ide");
        }
        if (string != null && (file = FileUtilities.convertStringToFile((String)string)).exists()) {
            return file;
        }
        return null;
    }

    private File findPlatformFolder() {
        Object object;
        AuxiliaryProperties auxiliaryProperties = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        String string = auxiliaryProperties.get("pathToNbApplicationModule", true);
        if (null == string || string.isEmpty()) {
            return null;
        }
        FileObject fileObject = FileUtilities.convertStringToFileObject((String)string);
        if (fileObject == null && null == (fileObject = FileUtil.toFileObject((File)(object = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)string))))) {
            Logger.getLogger(MavenNbModuleImpl.class.getName()).log(Level.INFO, "Invalid path to NB application module: " + string);
            return null;
        }
        try {
            object = ProjectManager.getDefault().findProject(fileObject);
            if (object == null) {
                return null;
            }
            NbMavenProject nbMavenProject = (NbMavenProject)object.getLookup().lookup(NbMavenProject.class);
            if (nbMavenProject == null) {
                return null;
            }
            String string2 = PluginPropertyUtils.getPluginProperty((MavenProject)nbMavenProject.getMavenProject(), (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"outputDirectory", (String)"cluster-app");
            if (null == string2) {
                string2 = "target";
            }
            String string3 = PluginPropertyUtils.getPluginProperty((MavenProject)nbMavenProject.getMavenProject(), (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"brandingToken", (String)"cluster-app");
            return FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)object.getProjectDirectory()), (String)(string2 + File.separator + string3));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private class DependencyAdder
    implements Runnable {
        List<Dependency> toAdd = new ArrayList<Dependency>();

        private DependencyAdder() {
        }

        private synchronized void addDependency(Dependency dependency) {
            this.toAdd.add(dependency);
        }

        @Override
        public void run() {
            FileObject fileObject = MavenNbModuleImpl.this.project.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void performOperation(POMModel pOMModel) {
                    DependencyAdder dependencyAdder = DependencyAdder.this;
                    synchronized (dependencyAdder) {
                        for (Dependency dependency : DependencyAdder.this.toAdd) {
                            org.netbeans.modules.maven.model.pom.Dependency dependency2 = ModelUtils.checkModelDependency((POMModel)pOMModel, (String)dependency.getGroupId(), (String)dependency.getArtifactId(), (boolean)true);
                            dependency2.setVersion(dependency.getVersion());
                        }
                        DependencyAdder.this.toAdd.clear();
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
            NbMavenProject.fireMavenProjectReload((Project)MavenNbModuleImpl.this.project);
            ((NbMavenProject)MavenNbModuleImpl.this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
    }
}

