/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.LinkButton;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WelcomeFilesPanel
extends SectionInnerPanel {
    DDDataObject dObj;
    private JButton browseButton;
    private JPanel filler;
    private JLabel wfDescription;
    private JLabel wfLabel;
    private JTextField wfTF;

    public WelcomeFilesPanel(SectionView sectionView, DDDataObject dDDataObject) {
        super(sectionView);
        this.dObj = dDDataObject;
        this.initComponents();
        this.addModifier(this.wfTF);
        this.getWelcomeFiles();
        LinkButton linkButton = new LinkButton((LinkCookie)this, null, null);
        Mnemonics.setLocalizedText((AbstractButton)linkButton, (String)NbBundle.getMessage(WelcomeFilesPanel.class, (String)"LBL_goToSources"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)linkButton, gridBagConstraints);
    }

    public JComponent getErrorComponent(String string) {
        return this.wfTF;
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    public void setValue(JComponent jComponent, Object object) {
        WebApp webApp = this.dObj.getWebApp();
        String string = (String)object;
        this.setWelcomeFiles(webApp, string);
    }

    private void setWelcomeFiles(WebApp webApp, String string) {
        if (string.length() == 0) {
            webApp.setWelcomeFileList(null);
        } else {
            WelcomeFileList welcomeFileList;
            ArrayList<WelcomeFileList> arrayList = new ArrayList<WelcomeFileList>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                welcomeFileList = stringTokenizer.nextToken().trim();
                if (welcomeFileList.length() <= 0 || arrayList.contains(welcomeFileList)) continue;
                arrayList.add(welcomeFileList);
            }
            if (arrayList.size() == 0) {
                try {
                    welcomeFileList = (WelcomeFileList)webApp.createBean("WelcomeFileList");
                    webApp.setWelcomeFileList(welcomeFileList);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                welcomeFileList = new String[arrayList.size()];
                arrayList.toArray((T[])welcomeFileList);
                WelcomeFileList welcomeFileList2 = webApp.getSingleWelcomeFileList();
                if (welcomeFileList2 == null) {
                    try {
                        welcomeFileList2 = (WelcomeFileList)webApp.createBean("WelcomeFileList");
                        welcomeFileList2.setWelcomeFile((String[])welcomeFileList);
                        webApp.setWelcomeFileList(welcomeFileList2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    welcomeFileList2.setWelcomeFile((String[])welcomeFileList);
                }
            }
        }
    }

    public void linkButtonPressed(Object object, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.wfTF.getText(), ",");
        DDUtils.openEditorForFiles(this.dObj, stringTokenizer);
    }

    private void getWelcomeFiles() {
        WebApp webApp = this.dObj.getWebApp();
        WelcomeFileList welcomeFileList = webApp.getSingleWelcomeFileList();
        if (welcomeFileList == null) {
            this.wfTF.setText("");
            return;
        }
        String[] stringArray = welcomeFileList.getWelcomeFile();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i].trim());
        }
        this.wfTF.setText(stringBuffer.toString());
    }

    private void initComponents() {
        this.wfLabel = new JLabel();
        this.wfTF = new JTextField();
        this.browseButton = new JButton();
        this.wfDescription = new JLabel();
        this.filler = new JPanel();
        this.setLayout(new GridBagLayout());
        this.wfLabel.setLabelFor(this.wfTF);
        Mnemonics.setLocalizedText((JLabel)this.wfLabel, (String)NbBundle.getMessage(WelcomeFilesPanel.class, (String)"LBL_welcomeFiles"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        this.add(this.wfLabel, gridBagConstraints);
        this.wfTF.setColumns(50);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.wfTF, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(WelcomeFilesPanel.class, (String)"LBL_browse"));
        this.browseButton.setMargin(new Insets(0, 14, 0, 14));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeFilesPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.add(this.browseButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.wfDescription, (String)NbBundle.getMessage(WelcomeFilesPanel.class, (String)"DESC_welcomeFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add(this.wfDescription, gridBagConstraints);
        this.filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.filler, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        try {
            SourceGroup[] sourceGroupArray = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
            if (fileObject != null) {
                String string;
                String string2 = DDUtils.getResourcePath(sourceGroupArray, fileObject, '/', true);
                String string3 = this.wfTF.getText();
                if (string2.length() > 0 && !string3.equals(string = DDUtils.addItem(string3, string2, true))) {
                    this.wfTF.setText(string);
                    this.dObj.modelUpdatedFromUI();
                    this.dObj.setChangedFromUI(true);
                    this.setWelcomeFiles(this.dObj.getWebApp(), string);
                    this.dObj.setChangedFromUI(false);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

