/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.guards;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.InteriorSection;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.java.guards.GuardTag;
import org.netbeans.modules.java.guards.SectionDescriptor;

final class JavaGuardedWriter {
    private Iterator<SectionDescriptor> descs;
    private CharArrayWriter writer;
    private SectionDescriptor current;
    private int offsetCounter;
    boolean wasNewLine;
    int spaces;

    public void setGuardedSection(List<GuardedSection> sections) {
        assert (this.descs == null);
        this.descs = this.prepareSections(sections).iterator();
    }

    public char[] translate(char[] writeBuff) {
        if (this.descs == null || !this.descs.hasNext()) {
            return writeBuff;
        }
        this.writer = new CharArrayWriter(writeBuff.length);
        this.offsetCounter = 0;
        this.wasNewLine = false;
        this.nextSection();
        try {
            for (char c : writeBuff) {
                this.writeOneChar(c);
            }
            char[] arr$ = this.writer.toCharArray();
            return arr$;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.writer = null;
            this.current = null;
        }
    }

    void writeOneChar(int b) throws IOException {
        if (b == 13) {
            return;
        }
        if (this.current != null) {
            if (this.offsetCounter == this.current.getBegin()) {
                this.wasNewLine = false;
            }
            if (b == 10 && this.current.getBegin() <= this.offsetCounter) {
                switch (this.current.getType()) {
                    case LINE: {
                        if (!this.wasNewLine) {
                            if (this.offsetCounter + 1 >= this.current.getEnd()) {
                                this.writeMagic(GuardTag.LINE, this.current.getName());
                                this.nextSection();
                                break;
                            }
                            this.writeMagic(GuardTag.BEGIN, this.current.getName());
                            this.wasNewLine = true;
                            break;
                        }
                        if (this.offsetCounter + 1 < this.current.getEnd()) break;
                        this.writeMagic(GuardTag.END, this.current.getName());
                        this.nextSection();
                        break;
                    }
                    case FIRST: 
                    case HEADER: {
                        if (!this.wasNewLine) {
                            if (this.offsetCounter + 1 >= this.current.getEnd()) {
                                this.writeMagic(GuardTag.FIRST, this.current.getName());
                                this.nextSection();
                                break;
                            }
                            this.writeMagic(GuardTag.FIRST, this.current.getName());
                            this.wasNewLine = true;
                            break;
                        }
                        if (this.offsetCounter + 1 < this.current.getEnd()) break;
                        this.writeMagic(GuardTag.HEADEREND, this.current.getName());
                        this.nextSection();
                        break;
                    }
                    case LAST: 
                    case END: {
                        this.writeMagic(GuardTag.LAST, this.current.getName());
                        this.nextSection();
                    }
                }
            }
        }
        if (b == 32) {
            ++this.spaces;
        } else {
            if (this.spaces > 0) {
                char[] sp = new char[this.spaces];
                Arrays.fill(sp, ' ');
                this.writer.write(sp);
                this.spaces = 0;
            }
            this.writer.write(b);
        }
        ++this.offsetCounter;
    }

    private void nextSection() {
        this.current = this.descs.hasNext() ? this.descs.next() : null;
    }

    private void writeMagic(GuardTag type, String name) throws IOException {
        this.spaces = 0;
        String magic = "//GEN-" + type.name() + ':';
        this.writer.write(magic, 0, magic.length());
        this.writer.write(name, 0, name.length());
    }

    private List<SectionDescriptor> prepareSections(List<? extends GuardedSection> list) {
        ArrayList<SectionDescriptor> dest = new ArrayList<SectionDescriptor>(list.size());
        for (GuardedSection guardedSection : list) {
            SectionDescriptor desc;
            if (guardedSection instanceof SimpleSection) {
                desc = new SectionDescriptor(GuardTag.LINE, guardedSection.getName(), guardedSection.getStartPosition().getOffset(), guardedSection.getEndPosition().getOffset());
                dest.add(desc);
                continue;
            }
            desc = new SectionDescriptor(GuardTag.HEADER, guardedSection.getName(), guardedSection.getStartPosition().getOffset(), ((InteriorSection)guardedSection).getBodyStartPosition().getOffset() - 1);
            dest.add(desc);
            desc = new SectionDescriptor(GuardTag.END, guardedSection.getName(), ((InteriorSection)guardedSection).getBodyEndPosition().getOffset() + 1, guardedSection.getEndPosition().getOffset());
            dest.add(desc);
        }
        return dest;
    }
}

