/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.guards;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.java.guards.GuardTag;
import org.netbeans.modules.java.guards.JavaGuardedSectionsProvider;
import org.netbeans.modules.java.guards.SectionDescriptor;

final class JavaGuardedReader {
    static final String MAGIC_PREFIX = "//GEN-";
    Pattern magicsAsRE;
    private static final int LONGEST_ITEM = 10;
    private final LinkedList<SectionDescriptor> list = new LinkedList();
    private final JavaGuardedSectionsProvider provider;

    public JavaGuardedReader(JavaGuardedSectionsProvider provider) {
        this.provider = provider;
    }

    public List<GuardedSection> getGuardedSections() {
        return this.fillSections(this.list);
    }

    public char[] translateToCharBuff(char[] readBuff) {
        char[] res;
        SectionDescriptor desc;
        char[] charBuff = new char[readBuff.length];
        int charBuffPtr = 0;
        int stop = readBuff.length - 1;
        int i = 0;
        int lastNewLine = 0;
        int fatpos = 0;
        int MAGICLEN = MAGIC_PREFIX.length();
        while (i < stop) {
            int searchLen;
            CharBuffer chi;
            char c = readBuff[i];
            if (c == '\n') {
                lastNewLine = charBuffPtr;
            }
            charBuff[charBuffPtr++] = readBuff[i++];
            switch (fatpos) {
                case 0: {
                    if (c == '/') {
                        ++fatpos;
                        break;
                    }
                    fatpos = 0;
                    break;
                }
                case 1: {
                    if (c == '/') {
                        ++fatpos;
                        break;
                    }
                    fatpos = 0;
                    break;
                }
                case 2: {
                    if (c == 'G') {
                        ++fatpos;
                        break;
                    }
                    if (c == '/') {
                        fatpos = 2;
                        break;
                    }
                    fatpos = 0;
                    break;
                }
                case 3: {
                    if (c == 'E') {
                        ++fatpos;
                        break;
                    }
                    fatpos = 0;
                    break;
                }
                case 4: {
                    if (c == 'N') {
                        ++fatpos;
                        break;
                    }
                    fatpos = 0;
                    break;
                }
                case 5: {
                    if (c == '-') {
                        ++fatpos;
                        break;
                    }
                    fatpos = 0;
                    break;
                }
                default: {
                    fatpos = 0;
                }
            }
            if (fatpos != MAGICLEN) continue;
            fatpos = 0;
            Pattern magics = this.getMagicsAsRE();
            Matcher matcher = magics.matcher(chi = CharBuffer.wrap(readBuff, i, searchLen = Math.min(10, readBuff.length - i)));
            if (!matcher.find()) continue;
            String match = matcher.group();
            int toNl = JavaGuardedReader.toNewLine(i += match.length(), readBuff);
            int sectionSize = MAGICLEN + match.length() + toNl;
            SectionDescriptor desc2 = new SectionDescriptor(GuardTag.valueOf(match.substring(0, match.length() - 1)), String.valueOf(readBuff, i, toNl), lastNewLine + 1, (charBuffPtr -= MAGICLEN) + sectionSize);
            this.list.add(desc2);
            i += toNl;
            Arrays.fill(charBuff, charBuffPtr, charBuffPtr + sectionSize, ' ');
            charBuffPtr += sectionSize;
        }
        if (i == stop) {
            charBuff[charBuffPtr++] = readBuff[i++];
        }
        if (this.list.size() > 0 && (desc = this.list.getLast()).getEnd() > charBuffPtr) {
            desc.setEnd(charBuffPtr);
        }
        if (charBuffPtr != charBuff.length) {
            res = new char[charBuffPtr];
            System.arraycopy(charBuff, 0, res, 0, charBuffPtr);
        } else {
            res = charBuff;
        }
        return charBuff;
    }

    final Pattern getMagicsAsRE() {
        if (this.magicsAsRE == null) {
            this.magicsAsRE = Pattern.compile(this.makeOrRegexp());
        }
        return this.magicsAsRE;
    }

    final String makeOrRegexp() {
        StringBuilder sb = new StringBuilder(100);
        for (GuardTag t : GuardTag.values()) {
            sb.append(t.name() + ':');
            sb.append('|');
        }
        return sb.substring(0, sb.length() - 1);
    }

    static int toNewLine(int i, char[] readBuff) {
        int counter = i;
        int len = readBuff.length;
        while (counter < len) {
            char c;
            if ((c = readBuff[counter++]) != '\r' && c != '\n') continue;
            --counter;
            break;
        }
        return counter - i;
    }

    List<GuardedSection> fillSections(List<SectionDescriptor> descs) {
        SectionDescriptor descBegin = null;
        ArrayList<GuardedSection> sections = new ArrayList<GuardedSection>(descs.size());
        for (SectionDescriptor descCurrent : descs) {
            try {
                SimpleSection sect = null;
                switch (descCurrent.getType()) {
                    case LINE: {
                        sect = this.provider.createSimpleSection(descCurrent.getName(), descCurrent.getBegin(), descCurrent.getEnd());
                        break;
                    }
                    case BEGIN: 
                    case HEADER: 
                    case FIRST: {
                        descBegin = descCurrent;
                        break;
                    }
                    case HEADEREND: {
                        if (descBegin != null && (descBegin.getType() == GuardTag.HEADER || descBegin.getType() == GuardTag.FIRST) && descCurrent.getName().equals(descBegin.getName())) {
                            descBegin.setEnd(descCurrent.getEnd());
                            break;
                        }
                        descBegin = null;
                        break;
                    }
                    case END: 
                    case LAST: {
                        if (descBegin != null && descBegin.getName().equals(descCurrent.getName())) {
                            if (descBegin.getType() == GuardTag.BEGIN && descCurrent.getType() == GuardTag.END) {
                                sect = this.provider.createSimpleSection(descCurrent.getName(), descBegin.getBegin(), descCurrent.getEnd());
                                break;
                            }
                            if (descBegin.getType() == GuardTag.FIRST && descCurrent.getType() == GuardTag.LAST || descBegin.getType() == GuardTag.HEADER && descCurrent.getType() == GuardTag.END) {
                                sect = this.provider.createInteriorSection(descCurrent.getName(), descBegin.getBegin(), descBegin.getEnd(), descCurrent.getBegin(), descCurrent.getEnd());
                                break;
                            }
                        }
                        descBegin = null;
                    }
                }
                if (sect == null) continue;
                sections.add((GuardedSection)sect);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(JavaGuardedReader.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
        }
        return sections;
    }
}

