# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Guido Amoruso <guidonte@fluendo.com>

from twisted.trial.unittest import TestCase

from elisa.core.utils import defer

from elisa.plugins.rss.models import RssFeedModel


doc = """<?xml version="1.0" encoding="utf-8"?>
<rss version="2.0"
     xmlns:media="http://search.yahoo.com/mrss/"
     xmlns:atom="http://www.w3.org/2005/Atom">
  <channel>
    <title>Text Channel</title>
    <description>Channel for unittests</description>
    <atom:icon>http://test.com/icon.jpg</atom:icon>
    <item>
      <title>Test item</title>
      <media:title type="plain">Test item</media:title>
      <media:description type="html"><![CDATA[ ...  ]]></media:description>
      <media:thumbnail url="http://test.com/thumbnail.jpg"/>
      <media:content url="http://test.com/content.jpg" medium="image"/>
    </item>
    <item>
      <title>Test item</title>
      <media:title type="plain">Test item</media:title>
      <media:description type="html"><![CDATA[ ...  ]]></media:description>
      <enclosure url="http://test.com/content.mpg" type="video/mpg"/>
    </item>
    <item>
      <title>Test item</title>
      <media:title type="plain">Test item</media:title>
      <media:description type="html"><![CDATA[ ...  ]]></media:description>
      <enclosure url="http://test.com/plain.txt" type="text/plain"/>
    </item>
    <item>
    </item>
    <item>
      <title>Test item</title>
      <media:title type="plain">Test item</media:title>
      <media:description type="html"><![CDATA[<img width="160" src="http://test.com"/>]]></media:description>
      <enclosure url="http://test.com/plain.txt" type="text/plain"/>
    </item>
    <item>
      <title>Test item</title>
      <media:title type="plain">Test item</media:title>
      <description type="html">&lt;img width="160" src="http://test.com"/&gt;</description>
      <enclosure url="http://test.com/plain.txt" type="text/plain"/>
    </item>
  </channel>
</rss>
"""


class TestRssFeedModel(TestCase):

    def _get(self, uri):
        # Mock to replace a call to the real page getter
        if uri == 'succeed':
            return defer.succeed(doc)
        elif uri == 'fail':
            return defer.fail(Exception("Failure when fetching the feed"))

    def _patch_feed(self, feed):
        # Monkey patch the feed model's _get method
        feed._get = self._get

    def test_load_fail(self):
        feed = RssFeedModel()
        feed.uri = 'fail'
        self._patch_feed(feed)
        self.failUnlessFailure(feed.load(), Exception)

    def test_load_success(self):
        feed = RssFeedModel()
        feed.uri = 'succeed'
        self._patch_feed(feed)
        return feed.load()

