/*
 * Decompiled with CFR 0.152.
 */
package org.linkgrammar;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.linkgrammar.LGConfig;
import org.linkgrammar.Link;
import org.linkgrammar.LinkGrammar;
import org.linkgrammar.Linkage;
import org.linkgrammar.ParseResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LGService {
    private static boolean verbose = false;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static ThreadLocal<Boolean> initialized = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    static char[] hex = "0123456789ABCDEF".toCharArray();

    public static boolean isInitialized() {
        return initialized.get();
    }

    public static void init() {
        if (!initialized.get().booleanValue()) {
            LinkGrammar.init();
            initialized.set(Boolean.TRUE);
        }
    }

    public static void close() {
        LinkGrammar.close();
        initialized.set(Boolean.FALSE);
    }

    private static void trace(String s) {
        if (verbose) {
            System.out.println("LG " + dateFormatter.format(new Date()) + " " + s);
        }
    }

    private static boolean getBool(String name, Map<String, String> msg, boolean def) {
        String x = msg.get(name);
        return x == null ? def : Boolean.valueOf(x);
    }

    private static int getInt(String name, Map<String, String> msg, int def) {
        String x = msg.get(name);
        return x == null ? def : Integer.parseInt(x);
    }

    public static void configure(LGConfig config) {
        LGService.init();
        if (config.getMaxCost() > -1) {
            LinkGrammar.setMaxCost(config.getMaxCost());
        }
        if (config.getMaxParseSeconds() > -1) {
            LinkGrammar.setMaxParseSeconds(config.getMaxParseSeconds());
        }
        if (config.getMaxLinkages() > -1) {
            LinkGrammar.setMaxLinkages(config.getMaxLinkages());
        }
    }

    public static ParseResult getAsParseResult(LGConfig config) {
        LinkGrammar.makeLinkage(0);
        ParseResult parseResult = new ParseResult();
        parseResult.setParserVersion(LinkGrammar.getVersion());
        parseResult.setDictVersion(LinkGrammar.getDictVersion());
        parseResult.numSkippedWords = LinkGrammar.getNumSkippedWords();
        parseResult.words = new String[LinkGrammar.getNumWords()];
        for (int i = 0; i < parseResult.words.length; ++i) {
            parseResult.words[i] = LinkGrammar.getWord(i);
        }
        int maxLinkages = Math.min(config.getMaxLinkages(), LinkGrammar.getNumLinkages());
        for (int li = 0; li < maxLinkages; ++li) {
            LinkGrammar.makeLinkage(li);
            Linkage linkage = new Linkage();
            linkage.setDisjunctCost(LinkGrammar.getLinkageDisjunctCost());
            linkage.setLinkCost(LinkGrammar.getLinkageLinkCost());
            linkage.setLinkedWordCount(LinkGrammar.getNumWords());
            linkage.setNumViolations(LinkGrammar.getLinkageNumViolations());
            String[] disjuncts = new String[LinkGrammar.getNumWords()];
            String[] words = new String[LinkGrammar.getNumWords()];
            for (int i = 0; i < words.length; ++i) {
                disjuncts[i] = LinkGrammar.getLinkageDisjunct(i);
                words[i] = LinkGrammar.getLinkageWord(i);
            }
            linkage.setWords(words);
            linkage.setDisjuncts(disjuncts);
            int numLinks = LinkGrammar.getNumLinks();
            for (int i = 0; i < numLinks; ++i) {
                Link link = new Link();
                link.setLabel(LinkGrammar.getLinkLabel(i));
                link.setLeft(LinkGrammar.getLinkLWord(i));
                link.setRight(LinkGrammar.getLinkRWord(i));
                link.setLeftLabel(LinkGrammar.getLinkLLabel(i));
                link.setRightLabel(LinkGrammar.getLinkRLabel(i));
                linkage.getLinks().add(link);
            }
            if (config.isStoreConstituentString()) {
                linkage.setConstituentString(LinkGrammar.getConstituentString());
            }
            if (config.isStoreDiagramString()) {
                linkage.setDiagramString(LinkGrammar.getLinkString());
            }
            parseResult.linkages.add(linkage);
        }
        return parseResult;
    }

    public static String getEmptyJSONResult(LGConfig config) {
        StringBuffer buf = new StringBuffer();
        buf.append("{\"tokens\":[],");
        buf.append("\"numSkippedWords\":0,");
        buf.append("\"linkages\":[],");
        buf.append("\"version\":\"" + LinkGrammar.getVersion() + "\",");
        buf.append("\"dictVersion\":\"" + LinkGrammar.getDictVersion() + "\"}");
        return buf.toString();
    }

    private static String jsonString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        b.append("\"");
        StringCharacterIterator it = new StringCharacterIterator(s);
        int c = it.first();
        while (c != 65535) {
            if (c == 34) {
                b.append("\\\"");
            } else if (c == 92) {
                b.append("\\\\");
            } else if (c == 47) {
                b.append("\\/");
            } else if (c == 8) {
                b.append("\\b");
            } else if (c == 12) {
                b.append("\\f");
            } else if (c == 10) {
                b.append("\\n");
            } else if (c == 13) {
                b.append("\\r");
            } else if (c == 9) {
                b.append("\\t");
            } else if (Character.isISOControl((char)c)) {
                int n = c;
                for (int i = 0; i < 4; ++i) {
                    int digit = (n & 0xF000) >> 12;
                    b.append(hex[digit]);
                    n <<= 4;
                }
            } else {
                b.append((char)c);
            }
            c = it.next();
        }
        b.append("\"");
        return b.toString();
    }

    public static String getAsJSONFormat(LGConfig config) {
        LinkGrammar.makeLinkage(0);
        int numWords = LinkGrammar.getNumWords();
        int maxLinkages = Math.min(config.getMaxLinkages(), LinkGrammar.getNumLinkages());
        StringBuffer buf = new StringBuffer();
        buf.append("{\"tokens\":[");
        for (int i = 0; i < numWords; ++i) {
            buf.append(LGService.jsonString(LinkGrammar.getWord(i)));
            if (i + 1 >= numWords) continue;
            buf.append(",");
        }
        buf.append("],\"numSkippedWords\":" + LinkGrammar.getNumSkippedWords());
        buf.append(",\"linkages\":[");
        for (int li = 0; li < maxLinkages; ++li) {
            int i;
            LinkGrammar.makeLinkage(li);
            buf.append("{\"words\":[");
            for (i = 0; i < numWords; ++i) {
                buf.append(LGService.jsonString(LinkGrammar.getLinkageWord(i)));
                if (i + 1 >= numWords) continue;
                buf.append(",");
            }
            buf.append("], \"disjuncts\":[");
            for (i = 0; i < numWords; ++i) {
                buf.append(LGService.jsonString(LinkGrammar.getLinkageDisjunct(i)));
                if (i + 1 >= numWords) continue;
                buf.append(",");
            }
            buf.append("], \"disjunctCost\":");
            buf.append(Integer.toString(LinkGrammar.getLinkageDisjunctCost()));
            buf.append(", \"linkageCost\":");
            buf.append(Integer.toString(LinkGrammar.getLinkageLinkCost()));
            buf.append(", \"numViolations\":");
            buf.append(Integer.toString(LinkGrammar.getLinkageNumViolations()));
            if (config.isStoreConstituentString()) {
                buf.append(", \"constituentString\":");
                buf.append(LGService.jsonString(LinkGrammar.getConstituentString()));
            }
            if (config.isStoreDiagramString()) {
                buf.append(", \"diagramString\":");
                buf.append(LGService.jsonString(LinkGrammar.getLinkString()));
            }
            buf.append(", \"links\":[");
            int numLinks = LinkGrammar.getNumLinks();
            for (int i2 = 0; i2 < numLinks; ++i2) {
                buf.append("{\"label\":" + LGService.jsonString(LinkGrammar.getLinkLabel(i2)) + ",");
                buf.append("\"left\":" + LinkGrammar.getLinkLWord(i2) + ",");
                buf.append("\"right\":" + LinkGrammar.getLinkRWord(i2) + ",");
                buf.append("\"leftLabel\":" + LGService.jsonString(LinkGrammar.getLinkLLabel(i2)) + ",");
                buf.append("\"rightLabel\":" + LGService.jsonString(LinkGrammar.getLinkRLabel(i2)) + "}");
                if (i2 + 1 >= numLinks) continue;
                buf.append(",");
            }
            buf.append("]");
            buf.append("}");
            if (li >= maxLinkages - 1) continue;
            buf.append(",");
        }
        buf.append("],\"version\":\"" + LinkGrammar.getVersion() + "\"");
        buf.append(",\"dictVersion\":\"" + LinkGrammar.getDictVersion() + "\"");
        buf.append("}");
        return buf.toString();
    }

    public static byte[] getAsBinary(LGConfig config) {
        int size = 0;
        byte[] buf = new byte[1024];
        byte[] result = new byte[size];
        System.arraycopy(buf, 0, result, 0, size);
        return result;
    }

    private static Map<String, String> readMsg(Reader in) throws IOException {
        int length = 0;
        char[] buf = new char[1024];
        int count = in.read(buf, length, buf.length - length);
        while (count > -1) {
            if ((length += count) == buf.length) {
                char[] nbuf = new char[buf.length + 512];
                System.arraycopy(buf, 0, nbuf, 0, buf.length);
                buf = nbuf;
            }
            if (buf[length - 1] == '\n') break;
            count = in.read(buf, length, buf.length - length);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        boolean gotText = false;
        int start = -1;
        int column = -1;
        for (int offset = 0; offset < length - 1; ++offset) {
            String name;
            char c = buf[offset];
            if (start == -1) {
                start = offset;
                continue;
            }
            if (c == ':' && column == -1) {
                column = offset;
                name = new String(buf, start, column - start);
                if ("text" != (name = name.trim())) continue;
                gotText = true;
                continue;
            }
            if (c != '\u0000' && (gotText || c != ',')) continue;
            if (start == -1 || column == -1) {
                throw new RuntimeException("Malformed message:" + new String(buf, 0, length));
            }
            name = new String(buf, start, column - start);
            String value = new String(buf, column + 1, offset - column - 1);
            name = name.trim();
            value = value.trim();
            result.put(name, value);
            column = -1;
            start = -1;
        }
        if (start != -1 && column != -1) {
            String name = new String(buf, start, column - start);
            String value = new String(buf, column + 1, length - column - 1);
            name = name.trim();
            value = value.trim();
            result.put(name, value);
            column = -1;
            start = -1;
        }
        if (start != -1 || column != -1) {
            throw new RuntimeException("Malformed message:" + new String(buf, 0, length));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleClient(Socket clientSocket) {
        LGService.init();
        Reader in = null;
        PrintWriter out = null;
        try {
            LGService.trace("Connection accepted from : " + clientSocket.getInetAddress());
            in = new InputStreamReader(clientSocket.getInputStream());
            Map<String, String> msg = LGService.readMsg(in);
            if (verbose) {
                LGService.trace("Received msg '" + msg + "' from " + clientSocket.getInetAddress());
            }
            String json = "{}";
            if ("version".equals(msg.get("get"))) {
                json = "{\"version\":\"" + LinkGrammar.getVersion() + "\"}";
            } else {
                LGConfig config = new LGConfig();
                config.setMaxCost(LGService.getInt("maxCost", msg, config.getMaxCost()));
                config.setMaxLinkages(LGService.getInt("maxLinkages", msg, config.getMaxLinkages()));
                config.setMaxParseSeconds(LGService.getInt("maxParseSeconds", msg, config.getMaxParseSeconds()));
                config.setStoreConstituentString(LGService.getBool("storeConstituentString", msg, config.isStoreConstituentString()));
                config.setStoreDiagramString(LGService.getBool("storeDiagramString", msg, config.isStoreDiagramString()));
                LGService.configure(config);
                String text = msg.get("text");
                if (text != null && text.trim().length() > 0) {
                    LinkGrammar.parse(text);
                    json = LinkGrammar.getNumLinkages() > 0 ? LGService.getAsJSONFormat(config) : LGService.getEmptyJSONResult(config);
                } else {
                    json = LGService.getEmptyJSONResult(config);
                }
            }
            out = new PrintWriter(clientSocket.getOutputStream(), true);
            out.print(json.length() + 1);
            out.print('\n');
            out.print(json);
            out.print('\n');
            out.flush();
            LGService.trace("Response written to " + clientSocket.getInetAddress() + ", closing client connection...");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable t) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
            if (clientSocket != null) {
                try {
                    clientSocket.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static ParseResult parse(LGConfig config, String text) {
        LGService.init();
        LGService.configure(config);
        LinkGrammar.parse(text);
        return LGService.getAsParseResult(config);
    }

    public static void main(String[] argv) {
        int threads = 1;
        int port = 0;
        String dictionaryPath = null;
        String language = null;
        try {
            int argIdx = 0;
            if (argv[argIdx].equals("-verbose")) {
                verbose = true;
                ++argIdx;
            }
            if (argv[argIdx].equals("-threads")) {
                threads = Integer.parseInt(argv[++argIdx]);
            }
            int n = ++argIdx;
            port = Integer.parseInt(argv[n]);
            if (argv.length > ++argIdx) {
                language = argv[argIdx++];
            }
            if (argv.length > argIdx) {
                dictionaryPath = argv[argIdx++];
            }
        }
        catch (Throwable ex) {
            if (argv.length > 0) {
                ex.printStackTrace(System.err);
            }
            System.out.println("Usage: java org.linkgrammar.LGService [-verbose] [-threads n] port [language] [dictPath]");
            System.out.println("Start a link-grammar parse server on tcp/ip port.  The server returns JSON-");
            System.out.println("formated parse results.  Socket input should be a single sentence to parse,");
            System.out.println("preceeded by the identifier \"text:\".\n");
            System.out.println("  'port'      The TCP port the service should listen to.");
            System.out.println("  -verbose    Generate verbose output.");
            System.out.println("  -threads    Specify number of concurrent threads/clients allowed (default 1).");
            System.out.println("  'language'  Language abbreviation (en, ru, de, lt or fr).");
            System.out.println("  'dictPath'  Full path to the Link-Grammar dictionaries.");
            System.exit(-1);
        }
        if (dictionaryPath != null) {
            File f = new File(dictionaryPath);
            if (!f.exists()) {
                System.err.println("Dictionary path " + dictionaryPath + " not found.");
                System.exit(-1);
            } else if (!f.isDirectory()) {
                System.err.println("Dictionary path " + dictionaryPath + " not a directory.");
                System.exit(-1);
            }
        }
        System.out.println("Starting Link Grammar Server at port " + port + ", with " + threads + " available processing threads and " + (dictionaryPath == null ? " with default dictionary location." : "with dictionary location '" + dictionaryPath + "'."));
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(threads, threads, Long.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            if (language != null) {
                LinkGrammar.setLanguage(language);
            }
            if (dictionaryPath != null) {
                LinkGrammar.setDictionariesPath(dictionaryPath);
            }
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                LGService.trace("Waiting for client connections...");
                final Socket clientSocket = serverSocket.accept();
                threadPool.submit(new Runnable(){

                    public void run() {
                        try {
                            LGService.handleClient(clientSocket);
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                            System.exit(-1);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(-1);
            return;
        }
    }
}

