/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.flow.layoutprocessor.SectionLayoutController;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.model.FormatCondition;
import org.libreoffice.report.pentaho.model.FormattedTextElement;
import org.libreoffice.report.pentaho.model.ReportElement;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class TableCellLayoutController
extends SectionLayoutController {
    protected AttributeMap computeAttributes(FlowController flowController, Element element, ReportTarget reportTarget) throws DataSourceException {
        AttributeMap attributeMap = new AttributeMap(super.computeAttributes(flowController, element, reportTarget));
        String string = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)this.getDisplayStyleName((Section)element, string));
        try {
            DataFlags dataFlags = this.computeValue(attributeMap);
            String string2 = (String)attributeMap.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
            if (dataFlags != null) {
                FormatValueUtility.applyValueForCell(dataFlags.getValue(), attributeMap, string2);
            } else if (!"string".equals(string2)) {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", (Object)"void");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        attributeMap.makeReadOnly();
        return attributeMap;
    }

    private DataFlags computeValue(AttributeMap attributeMap) throws DataSourceException {
        Section section = (Section)this.getElement();
        FormattedTextElement formattedTextElement = this.findFormattedTextElement(section);
        if (formattedTextElement == null) {
            return null;
        }
        if (!FormatValueUtility.shouldPrint(this, formattedTextElement)) {
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", (Object)"void");
            return null;
        }
        return FormatValueUtility.computeDataFlag(formattedTextElement, this.getFlowController());
    }

    public boolean isValueChanged() {
        try {
            Section section = (Section)this.getElement();
            FormattedTextElement formattedTextElement = this.findFormattedTextElement(section);
            if (formattedTextElement == null) {
                return false;
            }
            FormulaExpression formulaExpression = formattedTextElement.getValueExpression();
            Formula formula = formulaExpression.getCompiledFormula();
            LValue lValue = formula.getRootReference();
            return FormatValueUtility.isReferenceChanged(this, lValue);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private FormattedTextElement findFormattedTextElement(Section section) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            FormattedTextElement formattedTextElement;
            Node node = nodeArray[i];
            if (node instanceof FormattedTextElement) {
                return (FormattedTextElement)node;
            }
            if (!(node instanceof Section) || (formattedTextElement = this.findFormattedTextElement((Section)node)) == null) continue;
            return formattedTextElement;
        }
        return null;
    }

    private String getDisplayStyleName(Section section, String string) {
        if (!section.isEnabled() || section.getNodeCount() == 0) {
            return string;
        }
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Object object;
            Node node = nodeArray[i];
            if (node instanceof ReportElement && node.isEnabled() && ((ReportElement)(object = (ReportElement)node)).getFormatConditionCount() > 0) {
                Expression expression = ((Element)object).getDisplayCondition();
                if (expression != null) {
                    try {
                        if (Boolean.FALSE.equals(LayoutControllerUtil.evaluateExpression(this.getFlowController(), object, expression))) {
                            continue;
                        }
                    }
                    catch (DataSourceException dataSourceException) {
                        // empty catch block
                    }
                }
                FormatCondition[] formatConditionArray = ((ReportElement)object).getFormatConditions();
                for (int j = 0; j < formatConditionArray.length; ++j) {
                    FormatCondition formatCondition = formatConditionArray[j];
                    if (!formatCondition.isEnabled()) continue;
                    try {
                        Object object2 = LayoutControllerUtil.evaluateExpression(this.getFlowController(), object, formatCondition.getFormula());
                        if (!Boolean.TRUE.equals(object2)) continue;
                        return formatCondition.getStyleName();
                    }
                    catch (DataSourceException dataSourceException) {
                        // empty catch block
                    }
                }
            }
            if (!(node instanceof Section) || ObjectUtilities.equal((Object)(object = this.getDisplayStyleName((Section)node, string)), (Object)string)) continue;
            return object;
        }
        return string;
    }
}

