/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.util.ArrayList;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxc.SheetSettings;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookSettings
implements OfficeConstants {
    private Document settings = null;
    private boolean hasColumnRowHeaders = true;
    private String activeSheet = new String();
    private ArrayList<SheetSettings> worksheetSettings = new ArrayList();

    public BookSettings(Node node) {
        this.readNode(node);
    }

    public BookSettings(ArrayList<SheetSettings> arrayList) {
        this.worksheetSettings = arrayList;
    }

    public void setColumnRowHeaders(boolean bl) {
        this.hasColumnRowHeaders = bl;
    }

    public boolean hasColumnRowHeaders() {
        return this.hasColumnRowHeaders;
    }

    public ArrayList<SheetSettings> getSheetSettings() {
        return this.worksheetSettings;
    }

    public String getActiveSheet() {
        return this.activeSheet;
    }

    public void setActiveSheet(String string) {
        this.activeSheet = string;
    }

    private void addConfigItem(Node node, String string, String string2, String string3) {
        Element element = this.settings.createElement("config:config-item");
        element.setAttribute("config:name", string);
        element.setAttribute("config:type", string2);
        element.appendChild(this.settings.createTextNode(string3));
        node.appendChild(element);
    }

    public void writeNode(Document document, Node node) {
        this.settings = document;
        Element element = document.createElement("config:config-item-map-named");
        element.setAttribute("config:name", "Tables");
        for (SheetSettings sheetSettings : this.worksheetSettings) {
            sheetSettings.writeNode(document, element);
        }
        this.addConfigItem(node, "ActiveTable", "string", this.activeSheet);
        String string = Boolean.toString(this.hasColumnRowHeaders);
        this.addConfigItem(node, "HasColumnRowHeaders", "boolean", string);
        node.appendChild(element);
    }

    public void addAttribute(String string, String string2) {
        if (string.equals("ActiveTable")) {
            this.activeSheet = string2;
        } else if (string.equals("HasColumnRowHeaders")) {
            Boolean bl = Boolean.valueOf(string2);
            this.hasColumnRowHeaders = bl;
        }
    }

    public void readNode(Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("config:config-item")) {
                    object = node2.getAttributes();
                    Node node3 = object.getNamedItem("config:name");
                    String string2 = node3.getNodeValue();
                    NodeList nodeList2 = node2.getChildNodes();
                    int n2 = nodeList2.getLength();
                    String string3 = "";
                    for (int j = 0; j < n2; ++j) {
                        Node node4 = nodeList2.item(j);
                        if (node4.getNodeType() != 3) continue;
                        string3 = node4.getNodeValue();
                    }
                    this.addAttribute(string2, string3);
                    continue;
                }
                if (string.equals("config:config-item-map-named")) {
                    this.readNode(node2);
                    continue;
                }
                if (string.equals("config:config-item-map-entry")) {
                    object = new SheetSettings(node2);
                    this.worksheetSettings.add((SheetSettings)object);
                    continue;
                }
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(node2) + " />");
            }
        }
    }
}

