/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyChangeEvent;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalAccessException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.WrappedTargetRuntimeException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.reflection.XCompoundTypeDescription;
import com.sun.star.reflection.XIdlClass;
import com.sun.star.reflection.XIdlField2;
import com.sun.star.reflection.XIdlReflection;
import com.sun.star.reflection.XIndirectTypeDescription;
import com.sun.star.reflection.XInterfaceAttributeTypeDescription2;
import com.sun.star.reflection.XInterfaceMemberTypeDescription;
import com.sun.star.reflection.XInterfaceTypeDescription2;
import com.sun.star.reflection.XStructTypeDescription;
import com.sun.star.reflection.XTypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.DeploymentException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertySetMixin {
    private final XComponentContext context;
    private final XInterface object;
    private final Type type;
    private final String[] absentOptional;
    private final XIdlClass idlClass;
    private final Map<String, PropertyData> properties;
    private final String[] handleMap;
    private HashMap<String, ArrayList<XPropertyChangeListener>> boundListeners = new HashMap();
    private HashMap<String, ArrayList<XVetoableChangeListener>> vetoListeners = new HashMap();
    private boolean disposed = false;

    public PropertySetMixin(XComponentContext xComponentContext, XInterface xInterface, Type type, String[] stringArray) {
        XTypeDescription xTypeDescription;
        this.context = xComponentContext;
        this.object = xInterface;
        this.type = type;
        this.absentOptional = stringArray;
        this.idlClass = this.getReflection(type.getTypeName());
        try {
            xTypeDescription = UnoRuntime.queryInterface(XTypeDescription.class, UnoRuntime.queryInterface(XHierarchicalNameAccess.class, xComponentContext.getValueByName("/singletons/com.sun.star.reflection.theTypeDescriptionManager")).getByHierarchicalName(type.getTypeName()));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("unexpected com.sun.star.container.NoSuchElementException: " + noSuchElementException.getMessage());
        }
        HashMap<String, PropertyData> hashMap = new HashMap<String, PropertyData>();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.initProperties(xTypeDescription, hashMap, arrayList, new HashSet<String>());
        this.properties = hashMap;
        this.handleMap = arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareSet(String string, Object object, Object object2, BoundListeners boundListeners) throws PropertyVetoException {
        ArrayList<XPropertyChangeListener> arrayList;
        Property property = this.properties.get((Object)string).property;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        Object object3 = this;
        synchronized (object3) {
            if (this.disposed) {
                throw new DisposedException("disposed", this.object);
            }
            if ((property.Attributes & 4) != 0) {
                arrayList = this.vetoListeners.get(string);
                if (arrayList != null) {
                    arrayList2 = (ArrayList)arrayList.clone();
                }
                if ((arrayList = this.vetoListeners.get("")) != null) {
                    arrayList3 = (ArrayList)arrayList.clone();
                }
            }
            if ((property.Attributes & 2) != 0) {
                arrayList = this.boundListeners.get(string);
                if (arrayList != null) {
                    boundListeners.specificListeners = (ArrayList)arrayList.clone();
                }
                if ((arrayList = this.boundListeners.get("")) != null) {
                    boundListeners.unspecificListeners = (ArrayList)arrayList.clone();
                }
            }
        }
        if ((property.Attributes & 4) != 0) {
            object3 = new PropertyChangeEvent(this.object, string, false, property.Handle, object, object2);
            if (arrayList2 != null) {
                arrayList = arrayList2.iterator();
                while (arrayList.hasNext()) {
                    try {
                        ((XVetoableChangeListener)arrayList.next()).vetoableChange((PropertyChangeEvent)object3);
                    }
                    catch (DisposedException disposedException) {}
                }
            }
            if (arrayList3 != null) {
                arrayList = arrayList3.iterator();
                while (arrayList.hasNext()) {
                    try {
                        ((XVetoableChangeListener)arrayList.next()).vetoableChange((PropertyChangeEvent)object3);
                    }
                    catch (DisposedException disposedException) {}
                }
            }
        }
        if ((property.Attributes & 2) != 0) {
            boundListeners.event = new PropertyChangeEvent(this.object, string, false, property.Handle, object, object2);
        }
    }

    public void prepareSet(String string, BoundListeners boundListeners) {
        try {
            this.prepareSet(string, Any.VOID, Any.VOID, boundListeners);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new RuntimeException("unexpected " + propertyVetoException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Iterator<XEventListener> iterator;
        Iterator<ArrayList<XEventListener>> iterator2;
        HashMap<String, ArrayList<XVetoableChangeListener>> hashMap;
        HashMap<String, ArrayList<XPropertyChangeListener>> hashMap2;
        Object object = this;
        synchronized (object) {
            hashMap2 = this.boundListeners;
            this.boundListeners = null;
            hashMap = this.vetoListeners;
            this.vetoListeners = null;
            this.disposed = true;
        }
        object = new EventObject(this.object);
        if (hashMap2 != null) {
            iterator2 = hashMap2.values().iterator();
            while (iterator2.hasNext()) {
                iterator = iterator2.next().iterator();
                while (iterator.hasNext()) {
                    ((XPropertyChangeListener)iterator.next()).disposing((EventObject)object);
                }
            }
        }
        if (hashMap != null) {
            iterator2 = hashMap.values().iterator();
            while (iterator2.hasNext()) {
                iterator = iterator2.next().iterator();
                while (iterator.hasNext()) {
                    ((XVetoableChangeListener)iterator.next()).disposing((EventObject)object);
                }
            }
        }
    }

    public XPropertySetInfo getPropertySetInfo() {
        return new Info(this.properties);
    }

    public void setPropertyValue(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.setProperty(string, object, false, false, (short)1);
    }

    public Object getPropertyValue(String string) throws UnknownPropertyException, WrappedTargetException {
        return this.getProperty(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        boolean bl;
        this.checkUnknown(string);
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            bl = this.disposed;
            if (!bl) {
                ArrayList<XPropertyChangeListener> arrayList = this.boundListeners.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.boundListeners.put(string, arrayList);
                }
                arrayList.add(xPropertyChangeListener);
            }
        }
        if (bl) {
            xPropertyChangeListener.disposing(new EventObject(this.object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.checkUnknown(string);
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            ArrayList<XPropertyChangeListener> arrayList;
            if (this.boundListeners != null && (arrayList = this.boundListeners.get(string)) != null) {
                arrayList.remove(xPropertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        boolean bl;
        this.checkUnknown(string);
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            bl = this.disposed;
            if (!bl) {
                ArrayList<XVetoableChangeListener> arrayList = this.vetoListeners.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.vetoListeners.put(string, arrayList);
                }
                arrayList.add(xVetoableChangeListener);
            }
        }
        if (bl) {
            xVetoableChangeListener.disposing(new EventObject(this.object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.checkUnknown(string);
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            ArrayList<XVetoableChangeListener> arrayList;
            if (this.vetoListeners != null && (arrayList = this.vetoListeners.get(string)) != null) {
                arrayList.remove(xVetoableChangeListener);
            }
        }
    }

    public void setFastPropertyValue(int n, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.setProperty(this.translateHandle(n), object, false, false, (short)1);
    }

    public Object getFastPropertyValue(int n) throws UnknownPropertyException, WrappedTargetException {
        return this.getProperty(this.translateHandle(n), null);
    }

    public PropertyValue[] getPropertyValues() {
        PropertyValue[] propertyValueArray = new PropertyValue[this.handleMap.length];
        int n = 0;
        for (int i = 0; i < this.handleMap.length; ++i) {
            Object object;
            PropertyState[] propertyStateArray = new PropertyState[1];
            try {
                object = this.getProperty(this.handleMap[i], propertyStateArray);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                throw new WrappedTargetRuntimeException(wrappedTargetException.getMessage(), this.object, wrappedTargetException.TargetException);
            }
            propertyValueArray[n++] = new PropertyValue(this.handleMap[i], i, object, propertyStateArray[0]);
        }
        if (n < this.handleMap.length) {
            PropertyValue[] propertyValueArray2 = new PropertyValue[n];
            System.arraycopy(propertyValueArray, 0, propertyValueArray2, 0, n);
            propertyValueArray = propertyValueArray2;
        }
        return propertyValueArray;
    }

    public void setPropertyValues(PropertyValue[] propertyValueArray) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        for (int i = 0; i < propertyValueArray.length; ++i) {
            if (propertyValueArray[i].Handle != -1 && !propertyValueArray[i].Name.equals(this.translateHandle(propertyValueArray[i].Handle))) {
                throw new UnknownPropertyException("name " + propertyValueArray[i].Name + " does not match handle " + propertyValueArray[i].Handle, this.object);
            }
            this.setProperty(propertyValueArray[i].Name, propertyValueArray[i].Value, propertyValueArray[i].State == PropertyState.AMBIGUOUS_VALUE, propertyValueArray[i].State == PropertyState.DEFAULT_VALUE, (short)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XIdlClass getReflection(String string) {
        XIdlReflection xIdlReflection;
        try {
            xIdlReflection = UnoRuntime.queryInterface(XIdlReflection.class, this.context.getServiceManager().createInstanceWithContext("com.sun.star.reflection.CoreReflection", this.context));
        }
        catch (Exception exception) {
            throw new DeploymentException("component context fails to supply service com.sun.star.reflection.CoreReflection: " + exception.getMessage(), this.context);
        }
        try {
            XIdlClass xIdlClass = xIdlReflection.forName(string);
            return xIdlClass;
        }
        finally {
            XComponent xComponent = UnoRuntime.queryInterface(XComponent.class, (Object)xIdlReflection);
            if (xComponent != null) {
                xComponent.dispose();
            }
        }
    }

    private void initProperties(XTypeDescription xTypeDescription, HashMap<String, PropertyData> hashMap, ArrayList<String> arrayList, HashSet<String> hashSet) {
        XInterfaceTypeDescription2 xInterfaceTypeDescription2 = UnoRuntime.queryInterface(XInterfaceTypeDescription2.class, (Object)PropertySetMixin.resolveTypedefs(xTypeDescription));
        if (hashSet.add(xInterfaceTypeDescription2.getName())) {
            XTypeDescription[] xTypeDescriptionArray = xInterfaceTypeDescription2.getBaseTypes();
            for (int i = 0; i < xTypeDescriptionArray.length; ++i) {
                this.initProperties(xTypeDescriptionArray[i], hashMap, arrayList, hashSet);
            }
            XInterfaceMemberTypeDescription[] xInterfaceMemberTypeDescriptionArray = xInterfaceTypeDescription2.getMembers();
            for (int i = 0; i < xInterfaceMemberTypeDescriptionArray.length; ++i) {
                int n;
                if (xInterfaceMemberTypeDescriptionArray[i].getTypeClass() != TypeClass.INTERFACE_ATTRIBUTE) continue;
                XInterfaceAttributeTypeDescription2 xInterfaceAttributeTypeDescription2 = UnoRuntime.queryInterface(XInterfaceAttributeTypeDescription2.class, (Object)xInterfaceMemberTypeDescriptionArray[i]);
                short s = 0;
                if (xInterfaceAttributeTypeDescription2.isBound()) {
                    s = (short)(s | 2);
                }
                boolean bl = false;
                if (xInterfaceAttributeTypeDescription2.isReadOnly()) {
                    s = (short)(s | 0x10);
                    bl = true;
                }
                XCompoundTypeDescription[] xCompoundTypeDescriptionArray = xInterfaceAttributeTypeDescription2.getGetExceptions();
                boolean bl2 = false;
                for (n = 0; n < xCompoundTypeDescriptionArray.length; ++n) {
                    if (!xCompoundTypeDescriptionArray[n].getName().equals("com.sun.star.beans.UnknownPropertyException")) continue;
                    bl2 = true;
                    break;
                }
                xCompoundTypeDescriptionArray = xInterfaceAttributeTypeDescription2.getSetExceptions();
                for (n = 0; n < xCompoundTypeDescriptionArray.length; ++n) {
                    if (xCompoundTypeDescriptionArray[n].getName().equals("com.sun.star.beans.UnknownPropertyException")) {
                        bl = true;
                        continue;
                    }
                    if (!xCompoundTypeDescriptionArray[n].getName().equals("com.sun.star.beans.PropertyVetoException")) continue;
                    s = (short)(s | 4);
                }
                if (bl2 && bl) {
                    s = (short)(s | 0x100);
                }
                XTypeDescription xTypeDescription2 = xInterfaceAttributeTypeDescription2.getType();
                while (true) {
                    int n2;
                    if ((xTypeDescription2 = PropertySetMixin.resolveTypedefs(xTypeDescription2)).getName().startsWith("com.sun.star.beans.Ambiguous<")) {
                        n2 = 32;
                    } else if (xTypeDescription2.getName().startsWith("com.sun.star.beans.Defaulted<")) {
                        n2 = 64;
                    } else {
                        if (!xTypeDescription2.getName().startsWith("com.sun.star.beans.Optional<")) break;
                        n2 = 1;
                    }
                    s = (short)(s | n2);
                    xTypeDescription2 = UnoRuntime.queryInterface(XStructTypeDescription.class, (Object)xTypeDescription2).getTypeArguments()[0];
                }
                String string = xInterfaceMemberTypeDescriptionArray[i].getMemberName();
                boolean bl3 = true;
                if (this.absentOptional != null) {
                    for (int j = 0; j < this.absentOptional.length; ++j) {
                        if (!string.equals(this.absentOptional[j])) continue;
                        bl3 = false;
                        break;
                    }
                }
                if (hashMap.put(string, new PropertyData(new Property(string, arrayList.size(), new Type(xTypeDescription2.getName(), xTypeDescription2.getTypeClass()), s), bl3)) != null) {
                    throw new RuntimeException("inconsistent UNO type registry");
                }
                arrayList.add(string);
            }
        }
    }

    private String translateHandle(int n) throws UnknownPropertyException {
        if (n < 0 || n >= this.handleMap.length) {
            throw new UnknownPropertyException("bad handle " + n, this.object);
        }
        return this.handleMap[n];
    }

    private void setProperty(String string, Object object, boolean bl, boolean bl2, short s) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        PropertyData propertyData = this.properties.get(string);
        if (propertyData == null) {
            throw new UnknownPropertyException(string, this.object);
        }
        if (bl && (propertyData.property.Attributes & 0x20) == 0 || bl2 && (propertyData.property.Attributes & 0x40) == 0) {
            throw new IllegalArgumentException("flagging as ambiguous/defaulted non-ambiguous/defaulted property " + string, this.object, s);
        }
        XIdlField2 xIdlField2 = UnoRuntime.queryInterface(XIdlField2.class, (Object)this.idlClass.getField(string));
        Object[] objectArray = new Object[]{new Any(this.type, UnoRuntime.queryInterface(this.type, (Object)this.object))};
        Object object2 = this.wrapValue(object, UnoRuntime.queryInterface(XIdlField2.class, (Object)this.idlClass.getField(string)).getType(), (propertyData.property.Attributes & 0x20) != 0, bl, (propertyData.property.Attributes & 0x40) != 0, bl2, (propertyData.property.Attributes & 1) != 0);
        try {
            xIdlField2.set(objectArray, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.ArgumentPosition == 1) {
                throw new IllegalArgumentException(illegalArgumentException.getMessage(), this.object, s);
            }
            throw new RuntimeException("unexpected com.sun.star.lang.IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyVetoException("cannot set read-only property " + string, this.object);
        }
        catch (WrappedTargetRuntimeException wrappedTargetRuntimeException) {
            if (new Type(UnknownPropertyException.class).isSupertypeOf(AnyConverter.getType(wrappedTargetRuntimeException.TargetException)) && (propertyData.property.Attributes & 0x100) != 0) {
                throw new UnknownPropertyException(string, this.object);
            }
            if (new Type(PropertyVetoException.class).isSupertypeOf(AnyConverter.getType(wrappedTargetRuntimeException.TargetException)) && (propertyData.property.Attributes & 4) != 0) {
                throw new PropertyVetoException(string, this.object);
            }
            throw new WrappedTargetException(wrappedTargetRuntimeException.getMessage(), this.object, wrappedTargetRuntimeException.TargetException);
        }
    }

    Object getProperty(String string, PropertyState[] propertyStateArray) throws UnknownPropertyException, WrappedTargetException {
        Object object;
        PropertyData propertyData = this.properties.get(string);
        if (propertyData == null) {
            throw new UnknownPropertyException(string, this.object);
        }
        XIdlField2 xIdlField2 = UnoRuntime.queryInterface(XIdlField2.class, (Object)this.idlClass.getField(string));
        try {
            object = xIdlField2.get(new Any(this.type, UnoRuntime.queryInterface(this.type, (Object)this.object)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("unexpected com.sun.star.lang.IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        catch (WrappedTargetRuntimeException wrappedTargetRuntimeException) {
            if (new Type(UnknownPropertyException.class).isSupertypeOf(AnyConverter.getType(wrappedTargetRuntimeException.TargetException)) && (propertyData.property.Attributes & 0x100) != 0) {
                throw new UnknownPropertyException(string, this.object);
            }
            throw new WrappedTargetException(wrappedTargetRuntimeException.getMessage(), this.object, wrappedTargetRuntimeException.TargetException);
        }
        boolean bl = (propertyData.property.Attributes & 0x20) != 0;
        boolean bl2 = (propertyData.property.Attributes & 0x40) != 0;
        boolean bl3 = (propertyData.property.Attributes & 1) != 0;
        boolean bl4 = false;
        boolean bl5 = false;
        while (bl || bl2 || bl3) {
            XIdlClass xIdlClass;
            String string2 = AnyConverter.getType(object).getTypeName();
            if (bl && string2.startsWith("com.sun.star.beans.Ambiguous<")) {
                xIdlClass = this.getReflection(string2);
                try {
                    bl4 = AnyConverter.toBoolean(UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("IsAmbiguous")).get(object));
                    object = UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("Value")).get(object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException("unexpected com.sun.star.lang.IllegalArgumentException: " + illegalArgumentException.getMessage());
                }
                bl = false;
                continue;
            }
            if (bl2 && string2.startsWith("com.sun.star.beans.Defaulted<")) {
                xIdlClass = this.getReflection(string2);
                try {
                    bl5 = AnyConverter.toBoolean(UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("IsDefaulted")).get(object));
                    object = UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("Value")).get(object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException("unexpected com.sun.star.lang.IllegalArgumentException: " + illegalArgumentException.getMessage());
                }
                bl2 = false;
                continue;
            }
            if (bl3 && string2.startsWith("com.sun.star.beans.Optional<")) {
                xIdlClass = this.getReflection(string2);
                try {
                    boolean bl6 = AnyConverter.toBoolean(UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("IsPresent")).get(object));
                    if (!bl6) {
                        object = Any.VOID;
                        break;
                    }
                    object = UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("Value")).get(object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException("unexpected com.sun.star.lang.IllegalArgumentException: " + illegalArgumentException.getMessage());
                }
                bl3 = false;
                continue;
            }
            throw new RuntimeException("unexpected type of attribute " + string);
        }
        if (propertyStateArray != null) {
            propertyStateArray[0] = bl4 ? PropertyState.AMBIGUOUS_VALUE : (bl5 ? PropertyState.DEFAULT_VALUE : PropertyState.DIRECT_VALUE);
        }
        return object;
    }

    private Object wrapValue(Object object, XIdlClass xIdlClass, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl && xIdlClass.getName().startsWith("com.sun.star.beans.Ambiguous<")) {
            Object[] objectArray = new Object[1];
            xIdlClass.createObject(objectArray);
            try {
                XIdlField2 xIdlField2 = UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("Value"));
                xIdlField2.set(objectArray, this.wrapValue(object, xIdlField2.getType(), false, false, bl3, bl4, bl5));
                UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("IsAmbiguous")).set(objectArray, new Boolean(bl2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("unexpected com.sun.star.lang.IllegalArgumentException: " + illegalArgumentException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("unexpected com.sun.star.lang.IllegalAccessException: " + illegalAccessException.getMessage());
            }
            return objectArray[0];
        }
        if (bl3 && xIdlClass.getName().startsWith("com.sun.star.beans.Defaulted<")) {
            Object[] objectArray = new Object[1];
            xIdlClass.createObject(objectArray);
            try {
                XIdlField2 xIdlField2 = UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("Value"));
                xIdlField2.set(objectArray, this.wrapValue(object, xIdlField2.getType(), bl, bl2, false, false, bl5));
                UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("IsDefaulted")).set(objectArray, new Boolean(bl4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("unexpected com.sun.star.lang.IllegalArgumentException: " + illegalArgumentException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("unexpected com.sun.star.lang.IllegalAccessException: " + illegalAccessException.getMessage());
            }
            return objectArray[0];
        }
        if (bl5 && xIdlClass.getName().startsWith("com.sun.star.beans.Optional<")) {
            Object[] objectArray = new Object[1];
            xIdlClass.createObject(objectArray);
            boolean bl6 = !AnyConverter.isVoid(object);
            try {
                UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("IsPresent")).set(objectArray, new Boolean(bl6));
                if (bl6) {
                    XIdlField2 xIdlField2 = UnoRuntime.queryInterface(XIdlField2.class, (Object)xIdlClass.getField("Value"));
                    xIdlField2.set(objectArray, this.wrapValue(object, xIdlField2.getType(), bl, bl2, bl3, bl4, false));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("unexpected com.sun.star.lang.IllegalArgumentException: " + illegalArgumentException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("unexpected com.sun.star.lang.IllegalAccessException: " + illegalAccessException.getMessage());
            }
            return objectArray[0];
        }
        if (bl || bl3 || bl5) {
            throw new RuntimeException("unexpected type of attribute");
        }
        return object;
    }

    private static XTypeDescription resolveTypedefs(XTypeDescription xTypeDescription) {
        while (xTypeDescription.getTypeClass() == TypeClass.TYPEDEF) {
            xTypeDescription = UnoRuntime.queryInterface(XIndirectTypeDescription.class, (Object)xTypeDescription).getReferencedType();
        }
        return xTypeDescription;
    }

    private PropertyData get(Object object, String string) throws UnknownPropertyException {
        PropertyData propertyData = this.properties.get(string);
        if (propertyData == null || !propertyData.present) {
            throw new UnknownPropertyException(string, object);
        }
        return propertyData;
    }

    private void checkUnknown(String string) throws UnknownPropertyException {
        if (!string.equals("")) {
            this.get(this, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Info
    extends WeakBase
    implements XPropertySetInfo {
        private final Map<String, PropertyData> properties;

        public Info(Map<String, PropertyData> map) {
            this.properties = map;
        }

        @Override
        public Property[] getProperties() {
            ArrayList<Property> arrayList = new ArrayList<Property>(this.properties.size());
            for (PropertyData propertyData : this.properties.values()) {
                if (!propertyData.present) continue;
                arrayList.add(propertyData.property);
            }
            return arrayList.toArray(new Property[arrayList.size()]);
        }

        @Override
        public Property getPropertyByName(String string) throws UnknownPropertyException {
            return ((PropertySetMixin)PropertySetMixin.this).get((Object)this, (String)string).property;
        }

        @Override
        public boolean hasPropertyByName(String string) {
            PropertyData propertyData = this.properties.get(string);
            return propertyData != null && propertyData.present;
        }
    }

    private static final class PropertyData {
        public final Property property;
        public final boolean present;

        public PropertyData(Property property, boolean bl) {
            this.property = property;
            this.present = bl;
        }
    }

    public static final class BoundListeners {
        private ArrayList<XPropertyChangeListener> specificListeners = null;
        private ArrayList<XPropertyChangeListener> unspecificListeners = null;
        private PropertyChangeEvent event = null;

        public void notifyListeners() {
            Iterator<XPropertyChangeListener> iterator;
            if (this.specificListeners != null) {
                iterator = this.specificListeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        iterator.next().propertyChange(this.event);
                    }
                    catch (DisposedException disposedException) {}
                }
            }
            if (this.unspecificListeners != null) {
                iterator = this.unspecificListeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        iterator.next().propertyChange(this.event);
                    }
                    catch (DisposedException disposedException) {}
                }
            }
        }
    }
}

