/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*          Copyright (c) 1985-2014 AT&T Intellectual Property          *
*                      and is licensed under the                       *
*                 Eclipse Public License, Version 1.0                  *
*                    by AT&T Intellectual Property                     *
*                                                                      *
*                A copy of the License is available at                 *
*          http://www.eclipse.org/org/documents/epl-v10.html           *
*         (with md5 checksum b35adb5213ca9657e911e9befb180842)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Phong Vo <kpv@research.att.com>                    *
*                                                                      *
***********************************************************************/

/* : : generated by proto : : */
/* : : generated from /usr/obj/ksh93-20120801/src/lib/libast/features/iconv by iffe version 2012-07-17 : : */
                  
#ifndef _def_iconv_ast
#if !defined(__PROTO__)
#  if defined(__STDC__) || defined(__cplusplus) || defined(_proto) || defined(c_plusplus)
#    if defined(__cplusplus)
#      define __LINKAGE__	"C"
#    else
#      define __LINKAGE__
#    endif
#    define __STDARG__
#    define __PROTO__(x)	x
#    define __OTORP__(x)
#    define __PARAM__(n,o)	n
#    if !defined(__STDC__) && !defined(__cplusplus)
#      if !defined(c_plusplus)
#      	define const
#      endif
#      define signed
#      define void		int
#      define volatile
#      define __V_		char
#    else
#      define __V_		void
#    endif
#  else
#    define __PROTO__(x)	()
#    define __OTORP__(x)	x
#    define __PARAM__(n,o)	o
#    define __LINKAGE__
#    define __V_		char
#    define const
#    define signed
#    define void		int
#    define volatile
#  endif
#  define __MANGLE__	__LINKAGE__
#  if defined(__cplusplus) || defined(c_plusplus)
#    define __VARARG__	...
#  else
#    define __VARARG__
#  endif
#  if defined(__STDARG__)
#    define __VA_START__(p,a)	va_start(p,a)
#  else
#    define __VA_START__(p,a)	va_start(p)
#  endif
#  if !defined(__INLINE__)
#    if defined(__cplusplus)
#      define __INLINE__	extern __MANGLE__ inline
#    else
#      if defined(_WIN32) && !defined(__GNUC__)
#      	define __INLINE__	__inline
#      endif
#    endif
#  endif
#endif
#if !defined(__LINKAGE__)
#define __LINKAGE__		/* 2004-08-11 transition */
#endif

#define _def_iconv_ast	1
#define _sys_types	1	/* #include <sys/types.h> ok */
#include <ast_common.h>
#include <ccode.h>
#undef	_hdr_iconv
#undef	_lib_iconv_open

#define ICONV_VERSION		20110111L

#define ICONV_FATAL		0x02
#define ICONV_OMIT		0x04

#define CC_ICONV		(-1)
#define CC_UCS			(-2)
#define CC_SCU			(-3)
#define CC_UTF			(-4)
#define CC_UME			(-5)


typedef int (*Iconv_error_f) __PROTO__((__V_*, __V_*, int, ...));

typedef struct Iconv_disc_s
{
	uint32_t		version;
	Iconv_error_f		errorf;
	size_t			errors;
	uint32_t		flags;
	int			fill;
} Iconv_disc_t;

typedef Ccmap_t iconv_list_t;
typedef __V_* iconv_t;
typedef size_t (*iconv_f) __PROTO__((iconv_t, char**, size_t*, char**, size_t*));

#define iconv_init(d,e)		(memset(d,0,sizeof(*(d))),(d)->version=ICONV_VERSION,(d)->errorf=(Iconv_error_f)(e),(d)->fill=(-1))

#if _BLD_ast && defined(__EXPORT__)
#undef __MANGLE__
#define __MANGLE__ __LINKAGE__		__EXPORT__
#endif

extern __MANGLE__ iconv_t	iconv_open __PROTO__((const char*, const char*));
extern __MANGLE__ size_t		iconv __PROTO__((iconv_t, char**, size_t*, char**, size_t*));
extern __MANGLE__ int		iconv_close __PROTO__((iconv_t));
extern __MANGLE__ iconv_list_t*	iconv_list __PROTO__((iconv_list_t*));
extern __MANGLE__ int		iconv_name __PROTO__((const char*, char*, size_t));
#if _SFIO_H
extern __MANGLE__ ssize_t		iconv_move __PROTO__((iconv_t, Sfio_t*, Sfio_t*, size_t, Iconv_disc_t*));
extern __MANGLE__ ssize_t		iconv_write __PROTO__((iconv_t, Sfio_t*, char**, size_t*, Iconv_disc_t*));
#else
#if _SFSTDIO_H
extern __MANGLE__ ssize_t		iconv_move __PROTO__((iconv_t, FILE*, FILE*, size_t, Iconv_disc_t*));
extern __MANGLE__ ssize_t		iconv_write __PROTO__((iconv_t, FILE*, char**, size_t*, Iconv_disc_t*));
#endif
#endif

#undef __MANGLE__
#define __MANGLE__ __LINKAGE__

#endif
