/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;

public class PKCS10Request {
    private X500Name subject;
    private SubjectPublicKeyInfo publicKeyInfo;
    private PKCS10CertificationRequestBuilder builder;
    private PKCS10CertificationRequest signedRequest;
    private boolean valid = false;

    public PKCS10Request(X500Name subject, SubjectPublicKeyInfo publicKeyInfo, List<Attribute> attrs) {
        this.subject = subject;
        this.publicKeyInfo = publicKeyInfo;
        this.resetBuilder();
        this.setAttributes(attrs);
    }

    public PKCS10Request(X500Name subject, PublicKey publicKey, List<Attribute> attrs) {
        this.subject = subject;
        this.publicKeyInfo = this.makePublicKeyInfo(publicKey);
        this.resetBuilder();
        this.setAttributes(attrs);
    }

    public PKCS10Request(CertificationRequest req) {
        this.subject = req.getCertificationRequestInfo().getSubject();
        this.publicKeyInfo = req.getCertificationRequestInfo().getSubjectPublicKeyInfo();
        this.signedRequest = new PKCS10CertificationRequest(req);
        this.valid = true;
    }

    public PKCS10Request(byte[] bytes) {
        this(CertificationRequest.getInstance((Object)bytes));
    }

    public PKCS10Request(ASN1Sequence sequence) {
        this(CertificationRequest.getInstance((Object)sequence));
    }

    public PKCS10CertificationRequest sign(PrivateKey privateKey, AlgorithmIdentifier sigAlg) throws IOException {
        PKCS10Signer signer;
        try {
            signer = new PKCS10Signer(privateKey, sigAlg);
        }
        catch (Exception e) {
            throw new IOException("Could not create PKCS10 signer: " + e);
        }
        this.signedRequest = this.builder.build((ContentSigner)signer);
        this.valid = true;
        return this.signedRequest;
    }

    public PKCS10CertificationRequest sign(PrivateKey privateKey, String digestAlg) throws IOException {
        PublicKey pk = this.getPublicKey();
        String sigAlg = digestAlg + "WITH" + pk.getAlgorithm();
        return this.sign(privateKey, new DefaultSignatureAlgorithmIdentifierFinder().find(sigAlg));
    }

    public boolean verify(PublicKey publicKey) throws IOException, InvalidKeyException {
        if (this.signedRequest == null) {
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        try {
            PKCS10VerifierProvider verifier = new PKCS10VerifierProvider(publicKey);
            return this.signedRequest.isSignatureValid((ContentVerifierProvider)verifier);
        }
        catch (Exception e) {
            throw new IOException("Error verifying signature: " + e);
        }
    }

    private void resetBuilder() {
        this.builder = new PKCS10CertificationRequestBuilder(this.subject, this.publicKeyInfo);
        this.valid = false;
    }

    private boolean isValid() {
        return this.valid;
    }

    private SubjectPublicKeyInfo makePublicKeyInfo(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        return SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
    }

    public static boolean algorithmMismatch(String keyAlg, String digAlg, String digName) {
        return "DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(digName) || "DSA".equalsIgnoreCase(keyAlg) && "SHA1".equals(digName);
    }

    public ASN1Sequence toASN1Structure() {
        if (this.signedRequest != null) {
            return ASN1Sequence.getInstance((Object)this.signedRequest.toASN1Structure());
        }
        return new DLSequence();
    }

    public void setSubject(X500Name subject) {
        this.subject = subject;
        this.resetBuilder();
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKeyInfo = this.makePublicKeyInfo(publicKey);
        this.resetBuilder();
    }

    public PublicKey getPublicKey() throws IOException {
        AsymmetricKeyParameter keyParams = PublicKeyFactory.createKey((SubjectPublicKeyInfo)this.publicKeyInfo);
        KeySpec keySpec = null;
        KeyFactory keyFact = null;
        try {
            if (keyParams instanceof RSAKeyParameters) {
                RSAKeyParameters rsa = (RSAKeyParameters)keyParams;
                keySpec = new RSAPublicKeySpec(rsa.getModulus(), rsa.getExponent());
                keyFact = KeyFactory.getInstance("RSA");
            } else if (keyParams instanceof DSAPublicKeyParameters) {
                DSAPublicKeyParameters dsa = (DSAPublicKeyParameters)keyParams;
                DSAParameters params = dsa.getParameters();
                keySpec = new DSAPublicKeySpec(dsa.getY(), params.getP(), params.getQ(), params.getG());
                keyFact = KeyFactory.getInstance("DSA");
            }
            if (keySpec != null && keyFact != null) {
                return keyFact.generatePublic(keySpec);
            }
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        throw new IOException("Could not read public key");
    }

    public Attribute[] getAttributes() {
        return this.signedRequest != null ? this.signedRequest.getAttributes() : new Attribute[]{};
    }

    public void setAttributes(List<Attribute> attrs) {
        this.resetBuilder();
        this.addAttributes(attrs);
    }

    private void addAttributes(List<Attribute> attrs) {
        if (attrs == null) {
            return;
        }
        for (Attribute attr : attrs) {
            this.addAttribute(attr);
        }
    }

    public void addAttribute(Attribute attr) {
        for (ASN1Encodable value : attr.getAttributeValues()) {
            this.addAttribute(attr.getAttrType(), value);
        }
    }

    public void addAttribute(ASN1ObjectIdentifier oid, ASN1Encodable value) {
        this.valid = false;
        this.builder.addAttribute(oid, value);
    }

    public int getVersion() {
        if (!this.isValid()) {
            return 0;
        }
        return this.signedRequest.toASN1Structure().getCertificationRequestInfo().getVersion().getValue().intValue();
    }

    private class SignatureOutputStream
    extends OutputStream {
        private Signature sig;

        public SignatureOutputStream(Signature sig) {
            this.sig = sig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.sig.update(bytes, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("exception in pkcs10 signer: " + e.getMessage(), e);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.sig.update(bytes);
            }
            catch (SignatureException e) {
                throw new IOException("exception in pkcs10 signer: " + e.getMessage(), e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.sig.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("exception in pkcs10 signer: " + e.getMessage(), e);
            }
        }
    }

    private class PKCS10Verifier
    implements ContentVerifier {
        AlgorithmIdentifier sigAlg;
        Signature sig;
        SignatureOutputStream sigOut;

        public PKCS10Verifier(PublicKey publicKey, AlgorithmIdentifier sigAlg) throws NoSuchAlgorithmException, InvalidKeyException {
            this.sigAlg = sigAlg;
            this.sig = Signature.getInstance(sigAlg.getAlgorithm().getId());
            this.sig.initVerify(publicKey);
            this.sigOut = new SignatureOutputStream(this.sig);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.sigAlg;
        }

        public OutputStream getOutputStream() {
            return this.sigOut;
        }

        public boolean verify(byte[] expected) {
            try {
                return this.sig.verify(expected);
            }
            catch (SignatureException e) {
                throw new RuntimeException("Could not verify signature: " + e);
            }
        }
    }

    private class PKCS10VerifierProvider
    implements ContentVerifierProvider {
        PublicKey publicKey;

        public PKCS10VerifierProvider(PublicKey key) {
            this.publicKey = key;
        }

        public ContentVerifier get(AlgorithmIdentifier sigAlg) {
            try {
                return new PKCS10Verifier(this.publicKey, sigAlg);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create content verifier: " + e);
            }
        }

        public boolean hasAssociatedCertificate() {
            return false;
        }

        public X509CertificateHolder getAssociatedCertificate() {
            return null;
        }
    }

    private class PKCS10Signer
    implements ContentSigner {
        AlgorithmIdentifier sigAlg;
        Signature sig;
        SignatureOutputStream sigOut;

        public PKCS10Signer(PrivateKey pkey, AlgorithmIdentifier sigAlg) throws NoSuchAlgorithmException, InvalidKeyException {
            this.sigAlg = sigAlg;
            this.sig = Signature.getInstance(sigAlg.getAlgorithm().getId());
            this.sig.initSign(pkey);
            this.sigOut = new SignatureOutputStream(this.sig);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.sigAlg;
        }

        public OutputStream getOutputStream() {
            return this.sigOut;
        }

        public byte[] getSignature() {
            try {
                return this.sig.sign();
            }
            catch (SignatureException e) {
                throw new RuntimeException("Could not read signature: " + e);
            }
        }
    }
}

