/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"X509Name"}, include={"Comparable"})
public class X509Name
extends RubyObject {
    private static final long serialVersionUID = -226196051911335103L;
    private static ObjectAllocator X509NAME_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Name(runtime, klass);
        }
    };
    public static final int COMPAT = 0;
    public static final int RFC2253 = 17892119;
    public static final int ONELINE = 8520479;
    public static final int MULTILINE = 44302342;
    private List<Object> oids = new ArrayList<Object>();
    private List<Object> values = new ArrayList<Object>();
    private List<Object> types = new ArrayList<Object>();

    public static void createX509Name(Ruby runtime, RubyModule mX509) {
        RubyClass cX509Name = mX509.defineClassUnder("Name", runtime.getObject(), X509NAME_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("NameError", openSSLError, openSSLError.getAllocator());
        cX509Name.defineAnnotatedMethods(X509Name.class);
        cX509Name.setConstant("COMPAT", (IRubyObject)runtime.newFixnum(0));
        cX509Name.setConstant("RFC2253", (IRubyObject)runtime.newFixnum(17892119));
        cX509Name.setConstant("ONELINE", (IRubyObject)runtime.newFixnum(8520479));
        cX509Name.setConstant("MULTILINE", (IRubyObject)runtime.newFixnum(44302342));
        cX509Name.setConstant("DEFAULT_OBJECT_TYPE", (IRubyObject)runtime.newFixnum(12));
        RubyHash hash = new RubyHash(runtime, (IRubyObject)runtime.newFixnum(12));
        hash.op_aset(runtime.getCurrentContext(), (IRubyObject)runtime.newString("C"), (IRubyObject)runtime.newFixnum(19));
        hash.op_aset(runtime.getCurrentContext(), (IRubyObject)runtime.newString("countryName"), (IRubyObject)runtime.newFixnum(19));
        hash.op_aset(runtime.getCurrentContext(), (IRubyObject)runtime.newString("serialNumber"), (IRubyObject)runtime.newFixnum(19));
        hash.op_aset(runtime.getCurrentContext(), (IRubyObject)runtime.newString("dnQualifier"), (IRubyObject)runtime.newFixnum(19));
        hash.op_aset(runtime.getCurrentContext(), (IRubyObject)runtime.newString("DC"), (IRubyObject)runtime.newFixnum(22));
        hash.op_aset(runtime.getCurrentContext(), (IRubyObject)runtime.newString("domainComponent"), (IRubyObject)runtime.newFixnum(22));
        hash.op_aset(runtime.getCurrentContext(), (IRubyObject)runtime.newString("emailAddress"), (IRubyObject)runtime.newFixnum(22));
        cX509Name.setConstant("OBJECT_TYPE_TEMPLATE", (IRubyObject)hash);
        cX509Name.includeModule((IRubyObject)runtime.getComparable());
    }

    public X509Name(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    void addEntry(Object oid, Object value, Object type) {
        this.oids.add(oid);
        this.values.add(value);
        this.types.add(type);
    }

    public static X509Name create(Ruby runtime, X500Name realName) {
        X509Name name = new X509Name(runtime, Utils.getClassFromPath(runtime, "OpenSSL::X509::Name"));
        name.fromASN1Sequence((ASN1Sequence)realName.toASN1Primitive());
        return name;
    }

    void fromASN1Sequence(ASN1Sequence seq) {
        this.oids = new ArrayList<Object>();
        this.values = new ArrayList<Object>();
        this.types = new ArrayList<Object>();
        if (seq != null) {
            Enumeration enumRdn = seq.getObjects();
            while (enumRdn.hasMoreElements()) {
                ASN1Object element = (ASN1Object)enumRdn.nextElement();
                if (element instanceof RDN) {
                    this.fromRDNElement(element);
                    continue;
                }
                if (element instanceof ASN1Sequence) {
                    this.fromASN1Sequence(element);
                    continue;
                }
                this.fromASN1Set(element);
            }
        }
    }

    private void fromRDNElement(Object element) {
        RDN rdn = (RDN)element;
        for (AttributeTypeAndValue tv : rdn.getTypesAndValues()) {
            this.oids.add(tv.getType());
            if (tv.getValue() instanceof ASN1String) {
                this.values.add(((ASN1String)tv.getValue()).getString());
            } else {
                this.values.add(null);
            }
            this.types.add(this.getRuntime().newFixnum(ASN1.idForClass(tv.getValue().getClass())));
        }
    }

    private void fromASN1Set(Object element) {
        ASN1Set typeAndValue = ASN1Set.getInstance((Object)element);
        Enumeration enumRdn = typeAndValue.getObjects();
        while (enumRdn.hasMoreElements()) {
            this.fromASN1Sequence(enumRdn.nextElement());
        }
    }

    private void fromASN1Sequence(Object element) {
        ASN1Sequence typeAndValue = ASN1Sequence.getInstance((Object)element);
        this.oids.add(typeAndValue.getObjectAt(0));
        if (typeAndValue.getObjectAt(1) instanceof ASN1String) {
            this.values.add(((ASN1String)typeAndValue.getObjectAt(1)).getString());
        } else {
            this.values.add(null);
        }
        this.types.add(this.getRuntime().newFixnum(ASN1.idForClass(typeAndValue.getObjectAt(1).getClass())));
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject str_or_dn) {
        return this.initialize(context, str_or_dn, context.nil);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject dn, IRubyObject template) {
        Ruby runtime = context.runtime;
        if (dn instanceof RubyArray) {
            RubyArray ary = (RubyArray)dn;
            if (template.isNil()) {
                template = runtime.getClassFromPath("OpenSSL::X509::Name").getConstant("OBJECT_TYPE_TEMPLATE");
            }
            for (int i = 0; i < ary.size(); ++i) {
                IRubyObject entry2;
                IRubyObject obj = ary.eltOk((long)i);
                if (!(obj instanceof RubyArray)) {
                    throw runtime.newTypeError(obj, runtime.getArray());
                }
                RubyArray arr = (RubyArray)obj;
                IRubyObject entry0 = arr.size() > 0 ? arr.eltOk(0L) : context.nil;
                IRubyObject entry1 = arr.size() > 1 ? arr.eltOk(1L) : context.nil;
                IRubyObject iRubyObject = entry2 = arr.size() > 2 ? arr.eltOk(2L) : context.nil;
                if (entry2.isNil()) {
                    entry2 = template.callMethod(context, "[]", entry0);
                }
                if (entry2.isNil()) {
                    entry2 = runtime.getClassFromPath("OpenSSL::X509::Name").getConstant("DEFAULT_OBJECT_TYPE");
                }
                this.add_entry(context, entry0, entry1, entry2);
            }
        } else {
            try {
                byte[] bytes = OpenSSLImpl.to_der_if_possible(dn).convertToString().getBytes();
                ASN1InputStream is = new ASN1InputStream(bytes);
                ASN1Sequence seq = (ASN1Sequence)is.readObject();
                this.fromASN1Sequence(seq);
            }
            catch (IOException e) {
                throw X509Name.newX509NameError(runtime, e.getClass().getName() + ":" + e.getLocalizedMessage());
            }
        }
        return this;
    }

    private void printASN(ASN1Encodable obj, StringBuilder b) {
        this.printASN(obj, 0, b);
    }

    private void printASN(ASN1Encodable obj, int indent, StringBuilder b) {
        if (obj instanceof ASN1Sequence) {
            for (int i = 0; i < indent; ++i) {
                b.append(" ");
            }
            b.append("- Sequence:");
            Enumeration enm = ((ASN1Sequence)obj).getObjects();
            while (enm.hasMoreElements()) {
                this.printASN((ASN1Encodable)enm.nextElement(), indent + 1, b);
            }
        } else if (obj instanceof ASN1Set) {
            for (int i = 0; i < indent; ++i) {
                b.append(" ");
            }
            b.append("- Set:");
            Enumeration enm = ((ASN1Set)obj).getObjects();
            while (enm.hasMoreElements()) {
                this.printASN((ASN1Encodable)enm.nextElement(), indent + 1, b);
            }
        } else {
            for (int i = 0; i < indent; ++i) {
                b.append(" ");
            }
            if (obj instanceof ASN1String) {
                b.append("- ").append(obj).append("=").append(((ASN1String)obj).getString()).append("[").append(obj.getClass()).append("]");
            } else {
                b.append("- ").append(obj).append("[").append(obj.getClass()).append("]");
            }
        }
    }

    private ASN1ObjectIdentifier getObjectIdentifier(String nameOrOid) {
        ASN1ObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
        if (null != val1) {
            return val1;
        }
        ASN1ObjectIdentifier val2 = new ASN1ObjectIdentifier(nameOrOid);
        return val2;
    }

    @JRubyMethod
    public IRubyObject add_entry(ThreadContext context, IRubyObject oid, IRubyObject value) {
        return this.add_entry(context, oid, value, context.nil);
    }

    @JRubyMethod
    public IRubyObject add_entry(ThreadContext context, IRubyObject _oid, IRubyObject _value, IRubyObject _type) {
        ASN1ObjectIdentifier oid_v;
        Ruby runtime = context.runtime;
        String oid = _oid.convertToString().toString();
        String value = _value.convertToString().toString();
        IRubyObject type = !_type.isNil() ? _type : runtime.getClassFromPath("OpenSSL::X509::Name").getConstant("OBJECT_TYPE_TEMPLATE").callMethod(context, "[]", _oid);
        try {
            oid_v = this.getObjectIdentifier(oid);
        }
        catch (IllegalArgumentException e) {
            throw X509Name.newX509NameError(this.getRuntime(), "invalid field name: " + e.getMessage());
        }
        if (null == oid_v) {
            throw X509Name.newX509NameError(this.getRuntime(), null);
        }
        this.oids.add(oid_v);
        this.values.add(value);
        this.types.add(type);
        return this;
    }

    @JRubyMethod(name={"to_s"}, rest=true)
    public IRubyObject _to_s(IRubyObject[] args) {
        int flag = -1;
        if (args.length > 0 && !args[0].isNil()) {
            flag = RubyNumeric.fix2int((IRubyObject)args[0]);
        }
        StringBuilder sb = new StringBuilder();
        Map<ASN1ObjectIdentifier, String> lookup = ASN1.getSymLookup(this.getRuntime());
        Iterator<Object> oiter = null;
        Iterator<Object> viter = null;
        if (flag == 17892119) {
            ArrayList<Object> ao = new ArrayList<Object>(this.oids);
            ArrayList<Object> av = new ArrayList<Object>(this.values);
            Collections.reverse(ao);
            Collections.reverse(av);
            oiter = ao.iterator();
            viter = av.iterator();
        } else {
            oiter = this.oids.iterator();
            viter = this.values.iterator();
        }
        String sep = "";
        while (oiter.hasNext()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)oiter.next();
            String val = (String)viter.next();
            String outOid = lookup.get(oid);
            if (null == outOid) {
                outOid = oid.toString();
            }
            if (flag == 17892119) {
                sb.append(sep).append(outOid).append("=").append(val);
                sep = ",";
                continue;
            }
            sb.append("/").append(outOid).append("=").append(val);
        }
        return this.getRuntime().newString(sb.toString());
    }

    @JRubyMethod
    public RubyArray to_a() {
        ArrayList<RubyArray> entries = new ArrayList<RubyArray>();
        Map<ASN1ObjectIdentifier, String> lookup = ASN1.getSymLookup(this.getRuntime());
        Iterator<Object> oiter = this.oids.iterator();
        Iterator<Object> viter = this.values.iterator();
        Iterator<Object> titer = this.types.iterator();
        while (oiter.hasNext()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)oiter.next();
            String val = (String)viter.next();
            String outOid = lookup.get(oid);
            if (null == outOid) {
                outOid = "UNDEF";
            }
            IRubyObject type = (IRubyObject)titer.next();
            entries.add(this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.getRuntime().newString(outOid), this.getRuntime().newString(val), type}));
        }
        return this.getRuntime().newArray(entries);
    }

    @JRubyMethod(name={"cmp", "<=>"})
    public IRubyObject cmp(IRubyObject other) {
        if (this.eql_p(other).isTrue()) {
            return RubyFixnum.zero((Ruby)this.getRuntime());
        }
        return RubyFixnum.one((Ruby)this.getRuntime());
    }

    org.bouncycastle.asn1.x509.X509Name getRealName() {
        return new org.bouncycastle.asn1.x509.X509Name(new Vector<Object>(this.oids), new Vector<Object>(this.values));
    }

    X500Name getX500Name() {
        return X500Name.getInstance((Object)this.getRealName().toASN1Primitive());
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(IRubyObject other) {
        if (!(other instanceof X509Name)) {
            return this.getRuntime().getFalse();
        }
        X509Name o = (X509Name)other;
        org.bouncycastle.asn1.x509.X509Name nm = new org.bouncycastle.asn1.x509.X509Name(new Vector<Object>(this.oids), new Vector<Object>(this.values));
        org.bouncycastle.asn1.x509.X509Name o_nm = new org.bouncycastle.asn1.x509.X509Name(new Vector<Object>(o.oids), new Vector<Object>(o.values));
        return nm.equals((Object)o_nm) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyFixnum hash() {
        Name name = new Name(this.getX500Name());
        return this.getRuntime().newFixnum(name.hash());
    }

    @JRubyMethod
    public IRubyObject to_der() {
        DLSequence seq = null;
        if (this.oids.size() > 0) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            ASN1EncodableVector sVec = new ASN1EncodableVector();
            ASN1ObjectIdentifier lstOid = null;
            for (int i = 0; i != this.oids.size(); ++i) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)this.oids.get(i);
                v.add((ASN1Encodable)oid);
                String str = (String)this.values.get(i);
                v.add((ASN1Encodable)this.convert(oid, str, RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)this.types.get(i)))));
                if (lstOid == null) {
                    sVec.add((ASN1Encodable)new DLSequence(v));
                } else {
                    vec.add((ASN1Encodable)new DLSet(sVec));
                    sVec = new ASN1EncodableVector();
                    sVec.add((ASN1Encodable)new DLSequence(v));
                }
                lstOid = oid;
            }
            vec.add((ASN1Encodable)new DLSet(sVec));
            seq = new DLSequence(vec);
        } else {
            seq = new DLSequence();
        }
        try {
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])seq.getEncoded("DER"));
        }
        catch (IOException ex) {
            throw X509Name.newX509NameError(this.getRuntime(), ex.getMessage());
        }
    }

    private ASN1Primitive convert(ASN1ObjectIdentifier oid, String value, int type) {
        try {
            Constructor<? extends ASN1Encodable> ctor;
            Class<? extends ASN1Encodable> clzz = ASN1.classForId(type);
            if (clzz != null && null != (ctor = clzz.getConstructor(String.class))) {
                return (ASN1Primitive)ctor.newInstance(value);
            }
            return new X509DefaultEntryConverter().getConvertedValue(oid, value);
        }
        catch (Exception e) {
            throw X509Name.newX509NameError(this.getRuntime(), e.getMessage());
        }
    }

    private static RaiseException newX509NameError(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::X509::NameError", message);
    }
}

