/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyDSA
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 2359742219218350277L;
    private static ObjectAllocator PKEYDSA_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKeyDSA(runtime, klass);
        }
    };
    private DSAPrivateKey privKey;
    private DSAPublicKey pubKey;
    private BigInteger[] specValues;
    private static final int SPEC_Y = 0;
    private static final int SPEC_P = 1;
    private static final int SPEC_Q = 2;
    private static final int SPEC_G = 3;

    public static void createPKeyDSA(Ruby runtime, RubyModule mPKey) {
        RubyClass cDSA = mPKey.defineClassUnder("DSA", mPKey.getClass("PKey"), PKEYDSA_ALLOCATOR);
        RubyClass pkeyError = mPKey.getClass("PKeyError");
        mPKey.defineClassUnder("DSAError", pkeyError, pkeyError.getAllocator());
        cDSA.defineAnnotatedMethods(PKeyDSA.class);
    }

    public static RaiseException newDSAError(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::PKey::DSAError", message);
    }

    public PKeyDSA(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public PKeyDSA(Ruby runtime, RubyClass type, DSAPrivateKey privKey, DSAPublicKey pubKey) {
        super(runtime, type);
        this.privKey = privKey;
        this.pubKey = pubKey;
    }

    public PKeyDSA(Ruby runtime, RubyClass type, DSAPublicKey pubKey) {
        this(runtime, type, null, pubKey);
    }

    @Override
    PublicKey getPublicKey() {
        return this.pubKey;
    }

    @Override
    PrivateKey getPrivateKey() {
        return this.privKey;
    }

    @Override
    String getAlgorithm() {
        return "DSA";
    }

    @JRubyMethod(name={"generate"}, meta=true)
    public static IRubyObject generate(IRubyObject recv, IRubyObject arg) {
        int keysize = RubyNumeric.fix2int((IRubyObject)arg);
        PKeyDSA dsa = new PKeyDSA(recv.getRuntime(), (RubyClass)recv);
        PKeyDSA.dsaGenerate(dsa, keysize);
        return dsa;
    }

    private static void dsaGenerate(PKeyDSA dsa, int keysize) throws RaiseException {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
            gen.initialize(keysize, new SecureRandom());
            KeyPair pair = gen.generateKeyPair();
            dsa.privKey = (DSAPrivateKey)pair.getPrivate();
            dsa.pubKey = (DSAPublicKey)pair.getPublic();
        }
        catch (Exception e) {
            throw PKeyDSA.newDSAError(dsa.getRuntime(), e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(rest=true)
    public IRubyObject initialize(IRubyObject[] args) {
        IRubyObject pass = null;
        char[] passwd = null;
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)2) == 0) {
            this.privKey = null;
            this.pubKey = null;
            return this;
        }
        IRubyObject arg = args[0];
        if (args.length > 1) {
            pass = args[1];
        }
        if (arg instanceof RubyFixnum) {
            int keysize = RubyNumeric.fix2int((IRubyObject)arg);
            PKeyDSA.dsaGenerate(this, keysize);
            return this;
        }
        if (pass != null && !pass.isNil()) {
            passwd = pass.toString().toCharArray();
        }
        arg = OpenSSLImpl.to_der_if_possible(arg);
        RubyString str = arg.convertToString();
        Serializable val = null;
        KeyFactory fact = null;
        try {
            fact = KeyFactory.getInstance("DSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw this.getRuntime().newLoadError("unsupported key algorithm (DSA)");
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readDSAPrivateKey(new StringReader(str.toString()), passwd);
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readDSAPublicKey(new StringReader(str.toString()), passwd);
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readDSAPubKey(new StringReader(str.toString()));
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PKey.readDSAPrivateKey(str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PKey.readDSAPublicKey(str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = fact.generatePrivate(new PKCS8EncodedKeySpec(str.getBytes()));
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = fact.generatePublic(new X509EncodedKeySpec(str.getBytes()));
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            throw PKeyDSA.newDSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
        }
        if (val instanceof KeyPair) {
            PrivateKey privateKey = ((KeyPair)val).getPrivate();
            PublicKey publicKey = ((KeyPair)val).getPublic();
            if (!(privateKey instanceof DSAPrivateKey)) throw PKeyDSA.newDSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
            this.privKey = (DSAPrivateKey)privateKey;
            this.pubKey = (DSAPublicKey)publicKey;
            return this;
        } else if (val instanceof DSAPrivateKey) {
            this.privKey = (DSAPrivateKey)val;
            return this;
        } else {
            if (!(val instanceof DSAPublicKey)) throw PKeyDSA.newDSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
            this.pubKey = (DSAPublicKey)val;
            this.privKey = null;
        }
        return this;
    }

    @JRubyMethod(name={"public?"})
    public IRubyObject public_p() {
        return this.pubKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"private?"})
    public IRubyObject private_p() {
        return this.privKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod
    public IRubyObject to_der() {
        try {
            byte[] bytes = PKey.toDerDSAKey(this.pubKey, this.privKey);
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])bytes);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject to_text() {
        StringBuilder result = new StringBuilder();
        if (this.privKey != null) {
            int len = this.privKey.getParams().getP().bitLength();
            result.append("Private-Key: (").append(len).append(" bit)").append("\n");
            result.append("priv:");
            PKeyDSA.addSplittedAndFormatted(result, this.privKey.getX());
        }
        result.append("pub:");
        PKeyDSA.addSplittedAndFormatted(result, this.pubKey.getY());
        result.append("P:");
        PKeyDSA.addSplittedAndFormatted(result, this.pubKey.getParams().getP());
        result.append("Q:");
        PKeyDSA.addSplittedAndFormatted(result, this.pubKey.getParams().getQ());
        result.append("G:");
        PKeyDSA.addSplittedAndFormatted(result, this.pubKey.getParams().getG());
        return this.getRuntime().newString(result.toString());
    }

    @JRubyMethod
    public IRubyObject public_key() {
        PKeyDSA val = new PKeyDSA(this.getRuntime(), this.getMetaClass().getRealClass());
        val.privKey = null;
        val.pubKey = this.pubKey;
        return val;
    }

    @JRubyMethod(name={"export", "to_pem", "to_s"}, rest=true)
    public IRubyObject export(IRubyObject[] args) {
        StringWriter w = new StringWriter();
        Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)2);
        CipherSpec ciph = null;
        char[] passwd = null;
        if (args.length > 0 && !args[0].isNil()) {
            Cipher c = (Cipher)args[0];
            ciph = new CipherSpec(c.getCipher(), c.getName(), c.getKeyLen() * 8);
            if (args.length > 1 && !args[1].isNil()) {
                passwd = args[1].toString().toCharArray();
            }
        }
        try {
            if (this.privKey != null) {
                PEMInputOutput.writeDSAPrivateKey(w, this.privKey, ciph, passwd);
            } else {
                PEMInputOutput.writeDSAPublicKey(w, this.pubKey);
            }
            w.close();
            return this.getRuntime().newString(w.toString());
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject syssign(IRubyObject arg) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject sysverify(IRubyObject arg, IRubyObject arg2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p"})
    public synchronized IRubyObject get_p() {
        BigInteger param;
        DSAKey key = this.pubKey;
        if (key != null || (key = this.privKey) != null) {
            BigInteger param2 = key.getParams().getP();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[1]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(IRubyObject p) {
        return this.setKeySpecComponent(1, p);
    }

    @JRubyMethod(name={"q"})
    public synchronized IRubyObject get_q() {
        BigInteger param;
        DSAKey key = this.pubKey;
        if (key != null || (key = this.privKey) != null) {
            BigInteger param2 = key.getParams().getQ();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[2]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"q="})
    public synchronized IRubyObject set_q(IRubyObject q) {
        return this.setKeySpecComponent(2, q);
    }

    @JRubyMethod(name={"g"})
    public synchronized IRubyObject get_g() {
        BigInteger param;
        DSAKey key = this.pubKey;
        if (key != null || (key = this.privKey) != null) {
            BigInteger param2 = key.getParams().getG();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[3]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"g="})
    public synchronized IRubyObject set_g(IRubyObject g) {
        return this.setKeySpecComponent(3, g);
    }

    @JRubyMethod(name={"pub_key"})
    public synchronized IRubyObject get_pub_key() {
        BigInteger param;
        DSAPublicKey key = this.pubKey;
        if (key != null) {
            return BN.newBN(this.getRuntime(), key.getY());
        }
        if (this.specValues != null && (param = this.specValues[0]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"priv_key"})
    public synchronized IRubyObject get_priv_key() {
        DSAPrivateKey key = this.privKey;
        if (key != null) {
            return BN.newBN(this.getRuntime(), key.getX());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pub_key="})
    public synchronized IRubyObject set_pub_key(IRubyObject pub_key) {
        return this.setKeySpecComponent(0, pub_key);
    }

    private IRubyObject setKeySpecComponent(int index, IRubyObject value) {
        BigInteger[] vals;
        block10: {
            block9: {
                if (this.pubKey != null || this.privKey != null) break block9;
                vals = this.specValues;
                if (this.specValues == null || vals[index] == null) break block10;
            }
            throw PKeyDSA.newDSAError(this.getRuntime(), "illegal modification");
        }
        BigInteger bival = BN.getBigInteger(value);
        if (vals != null) {
            vals[index] = bival;
            int i = vals.length;
            while (--i >= 0) {
                if (vals[i] != null) continue;
                return value;
            }
            DSAPublicKeySpec spec = new DSAPublicKeySpec(vals[0], vals[1], vals[2], vals[3]);
            try {
                this.pubKey = (DSAPublicKey)KeyFactory.getInstance("DSA").generatePublic(spec);
            }
            catch (InvalidKeySpecException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "invalid keyspec");
            }
            catch (NoSuchAlgorithmException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "unsupported key algorithm (DSA)");
            }
            this.specValues = null;
        } else {
            this.specValues = new BigInteger[4];
            this.specValues[index] = bival;
        }
        return value;
    }
}

