/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor;

import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.ClassNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.visitor.AbstractNodeVisitor;

public class InstanceVariableFinder
extends AbstractNodeVisitor {
    private final Set<String> foundVariables = new HashSet<String>();

    public static Set<String> findVariables(Node node) {
        InstanceVariableFinder ivf = new InstanceVariableFinder();
        node.accept(ivf);
        return ivf.getFoundVariables();
    }

    @Override
    public Set<String> getFoundVariables() {
        return this.foundVariables;
    }

    @Override
    public Object visitClassNode(ClassNode iVisited) {
        return null;
    }

    @Override
    public Object visitInstAsgnNode(InstAsgnNode iVisited) {
        this.foundVariables.add(iVisited.getName());
        for (Node node : iVisited.childNodes()) {
            node.accept(this);
        }
        return null;
    }

    @Override
    public Object visitInstVarNode(InstVarNode iVisited) {
        this.foundVariables.add(iVisited.getName());
        for (Node node : iVisited.childNodes()) {
            node.accept(this);
        }
        return null;
    }

    @Override
    public Object visitModuleNode(ModuleNode iVisited) {
        return null;
    }

    @Override
    public Object visitPreExeNode(PreExeNode iVisited) {
        return null;
    }

    @Override
    public Object visitPostExeNode(PostExeNode iVisited) {
        return null;
    }
}

