/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.codec;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.Errors;
import org.jruby.ext.krypt.Hex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyHex {
    private RubyHex() {
    }

    @JRubyMethod(meta=true)
    public static IRubyObject encode(ThreadContext ctx, IRubyObject recv, IRubyObject data) {
        try {
            byte[] bytes = data.convertToString().getBytes();
            byte[] encoded = Hex.encode(bytes);
            return RubyString.newUsAsciiStringNoCopy((Ruby)ctx.getRuntime(), (ByteList)new ByteList(encoded, false));
        }
        catch (RuntimeException ex) {
            throw Errors.newHexError(ctx.getRuntime(), ex.getMessage());
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject decode(ThreadContext ctx, IRubyObject recv, IRubyObject data) {
        try {
            byte[] bytes = data.convertToString().getBytes();
            byte[] decoded = Hex.decode(bytes);
            return ctx.getRuntime().newString(new ByteList(decoded, false));
        }
        catch (RuntimeException ex) {
            throw Errors.newHexError(ctx.getRuntime(), ex.getMessage());
        }
    }

    public static void createHex(Ruby runtime, RubyModule krypt, RubyClass kryptError) {
        RubyModule mHex = runtime.defineModuleUnder("Hex", krypt);
        mHex.defineClassUnder("HexError", kryptError, kryptError.getAllocator());
        mHex.defineAnnotatedMethods(RubyHex.class);
    }
}

