/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class HashAdapter
implements Map {
    private final RubyHash inner;

    public HashAdapter(RubyHash inner) {
        if (inner == null) {
            throw new NullPointerException("inner");
        }
        this.inner = inner;
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inner.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inner.containsValue(value);
    }

    public Set entrySet() {
        return this.inner.entrySet();
    }

    public Object get(Object key) {
        return this.inner.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public Set keySet() {
        return this.inner.keySet();
    }

    public Object put(Object key, Object value) {
        return this.inner.put(key, value);
    }

    public void putAll(Map m) {
        this.inner.putAll(m);
    }

    public Object remove(Object key) {
        return this.inner.remove(key);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    public Collection values() {
        return this.inner.values();
    }

    public Integer getIntegerFixnum(Object key) {
        Long l = (Long)this.inner.get(key);
        if (l == null) {
            return null;
        }
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Value too large: " + l);
        }
        return l.intValue();
    }

    public Long getLongFixnum(Object key) {
        return (Long)this.inner.get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)this.inner.get(key);
    }

    public String getString(Object key) {
        return (String)this.inner.get(key);
    }

    public String getSymbol(Object key) {
        IRubyObject iro = (IRubyObject)this.inner.get(key);
        if (iro == null) {
            return null;
        }
        return iro.asJavaString();
    }

    public RubyArray getArray(Object key) {
        return (RubyArray)this.inner.get(key);
    }

    public HashAdapter getHash(Object key) {
        RubyHash h = (RubyHash)this.inner.get(key);
        if (h == null) {
            return null;
        }
        return new HashAdapter(h);
    }

    public IRubyObject getObject(ThreadContext ctx, IRubyObject key) {
        return this.inner.op_aref(ctx, key);
    }
}

