/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1.parser;

import impl.krypt.asn1.Length;
import impl.krypt.asn1.ParseException;
import impl.krypt.asn1.ParsedHeader;
import impl.krypt.asn1.Parser;
import impl.krypt.asn1.Tag;
import impl.krypt.asn1.TagClass;
import impl.krypt.asn1.parser.ParsedHeaderImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PullHeaderParser
implements Parser {
    private static final int MAX_TAG = 0xFFFFFF;
    private static final int MAX_LENGTH = 0x7FFFFF;

    @Override
    public ParsedHeader next(InputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        int read = this.nextInt(in);
        if (read == -1) {
            return null;
        }
        byte b = (byte)read;
        Tag tag = this.parseTag(b, in);
        Length length = this.parseLength(in);
        if (length.isInfiniteLength() && !tag.isConstructed()) {
            throw new ParseException("Infinite length values must be constructed");
        }
        return new ParsedHeaderImpl(tag, length, in, this);
    }

    private byte nextByte(InputStream in) {
        int read = this.nextInt(in);
        if (read == -1) {
            throw new ParseException("EOF reached.");
        }
        return (byte)read;
    }

    private int nextInt(InputStream in) {
        try {
            return in.read();
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
    }

    private static boolean matchMask(byte test, byte mask) {
        return (byte)(test & mask) == mask;
    }

    private Tag parseTag(byte b, InputStream in) {
        if (PullHeaderParser.matchMask(b, (byte)31)) {
            return this.parseComplexTag(b, in);
        }
        return this.parsePrimitiveTag(b);
    }

    private Tag parsePrimitiveTag(byte b) {
        int tag = b & 0x1F;
        boolean isConstructed = PullHeaderParser.matchMask(b, (byte)32);
        TagClass tc = TagClass.of((byte)(b & TagClass.PRIVATE.getMask()));
        return new Tag(tag, tc, isConstructed, new byte[]{b});
    }

    private Tag parseComplexTag(byte b, InputStream in) {
        boolean isConstructed = PullHeaderParser.matchMask(b, (byte)32);
        TagClass tc = TagClass.of((byte)(b & TagClass.PRIVATE.getMask()));
        int tag = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(b & 0xFF);
        b = this.nextByte(in);
        if (b == -128) {
            throw new ParseException("Bits 7 to 1 of the first subsequent octet shall not be 0 for complex tag encodings");
        }
        while (PullHeaderParser.matchMask(b, (byte)-128)) {
            if (tag > 0xFFFFFF) {
                throw new ParseException("Complex tag too long.");
            }
            tag <<= 7;
            tag |= b & 0x7F;
            baos.write(b & 0xFF);
            b = this.nextByte(in);
        }
        tag <<= 7;
        baos.write(b & 0xFF);
        return new Tag(tag |= b & 0x7F, tc, isConstructed, baos.toByteArray());
    }

    private Length parseLength(InputStream in) {
        byte b = this.nextByte(in);
        if (b == -128) {
            return new Length(0, true, new byte[]{b});
        }
        if (PullHeaderParser.matchMask(b, (byte)-128)) {
            return this.parseComplexDefiniteLength(b, in);
        }
        return new Length(b & 0xFF, false, new byte[]{b});
    }

    private Length parseComplexDefiniteLength(byte b, InputStream in) {
        int len = 0;
        int numOctets = b & 0x7F;
        int off = 0;
        if ((b & 0xFF) == 255) {
            throw new ParseException("Initial octet of complex definite length shall not be 0xFF");
        }
        byte[] encoding = new byte[numOctets + 1];
        encoding[off++] = b;
        for (int i = numOctets; i > 0; --i) {
            if (numOctets > 0x7FFFFF) {
                throw new ParseException("Definite value length too long.");
            }
            b = this.nextByte(in);
            len <<= 8;
            len |= b & 0xFF;
            encoding[off++] = b;
        }
        return new Length(len, false, encoding);
    }
}

