/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import java.util.HashMap;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ext.ripper.HeredocTerm;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.ext.ripper.RipperParser;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.StringTerm;
import org.jruby.ext.ripper.Token;
import org.jruby.lexer.yacc.StackState;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafeDoubleParser;
import org.jruby.util.StringSupport;

public class RipperLexer {
    public static final Encoding UTF8_ENCODING = UTF8Encoding.INSTANCE;
    public static final Encoding USASCII_ENCODING = USASCIIEncoding.INSTANCE;
    public static final Encoding ASCII8BIT_ENCODING = ASCIIEncoding.INSTANCE;
    private static ByteList END_MARKER = new ByteList(new byte[]{95, 95, 69, 78, 68, 95, 95});
    private static ByteList BEGIN_DOC_MARKER = new ByteList(new byte[]{98, 101, 103, 105, 110});
    private static ByteList END_DOC_MARKER = new ByteList(new byte[]{101, 110, 100});
    private static ByteList CODING = new ByteList(new byte[]{99, 111, 100, 105, 110, 103});
    private static final HashMap<String, Keyword> map = new HashMap();
    private Encoding current_enc;
    public boolean ignoreNextScanEvent = false;
    private int token;
    Object yaccValue;
    String identValue;
    private LexerSource src;
    private RipperParser parser = null;
    private LexState lex_state;
    private StringBuilder tokenBuffer = new StringBuilder(60);
    private StackState conditionState = new StackState();
    private StackState cmdArgumentState = new StackState();
    private StrTerm lex_strterm;
    public boolean commandStart;
    static final int EOF = -1;
    static final int STR_FUNC_ESCAPE = 1;
    static final int STR_FUNC_EXPAND = 2;
    static final int STR_FUNC_REGEXP = 4;
    static final int STR_FUNC_QWORDS = 8;
    static final int STR_FUNC_SYMBOL = 16;
    static final int STR_FUNC_INDENT = 32;
    private static final int str_squote = 0;
    private static final int str_dquote = 2;
    private static final int str_xquote = 2;
    private static final int str_regexp = 7;
    private static final int str_ssym = 16;
    private static final int str_dsym = 18;
    private int parenNest = 0;
    private int leftParenBegin = 0;
    protected int tokp = 0;
    protected ByteList lexb = null;
    protected int lex_p = 0;
    protected int lex_pbeg = 0;
    protected int lex_pend = 0;
    protected ByteList lex_lastline = null;
    private ByteList lex_nextline = null;
    private boolean __end__seen = false;
    protected boolean eofp = false;
    private boolean has_shebang = false;
    protected ByteList delayed = null;
    private int delayed_line = 0;
    private int delayed_col = 0;
    private int ruby_sourceline = 0;
    private int heredoc_end = 0;
    private int line_count = 0;
    private static final String magicString = "([^\\s'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*";
    private static final Regex magicRegexp;
    private byte[] mbcBuf = new byte[6];

    public Encoding getEncoding() {
        return this.current_enc;
    }

    private int getFloatToken(String number) {
        try {
            double d = SafeDoubleParser.parseDouble((String)number);
        }
        catch (NumberFormatException e) {
            this.warn("Float " + number + " out of range.");
            double d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        ByteList buf = new ByteList(number.getBytes());
        this.yaccValue = new Token(buf);
        return 379;
    }

    public boolean isVerbose() {
        return this.parser.getRuntime().isVerbose();
    }

    public void warn(String message) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void warning(String message) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static Keyword getKeyword(String str) {
        return map.get(str);
    }

    public int incrementParenNest() {
        ++this.parenNest;
        return this.parenNest;
    }

    public int getLeftParenBegin() {
        return this.leftParenBegin;
    }

    public void setLeftParenBegin(int value) {
        this.leftParenBegin = value;
    }

    public RipperLexer(RipperParser parser, LexerSource src) {
        this.parser = parser;
        this.token = 0;
        this.yaccValue = null;
        this.src = src;
        this.setState(null);
        this.resetStacks();
        this.lex_strterm = null;
        this.commandStart = true;
        this.current_enc = src.getEncoding();
    }

    public boolean hasStarted() {
        return this.src != null;
    }

    public boolean isEndSeen() {
        return this.__end__seen;
    }

    protected void flush_string_content(Encoding encoding) {
        if (this.delayed != null) {
            int len = this.lex_p - this.tokp;
            if (len > 0) {
                this.delayed.setEncoding(encoding);
                this.delayed.append(this.lexb.makeShared(this.tokp, len));
            }
            this.dispatchDelayedToken(377);
            this.tokp = this.lex_p;
        }
    }

    public int p(int offset) {
        return this.lexb.get(offset) & 0xFF;
    }

    public int nextc() {
        if (this.lex_p == this.lex_pend) {
            ByteList v = this.lex_nextline;
            this.lex_nextline = null;
            if (v == null) {
                if (this.eofp) {
                    return -1;
                }
                if (this.src == null || (v = this.src.gets()) == null) {
                    this.eofp = true;
                    this.lex_goto_eol();
                    return -1;
                }
            }
            if (this.tokp < this.lex_pend) {
                if (this.delayed == null) {
                    this.delayed = new ByteList();
                    this.delayed.setEncoding(this.current_enc);
                    this.delayed.append(this.lexb, this.tokp, this.lex_pend - this.tokp);
                    this.delayed_line = this.ruby_sourceline;
                    this.delayed_col = this.tokp - this.lex_pbeg;
                } else {
                    this.delayed.append(this.lexb, this.tokp, this.lex_pend - this.tokp);
                }
            }
            if (this.heredoc_end > 0) {
                this.ruby_sourceline = this.heredoc_end;
                this.heredoc_end = 0;
            }
            ++this.ruby_sourceline;
            ++this.line_count;
            this.lex_p = 0;
            this.lex_pbeg = 0;
            this.lex_pend = this.lex_p + v.length();
            this.lexb = v;
            this.flush();
            this.lex_lastline = v;
        }
        int c = this.p(this.lex_p);
        ++this.lex_p;
        if (c == 13 && this.peek(10)) {
            ++this.lex_p;
            c = 10;
        }
        return c;
    }

    public boolean peek(int c) {
        return this.peek(c, 0);
    }

    private boolean peek(int c, int n) {
        return this.lex_p + n < this.lex_pend && this.p(this.lex_p + n) == c;
    }

    protected void lex_goto_eol() {
        this.lex_p = this.lex_pend;
    }

    public int column() {
        return this.tokp - this.lex_pbeg;
    }

    public int lineno() {
        return this.ruby_sourceline + this.src.getLineOffset();
    }

    public void dispatchHeredocEnd() {
        if (this.delayed != null) {
            this.dispatchDelayedToken(377);
        }
        this.lex_goto_eol();
        this.dispatchIgnoredScanEvent(388);
    }

    public boolean was_bol() {
        return this.lex_p == this.lex_pbeg + 1;
    }

    private boolean strncmp(ByteList one, ByteList two, int length) {
        if (one.length() < length || two.length() < length) {
            return false;
        }
        return one.makeShared(0, length).equal(two.makeShared(0, length));
    }

    public void pushback(int c) {
        if (c == -1) {
            return;
        }
        --this.lex_p;
        if (this.lex_p > this.lex_pbeg && this.p(this.lex_p) == 10 && this.p(this.lex_p - 1) == 13) {
            --this.lex_p;
        }
    }

    private void flush() {
        this.tokp = this.lex_p;
    }

    public void compile_error(String message) {
        this.parser.dispatch("compile_error", (IRubyObject)this.getRuntime().newString(message));
    }

    public int readCodepoint(int first, Encoding encoding) throws IOException {
        int c;
        int count = 0;
        byte[] value = new byte[6];
        value[0] = (byte)first;
        for (count = 1; count < 6 && (c = this.nextc()) != -1; ++count) {
            value[count] = (byte)c;
        }
        int length = encoding.length(value, 0, count);
        if (length < 0) {
            return -2;
        }
        int codepoint = encoding.mbcToCode(value, 0, length);
        for (int i = count - 1; i >= length; --i) {
            this.pushback(value[i]);
        }
        return codepoint;
    }

    public void heredoc_restore(HeredocTerm here) {
        ByteList line;
        this.lex_lastline = line = here.lastLine;
        this.lex_pbeg = 0;
        this.lex_pend = this.lex_pbeg + line.length();
        this.lex_p = this.lex_pbeg + here.nth;
        this.lexb = line;
        this.heredoc_end = this.ruby_sourceline;
        this.ruby_sourceline = here.line;
        this.flush();
    }

    public void parser_prepare() {
        int c = this.nextc();
        switch (c) {
            case 35: {
                if (!this.peek(33)) break;
                this.has_shebang = true;
                break;
            }
            case 239: {
                if (this.lex_pend - this.lex_p < 2 || this.p(this.lex_p) != 187 || this.p(this.lex_p + 1) != 191) break;
                this.setEncoding(UTF8_ENCODING);
                this.lex_p += 2;
                this.lex_pbeg = this.lex_p;
                return;
            }
            case -1: {
                return;
            }
        }
        this.pushback(c);
        this.current_enc = this.lex_lastline.getEncoding();
    }

    public int nextToken() throws IOException {
        this.token = this.yylex();
        if (this.delayed != null) {
            this.dispatchDelayedToken(this.token);
            return this.token == -1 ? 0 : this.token;
        }
        if (this.token != -1) {
            this.dispatchScanEvent(this.token);
        }
        return this.token == -1 ? 0 : this.token;
    }

    public String getIdent() {
        return this.identValue;
    }

    public int token() {
        return this.token;
    }

    public StringBuilder getTokenBuffer() {
        return this.tokenBuffer;
    }

    public Object value() {
        return this.yaccValue;
    }

    public boolean whole_match_p(ByteList eos, boolean indent) {
        int n;
        int len = eos.length();
        int p = this.lex_pbeg;
        if (indent) {
            for (int i = 0; i < this.lex_pend; ++i) {
                if (Character.isWhitespace(this.p(i + p))) continue;
                p += i;
                break;
            }
        }
        if ((n = this.lex_pend - (p + len)) < 0 || n > 0 && this.p(p + len) != 10 && this.p(p + len) != 13) {
            return false;
        }
        return this.strncmp(eos, this.lexb.makeShared(p, len), len);
    }

    public Ruby getRuntime() {
        return this.parser.context.getRuntime();
    }

    public void setParser(RipperParser parserSupport) {
        this.parser = parserSupport;
    }

    private void setEncoding(ByteList name) {
        Encoding newEncoding = this.parser.getRuntime().getEncodingService().loadEncoding(name);
        if (newEncoding == null) {
            this.compile_error("unknown encoding name: " + name.toString());
            return;
        }
        if (!newEncoding.isAsciiCompatible()) {
            this.compile_error(name.toString() + " is not ASCII compatible");
            return;
        }
        this.setEncoding(newEncoding);
    }

    public void setEncoding(Encoding encoding) {
        this.current_enc = encoding;
        this.src.setEncoding(encoding);
        this.lexb.setEncoding(encoding);
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    private void printState() {
        if (this.lex_state == null) {
            System.out.println("NULL");
        } else {
            System.out.println((Object)this.lex_state);
        }
    }

    public void setState(LexState state) {
        this.lex_state = state;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public void setValue(Object yaccValue) {
        this.yaccValue = yaccValue;
    }

    private boolean isNext_identchar() throws IOException {
        int c = this.nextc();
        this.pushback(c);
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95);
    }

    private boolean isBEG() {
        return this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state == LexState.EXPR_CLASS || this.lex_state == LexState.EXPR_VALUE;
    }

    private boolean isEND() {
        return this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG || this.lex_state == LexState.EXPR_ENDFN;
    }

    private boolean isARG() {
        return this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG;
    }

    private boolean isSpaceArg(int c, boolean spaceSeen) {
        return this.isARG() && spaceSeen && !Character.isWhitespace(c);
    }

    private void determineExpressionState() {
        switch (this.lex_state) {
            case EXPR_FNAME: 
            case EXPR_DOT: {
                this.setState(LexState.EXPR_ARG);
                break;
            }
            default: {
                this.setState(LexState.EXPR_BEG);
            }
        }
    }

    private Object getInteger(String value, int radix) {
        return new Token(value);
    }

    static boolean isHexChar(int c) {
        return Character.isDigit(c) || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    static boolean isOctChar(int c) {
        return 48 <= c && c <= 55;
    }

    public boolean isIdentifierChar(int c) {
        return Character.isLetterOrDigit(c) || c == 95 || this.isMultiByteChar(c);
    }

    protected boolean isMultiByteChar(int c) {
        return this.current_enc.codeToMbcLength(c) != 1;
    }

    public IRubyObject createStr(ByteList buffer, int flags) {
        Encoding bufferEncoding = buffer.getEncoding();
        int codeRange = StringSupport.codeRangeScan((Encoding)bufferEncoding, (ByteList)buffer);
        if ((flags & 4) == 0 && bufferEncoding.isAsciiCompatible() && codeRange != 32 && this.getEncoding() == USASCII_ENCODING && bufferEncoding != UTF8_ENCODING) {
            codeRange = RipperParser.associateEncoding(buffer, ASCII8BIT_ENCODING, codeRange);
        }
        return this.getRuntime().newString(buffer);
    }

    private int parseQuote(int c) throws IOException {
        int end;
        boolean shortHand;
        int begin;
        String value = "%" + (char)c;
        if (!Character.isLetterOrDigit(c)) {
            begin = c;
            c = 81;
            shortHand = true;
        } else {
            shortHand = false;
            begin = this.nextc();
            value = value + (char)begin;
            if (Character.isLetterOrDigit(begin)) {
                this.compile_error("unknown type of %string");
            }
        }
        if (c == -1 || begin == -1) {
            this.compile_error("unterminated quoted string meets end of file");
            return -1;
        }
        switch (begin) {
            case 40: {
                end = 41;
                break;
            }
            case 91: {
                end = 93;
                break;
            }
            case 123: {
                end = 125;
                break;
            }
            case 60: {
                end = 62;
                break;
            }
            default: {
                end = begin;
                begin = 0;
            }
        }
        int w = this.nextc();
        while (Character.isWhitespace(w)) {
            value = value + (char)w;
            w = this.nextc();
        }
        this.pushback(w);
        this.yaccValue = new Token(value);
        switch (c) {
            case 81: {
                this.lex_strterm = new StringTerm(2, begin, end);
                return 365;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, begin, end);
                return 365;
            }
            case 87: {
                this.lex_strterm = new StringTerm(10, begin, end);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                return 368;
            }
            case 119: {
                this.lex_strterm = new StringTerm(8, begin, end);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                return 369;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, begin, end);
                return 366;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, begin, end);
                return 367;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, begin, end);
                this.setState(LexState.EXPR_FNAME);
                return 364;
            }
        }
        this.compile_error("Unknown type of %string. Expected 'Q', 'q', 'w', 'x', 'r' or any non letter character, but found '" + c + "'.");
        return -1;
    }

    private int hereDocumentIdentifier() throws IOException {
        int term;
        ByteList markerValue;
        int c = this.nextc();
        int func = 0;
        if (c == 45) {
            c = this.nextc();
            func = 32;
        }
        if (c == 39 || c == 34 || c == 96) {
            func = c == 39 ? (func |= 0) : (c == 34 ? (func |= 2) : (func |= 2));
            markerValue = new ByteList();
            term = c;
            while ((c = this.nextc()) != -1 && c != term) {
                markerValue.append(c);
            }
            if (c == -1) {
                this.compile_error("unterminated here document identifier");
            }
        } else {
            if (!this.isIdentifierChar(c)) {
                this.pushback(c);
                if ((func & 0x20) != 0) {
                    this.pushback(45);
                }
                return 0;
            }
            markerValue = new ByteList();
            term = 34;
            func |= 2;
            do {
                markerValue.append(c);
            } while ((c = this.nextc()) != -1 && this.isIdentifierChar(c));
            this.pushback(c);
        }
        this.dispatchScanEvent(387);
        int len = this.lex_p - this.lex_pbeg;
        this.lex_goto_eol();
        this.lex_strterm = new HeredocTerm(markerValue, func, len, this.ruby_sourceline, this.lex_lastline);
        this.flush();
        return term == 96 ? 366 : 365;
    }

    private void arg_ambiguous() {
        this.parser.dispatch("on_arg_ambiguous");
    }

    private int magicCommentMarker(ByteList str, int begin) {
        int i = begin;
        int len = str.length();
        block4: while (i < len) {
            switch (str.charAt(i)) {
                case '-': {
                    if (i >= 2 && str.charAt(i - 1) == '*' && str.charAt(i - 2) == '-') {
                        return i + 1;
                    }
                    i += 2;
                    continue block4;
                }
                case '*': {
                    if (i + 1 >= len) {
                        return -1;
                    }
                    if (str.charAt(i + 1) != '-') {
                        i += 4;
                        continue block4;
                    }
                    if (str.charAt(i - 1) != '-') {
                        i += 2;
                        continue block4;
                    }
                    return i + 2;
                }
            }
            i += 3;
        }
        return -1;
    }

    private boolean comment_at_top() {
        int pend = this.lex_p - 1;
        if (this.line_count != (this.has_shebang ? 2 : 1)) {
            return false;
        }
        for (int p = this.lex_pbeg; p < pend; ++p) {
            if (Character.isSpaceChar(this.p(p))) continue;
            return false;
        }
        return true;
    }

    protected boolean parseMagicComment(ByteList magicLine) throws IOException {
        int length = magicLine.length();
        if (length <= 7) {
            return false;
        }
        int beg = this.magicCommentMarker(magicLine, 0);
        if (beg < 0) {
            return false;
        }
        int end = this.magicCommentMarker(magicLine, beg);
        if (end < 0) {
            return false;
        }
        int realSize = magicLine.getRealSize();
        int begin = magicLine.getBegin();
        Matcher matcher = magicRegexp.matcher(magicLine.getUnsafeBytes(), begin, begin + realSize);
        int result = RubyRegexp.matcherSearch((Ruby)this.getRuntime(), (Matcher)matcher, (int)begin, (int)(begin + realSize), (int)0);
        if (result < 0) {
            return false;
        }
        int[] begs = matcher.getRegion().beg;
        int[] ends = matcher.getRegion().end;
        String name = magicLine.subSequence(begs[1], ends[1]).toString();
        if (!name.equalsIgnoreCase("encoding")) {
            return false;
        }
        ByteList val = new ByteList(magicLine.getUnsafeBytes(), begs[2], ends[2] - begs[2]);
        this.parser.dispatch("on_magic_comment", (IRubyObject)this.parser.getRuntime().newString(name), this.createStr(val, 0));
        return true;
    }

    protected void set_file_encoding(int str, int send) {
        boolean sep = false;
        block9: while (true) {
            if (send - str <= 6) {
                return;
            }
            switch (this.p(str + 6)) {
                case 67: 
                case 99: {
                    str += 6;
                    continue block9;
                }
                case 79: 
                case 111: {
                    str += 5;
                    continue block9;
                }
                case 68: 
                case 100: {
                    str += 4;
                    continue block9;
                }
                case 73: 
                case 105: {
                    str += 3;
                    continue block9;
                }
                case 78: 
                case 110: {
                    str += 2;
                    continue block9;
                }
                case 71: 
                case 103: {
                    ++str;
                    continue block9;
                }
                case 58: 
                case 61: {
                    sep = true;
                    str += 6;
                    break;
                }
                default: {
                    if (!Character.isSpaceChar(this.p(str += 6))) continue block9;
                }
            }
            if (this.lexb.makeShared(str - 6, 6).caseInsensitiveCmp(CODING) == 0) break;
        }
        while (true) {
            if (++str >= send) {
                return;
            }
            if (Character.isSpaceChar(this.p(str))) continue;
            if (sep) break;
            if (this.p(str) != 61 && this.p(str) != 58) {
                return;
            }
            sep = true;
            ++str;
        }
        int beg = str;
        while ((this.p(str) == 45 || this.p(str) == 95 || Character.isLetterOrDigit(this.p(str))) && ++str < send) {
        }
        this.setEncoding(this.lexb.makeShared(beg, str - beg));
        this.src.setEncoding(this.getEncoding());
        this.lexb.setEncoding(this.getEncoding());
    }

    private String printToken(int token) {
        switch (token) {
            case 256: {
                return "yyErrorCode,";
            }
            case 257: {
                return "kClass,";
            }
            case 258: {
                return "kModule,";
            }
            case 259: {
                return "kDEF,";
            }
            case 260: {
                return "kUNDEF,";
            }
            case 261: {
                return "kBEGIN,";
            }
            case 262: {
                return "kRESCUE,";
            }
            case 263: {
                return "kENSURE,";
            }
            case 264: {
                return "kEND,";
            }
            case 265: {
                return "kIF,";
            }
            case 266: {
                return "kUNLESS,";
            }
            case 267: {
                return "kTHEN,";
            }
            case 268: {
                return "kELSIF,";
            }
            case 269: {
                return "kELSE,";
            }
            case 270: {
                return "kCASE,";
            }
            case 271: {
                return "kWHEN,";
            }
            case 272: {
                return "kWHILE,";
            }
            case 273: {
                return "kUNTIL,";
            }
            case 274: {
                return "kFOR,";
            }
            case 275: {
                return "kBREAK,";
            }
            case 276: {
                return "kNEXT,";
            }
            case 277: {
                return "kREDO,";
            }
            case 278: {
                return "kRETRY,";
            }
            case 279: {
                return "kIN,";
            }
            case 280: {
                return "kDO,";
            }
            case 281: {
                return "kDO_COND,";
            }
            case 282: {
                return "kDO_BLOCK,";
            }
            case 283: {
                return "kRETURN,";
            }
            case 284: {
                return "kYIELD,";
            }
            case 285: {
                return "kSUPER,";
            }
            case 286: {
                return "kSELF,";
            }
            case 287: {
                return "kNIL,";
            }
            case 288: {
                return "kTRUE,";
            }
            case 289: {
                return "kFALSE,";
            }
            case 290: {
                return "kAND,";
            }
            case 291: {
                return "kOR,";
            }
            case 292: {
                return "kNOT,";
            }
            case 293: {
                return "kIF_MOD,";
            }
            case 294: {
                return "kUNLESS_MOD,";
            }
            case 295: {
                return "kWHILE_MOD,";
            }
            case 296: {
                return "kUNTIL_MOD,";
            }
            case 297: {
                return "kRESCUE_MOD,";
            }
            case 298: {
                return "kALIAS,";
            }
            case 299: {
                return "kDEFINED,";
            }
            case 300: {
                return "klBEGIN,";
            }
            case 301: {
                return "klEND,";
            }
            case 302: {
                return "k__LINE__,";
            }
            case 303: {
                return "k__FILE__,";
            }
            case 304: {
                return "k__ENCODING__,";
            }
            case 305: {
                return "kDO_LAMBDA,";
            }
            case 306: {
                return "tIDENTIFIER[" + this.value() + "],";
            }
            case 307: {
                return "tFID[" + this.value() + "],";
            }
            case 308: {
                return "tGVAR[" + this.value() + "],";
            }
            case 309: {
                return "tIVAR[" + this.value() + "],";
            }
            case 310: {
                return "tCONSTANT[" + this.value() + "],";
            }
            case 311: {
                return "tCVAR,";
            }
            case 378: {
                return "tINTEGER,";
            }
            case 379: {
                return "tFLOAT,";
            }
            case 377: {
                return "tSTRING_CONTENT[" + this.value() + "],";
            }
            case 365: {
                return "tSTRING_BEG,";
            }
            case 372: {
                return "tSTRING_END,";
            }
            case 370: {
                return "tSTRING_DBEG,";
            }
            case 371: {
                return "tSTRING_DVAR,";
            }
            case 366: {
                return "tXSTRING_BEG,";
            }
            case 367: {
                return "tREGEXP_BEG,";
            }
            case 380: {
                return "tREGEXP_END,";
            }
            case 368: {
                return "tWORDS_BEG,";
            }
            case 369: {
                return "tQWORDS_BEG,";
            }
            case 376: {
                return "tBACK_REF,";
            }
            case 363: {
                return "tBACK_REF2,";
            }
            case 375: {
                return "tNTH_REF,";
            }
            case 314: {
                return "tUPLUS";
            }
            case 315: {
                return "tUMINUS,";
            }
            case 317: {
                return "tPOW,";
            }
            case 318: {
                return "tCMP,";
            }
            case 319: {
                return "tEQ,";
            }
            case 320: {
                return "tEQQ,";
            }
            case 321: {
                return "tNEQ,";
            }
            case 322: {
                return "tGEQ,";
            }
            case 323: {
                return "tLEQ,";
            }
            case 324: {
                return "tANDOP,";
            }
            case 325: {
                return "tOROP,";
            }
            case 326: {
                return "tMATCH,";
            }
            case 327: {
                return "tNMATCH,";
            }
            case 328: {
                return "tDOT,";
            }
            case 329: {
                return "tDOT2,";
            }
            case 330: {
                return "tDOT3,";
            }
            case 331: {
                return "tAREF,";
            }
            case 332: {
                return "tASET,";
            }
            case 333: {
                return "tLSHFT,";
            }
            case 334: {
                return "tRSHFT,";
            }
            case 335: {
                return "tCOLON2,";
            }
            case 336: {
                return "tCOLON3,";
            }
            case 337: {
                return "tOP_ASGN,";
            }
            case 338: {
                return "tASSOC,";
            }
            case 339: {
                return "tLPAREN,";
            }
            case 340: {
                return "tLPAREN2,";
            }
            case 342: {
                return "tLPAREN_ARG,";
            }
            case 343: {
                return "tLBRACK,";
            }
            case 344: {
                return "tRBRACK,";
            }
            case 345: {
                return "tLBRACE,";
            }
            case 346: {
                return "tLBRACE_ARG,";
            }
            case 347: {
                return "tSTAR,";
            }
            case 348: {
                return "tSTAR2,";
            }
            case 349: {
                return "tAMPER,";
            }
            case 350: {
                return "tAMPER2,";
            }
            case 364: {
                return "tSYMBEG,";
            }
            case 351: {
                return "tTILDE,";
            }
            case 352: {
                return "tPERCENT,";
            }
            case 353: {
                return "tDIVIDE,";
            }
            case 354: {
                return "tPLUS,";
            }
            case 355: {
                return "tMINUS,";
            }
            case 356: {
                return "tLT,";
            }
            case 357: {
                return "tGT,";
            }
            case 360: {
                return "tCARET,";
            }
            case 359: {
                return "tBANG,";
            }
            case 361: {
                return "tTLCURLY,";
            }
            case 362: {
                return "tRCURLY,";
            }
            case 358: {
                return "tTPIPE,";
            }
            case 373: {
                return "tLAMBDA,";
            }
            case 374: {
                return "tLAMBEG,";
            }
            case 341: {
                return "tRPAREN,";
            }
            case 312: {
                return "tLABEL(" + ((Token)this.value()).getValue() + ":),";
            }
            case 10: {
                return "NL";
            }
            case -1: {
                return "EOF";
            }
        }
        return "'" + (char)token + "',";
    }

    public boolean hasScanEvent() {
        if (this.lex_p < this.tokp) {
            throw this.parser.getRuntime().newRuntimeError("lex_p < tokp");
        }
        return this.lex_p > this.tokp;
    }

    public void dispatchDelayedToken(int token) {
        int saved_line = this.ruby_sourceline;
        int saved_tokp = this.tokp;
        this.ruby_sourceline = this.delayed_line;
        this.tokp = this.lex_pbeg + this.delayed_col;
        RubyString value = this.parser.getRuntime().newString(this.delayed.dup());
        String event = this.tokenToEventId(token);
        this.yaccValue = this.parser.dispatch(event, (IRubyObject)value);
        this.delayed = null;
        this.ruby_sourceline = saved_line;
        this.tokp = saved_tokp;
    }

    public void dispatchIgnoredScanEvent(int token) {
        if (!this.hasScanEvent()) {
            return;
        }
        this.scanEventValue(token);
    }

    public void dispatchScanEvent(int token) {
        if (!this.hasScanEvent()) {
            return;
        }
        this.yaccValue = this.scanEventValue(token);
    }

    private IRubyObject scanEventValue(int token) {
        RubyString value = this.parser.getRuntime().newString(this.lexb.makeShared(this.tokp, this.lex_p - this.tokp));
        String event = this.tokenToEventId(token);
        IRubyObject returnValue = this.parser.dispatch(event, (IRubyObject)value);
        this.flush();
        return returnValue;
    }

    private String tokenToEventId(int token) {
        switch (token) {
            case 32: {
                return "on_words_sep";
            }
            case 359: {
                return "on_op";
            }
            case 352: {
                return "on_op";
            }
            case 350: {
                return "on_op";
            }
            case 348: {
                return "on_op";
            }
            case 354: {
                return "on_op";
            }
            case 355: {
                return "on_op";
            }
            case 353: {
                return "on_op";
            }
            case 356: {
                return "on_op";
            }
            case 61: {
                return "on_op";
            }
            case 357: {
                return "on_op";
            }
            case 63: {
                return "on_op";
            }
            case 360: {
                return "on_op";
            }
            case 358: {
                return "on_op";
            }
            case 351: {
                return "on_op";
            }
            case 58: {
                return "on_op";
            }
            case 44: {
                return "on_comma";
            }
            case 46: {
                return "on_period";
            }
            case 328: {
                return "on_period";
            }
            case 59: {
                return "on_semicolon";
            }
            case 363: {
                return "on_backtick";
            }
            case 10: {
                return "on_nl";
            }
            case 298: {
                return "on_kw";
            }
            case 290: {
                return "on_kw";
            }
            case 261: {
                return "on_kw";
            }
            case 275: {
                return "on_kw";
            }
            case 270: {
                return "on_kw";
            }
            case 257: {
                return "on_kw";
            }
            case 259: {
                return "on_kw";
            }
            case 299: {
                return "on_kw";
            }
            case 280: {
                return "on_kw";
            }
            case 282: {
                return "on_kw";
            }
            case 281: {
                return "on_kw";
            }
            case 269: {
                return "on_kw";
            }
            case 268: {
                return "on_kw";
            }
            case 264: {
                return "on_kw";
            }
            case 263: {
                return "on_kw";
            }
            case 289: {
                return "on_kw";
            }
            case 274: {
                return "on_kw";
            }
            case 265: {
                return "on_kw";
            }
            case 293: {
                return "on_kw";
            }
            case 279: {
                return "on_kw";
            }
            case 258: {
                return "on_kw";
            }
            case 276: {
                return "on_kw";
            }
            case 287: {
                return "on_kw";
            }
            case 292: {
                return "on_kw";
            }
            case 291: {
                return "on_kw";
            }
            case 277: {
                return "on_kw";
            }
            case 262: {
                return "on_kw";
            }
            case 297: {
                return "on_kw";
            }
            case 278: {
                return "on_kw";
            }
            case 283: {
                return "on_kw";
            }
            case 286: {
                return "on_kw";
            }
            case 285: {
                return "on_kw";
            }
            case 267: {
                return "on_kw";
            }
            case 288: {
                return "on_kw";
            }
            case 260: {
                return "on_kw";
            }
            case 266: {
                return "on_kw";
            }
            case 294: {
                return "on_kw";
            }
            case 273: {
                return "on_kw";
            }
            case 296: {
                return "on_kw";
            }
            case 271: {
                return "on_kw";
            }
            case 272: {
                return "on_kw";
            }
            case 295: {
                return "on_kw";
            }
            case 284: {
                return "on_kw";
            }
            case 303: {
                return "on_kw";
            }
            case 302: {
                return "on_kw";
            }
            case 304: {
                return "on_kw";
            }
            case 300: {
                return "on_kw";
            }
            case 301: {
                return "on_kw";
            }
            case 305: {
                return "on_kw";
            }
            case 349: {
                return "on_op";
            }
            case 324: {
                return "on_op";
            }
            case 331: {
                return "on_op";
            }
            case 332: {
                return "on_op";
            }
            case 338: {
                return "on_op";
            }
            case 376: {
                return "on_backref";
            }
            case 313: {
                return "on_CHAR";
            }
            case 318: {
                return "on_op";
            }
            case 335: {
                return "on_op";
            }
            case 336: {
                return "on_op";
            }
            case 310: {
                return "on_const";
            }
            case 311: {
                return "on_cvar";
            }
            case 329: {
                return "on_op";
            }
            case 330: {
                return "on_op";
            }
            case 319: {
                return "on_op";
            }
            case 320: {
                return "on_op";
            }
            case 307: {
                return "on_ident";
            }
            case 379: {
                return "on_float";
            }
            case 322: {
                return "on_op";
            }
            case 308: {
                return "on_gvar";
            }
            case 306: {
                return "on_ident";
            }
            case 378: {
                return "on_int";
            }
            case 309: {
                return "on_ivar";
            }
            case 345: {
                return "on_lbrace";
            }
            case 346: {
                return "on_lbrace";
            }
            case 361: {
                return "on_lbrace";
            }
            case 362: {
                return "on_rbrace";
            }
            case 343: {
                return "on_lbracket";
            }
            case 91: {
                return "on_lbracket";
            }
            case 344: {
                return "on_rbracket";
            }
            case 323: {
                return "on_op";
            }
            case 339: {
                return "on_lparen";
            }
            case 342: {
                return "on_lparen";
            }
            case 340: {
                return "on_lparen";
            }
            case 41: {
                return "on_rparen";
            }
            case 333: {
                return "on_op";
            }
            case 326: {
                return "on_op";
            }
            case 321: {
                return "on_op";
            }
            case 327: {
                return "on_op";
            }
            case 375: {
                return "on_backref";
            }
            case 337: {
                return "on_op";
            }
            case 325: {
                return "on_op";
            }
            case 317: {
                return "on_op";
            }
            case 369: {
                return "on_qwords_beg";
            }
            case 367: {
                return "on_regexp_beg";
            }
            case 380: {
                return "on_regexp_end";
            }
            case 341: {
                return "on_rparen";
            }
            case 334: {
                return "on_op";
            }
            case 347: {
                return "on_op";
            }
            case 365: {
                return "on_tstring_beg";
            }
            case 377: {
                return "on_tstring_content";
            }
            case 370: {
                return "on_embexpr_beg";
            }
            case 371: {
                return "on_embvar";
            }
            case 372: {
                return "on_tstring_end";
            }
            case 364: {
                return "on_symbeg";
            }
            case 315: {
                return "on_op";
            }
            case 316: {
                return "on_op";
            }
            case 314: {
                return "on_op";
            }
            case 368: {
                return "on_words_beg";
            }
            case 366: {
                return "on_backtick";
            }
            case 312: {
                return "on_label";
            }
            case 373: {
                return "on_tlambda";
            }
            case 374: {
                return "on_tlambeg";
            }
            case 381: {
                return "on_ignored_nl";
            }
            case 382: {
                return "on_comment";
            }
            case 383: {
                return "on_embdoc_beg";
            }
            case 384: {
                return "on_embdoc";
            }
            case 385: {
                return "on_embdoc_end";
            }
            case 386: {
                return "on_sp";
            }
            case 387: {
                return "on_heredoc_beg";
            }
            case 388: {
                return "on_heredoc_end";
            }
            case 390: {
                return "on___end__";
            }
        }
        return "on_CHAR";
    }

    private int yylex2() throws IOException {
        try {
            int currentToken = this.yylex2();
            System.out.println(this.printToken(currentToken));
            return currentToken;
        }
        catch (Exception e) {
            System.out.println("FFUFUFUFUFUFUFUF: " + e);
            return -1;
        }
    }

    private int yylex() throws IOException {
        int c;
        boolean spaceSeen = false;
        if (this.lex_strterm != null) {
            int tok = this.lex_strterm.parseString(this, this.src);
            if (tok == 372 || tok == 380) {
                this.lex_strterm = null;
                this.setState(LexState.EXPR_END);
            }
            return tok;
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        block49: while (true) {
            boolean fallthru = false;
            c = this.nextc();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    ByteList whitespaceBuf = new ByteList();
                    whitespaceBuf.append(c);
                    boolean looping = true;
                    spaceSeen = true;
                    block50: while (looping && (c = this.nextc()) != -1) {
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                whitespaceBuf.append(c);
                                continue block50;
                            }
                        }
                        looping = false;
                    }
                    this.pushback(c);
                    this.dispatchScanEvent(386);
                    continue block49;
                }
                case 35: {
                    if (!this.parseMagicComment(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p)) && this.comment_at_top()) {
                        this.set_file_encoding(this.lex_p, this.lex_pend);
                    }
                    this.lex_p = this.lex_pend;
                    this.dispatchScanEvent(382);
                    fallthru = true;
                }
                case 10: {
                    switch (this.lex_state) {
                        case EXPR_FNAME: 
                        case EXPR_DOT: 
                        case EXPR_BEG: 
                        case EXPR_CLASS: 
                        case EXPR_VALUE: {
                            if (fallthru) continue block49;
                            this.dispatchScanEvent(381);
                            continue block49;
                        }
                    }
                    boolean done = false;
                    block51: while (!done) {
                        c = this.nextc();
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                spaceSeen = true;
                                continue block51;
                            }
                            case 46: {
                                c = this.nextc();
                                if (c != 46) {
                                    this.pushback(c);
                                    this.pushback(46);
                                    continue block49;
                                }
                            }
                            default: {
                                --this.ruby_sourceline;
                                this.lex_nextline = this.lex_lastline;
                            }
                            case -1: 
                        }
                        this.lex_goto_eol();
                        if (c != -1) {
                            this.tokp = this.lex_p;
                        }
                        done = true;
                    }
                    this.commandStart = true;
                    this.setState(LexState.EXPR_BEG);
                    return 10;
                }
                case 42: {
                    return this.star(spaceSeen);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.was_bol() && this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), BEGIN_DOC_MARKER, BEGIN_DOC_MARKER.length()) && Character.isWhitespace(this.p(this.lex_p + 5))) {
                        boolean first_p = true;
                        this.lex_goto_eol();
                        this.dispatchScanEvent(383);
                        do {
                            this.lex_goto_eol();
                            if (!first_p) {
                                this.dispatchScanEvent(384);
                            }
                            first_p = false;
                            c = this.nextc();
                            if (c != -1) continue;
                            this.compile_error("embedded document meets end of file");
                            return -1;
                        } while (c != 61 || !this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), END_DOC_MARKER, END_DOC_MARKER.length()) || this.lex_p + 3 != this.lex_pend && !Character.isWhitespace(this.p(this.lex_p + 3)));
                        this.lex_goto_eol();
                        this.dispatchScanEvent(385);
                        continue block49;
                    }
                    this.determineExpressionState();
                    c = this.nextc();
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 61) {
                            return 320;
                        }
                        this.pushback(c);
                        return 319;
                    }
                    if (c == 126) {
                        return 326;
                    }
                    if (c == 62) {
                        return 338;
                    }
                    this.pushback(c);
                    return 61;
                }
                case 60: {
                    return this.lessThan(spaceSeen);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote();
                }
                case 96: {
                    return this.backtick(commandState);
                }
                case 39: {
                    return this.singleQuote();
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(spaceSeen);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(spaceSeen);
                }
                case 45: {
                    return this.minus(spaceSeen);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(c);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(spaceSeen);
                }
                case 47: {
                    return this.slash(spaceSeen);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                    this.setState(LexState.EXPR_BEG);
                    return 59;
                }
                case 44: {
                    return this.comma(c);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(spaceSeen);
                }
                case 91: {
                    return this.leftBracket(spaceSeen);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    c = this.nextc();
                    if (c == 10) {
                        spaceSeen = true;
                        continue block49;
                    }
                    this.pushback(c);
                    return 92;
                }
                case 37: {
                    return this.percent(spaceSeen);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    if (this.was_bol() && this.whole_match_p(END_MARKER, false)) {
                        this.__end__seen = true;
                        this.eofp = true;
                        this.lex_goto_eol();
                        this.dispatchScanEvent(390);
                        return -1;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private int identifierToken(LexState last_state, int result, String value) {
        if (result == 306 && last_state != LexState.EXPR_DOT && this.parser.getCurrentScope().isDefined(value) >= 0) {
            this.setState(LexState.EXPR_END);
        }
        this.yaccValue = new Token(value);
        this.identValue = value;
        return result;
    }

    private int getIdentifier(int first) throws IOException {
        if (this.isMultiByteChar(first)) {
            first = this.readCodepoint(first, this.current_enc);
        }
        if (!this.isIdentifierChar(first)) {
            return first;
        }
        this.tokenBuffer.append((char)first);
        int c = this.nextc();
        while (c != -1) {
            if (this.isMultiByteChar(c)) {
                c = this.readCodepoint(c, this.current_enc);
            }
            if (!this.isIdentifierChar(c)) break;
            this.tokenBuffer.append((char)c);
            c = this.nextc();
        }
        this.pushback(c);
        return first;
    }

    private int ampersand(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        switch (c) {
            case 38: {
                this.setState(LexState.EXPR_BEG);
                c = this.nextc();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    return 337;
                }
                this.pushback(c);
                return 324;
            }
            case 61: {
                this.setState(LexState.EXPR_BEG);
                return 337;
            }
        }
        this.pushback(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            if (this.isVerbose()) {
                this.warning("`&' interpreted as argument prefix");
            }
            c = 349;
        } else {
            c = this.isBEG() ? 349 : 350;
        }
        this.determineExpressionState();
        return c;
    }

    private int at() throws IOException {
        int result;
        int c = this.nextc();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('@');
        if (c == 64) {
            this.tokenBuffer.append('@');
            c = this.nextc();
            result = 311;
        } else {
            result = 309;
        }
        if (Character.isDigit(c)) {
            if (this.tokenBuffer.length() == 1) {
                this.compile_error("`@" + c + "' is not allowed as an instance variable name");
                return -1;
            }
            this.compile_error("`@@" + c + "' is not allowed as a class variable name");
            return -1;
        }
        if (!this.isIdentifierChar(c)) {
            this.pushback(c);
            return 64;
        }
        this.getIdentifier(c);
        LexState last_state = this.lex_state;
        this.setState(LexState.EXPR_END);
        return this.identifierToken(last_state, result, this.tokenBuffer.toString().intern());
    }

    private int backtick(boolean commandState) throws IOException {
        switch (this.lex_state) {
            case EXPR_FNAME: {
                this.setState(LexState.EXPR_ENDFN);
                return 363;
            }
            case EXPR_DOT: {
                this.setState(commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG);
                return 363;
            }
        }
        this.lex_strterm = new StringTerm(2, 0, 96);
        return 366;
    }

    private int bang() throws IOException {
        int c = this.nextc();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.setState(LexState.EXPR_ARG);
            if (c == 64) {
                return 359;
            }
        } else {
            this.setState(LexState.EXPR_BEG);
        }
        switch (c) {
            case 61: {
                return 321;
            }
            case 126: {
                return 327;
            }
        }
        this.pushback(c);
        return 359;
    }

    private int caret() throws IOException {
        int c = this.nextc();
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            return 337;
        }
        this.determineExpressionState();
        this.pushback(c);
        return 360;
    }

    private int colon(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (c == 58) {
            if (this.isBEG() || this.lex_state == LexState.EXPR_CLASS || this.isARG() && spaceSeen) {
                this.setState(LexState.EXPR_BEG);
                return 336;
            }
            this.setState(LexState.EXPR_DOT);
            return 335;
        }
        if (this.isEND() || Character.isWhitespace(c)) {
            this.pushback(c);
            this.setState(LexState.EXPR_BEG);
            return 58;
        }
        switch (c) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, c);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, c);
                break;
            }
            default: {
                this.pushback(c);
            }
        }
        this.setState(LexState.EXPR_FNAME);
        return 364;
    }

    private int comma(int c) throws IOException {
        this.setState(LexState.EXPR_BEG);
        return c;
    }

    private int doKeyword(LexState state) {
        this.commandStart = true;
        if (this.leftParenBegin > 0 && this.leftParenBegin == this.parenNest) {
            this.leftParenBegin = 0;
            --this.parenNest;
            return 305;
        }
        if (this.conditionState.isInState()) {
            return 281;
        }
        if (state != LexState.EXPR_CMDARG && this.cmdArgumentState.isInState()) {
            return 282;
        }
        if (state == LexState.EXPR_ENDARG || state == LexState.EXPR_BEG) {
            return 282;
        }
        return 280;
    }

    private int dollar() throws IOException {
        LexState last_state = this.lex_state;
        this.setState(LexState.EXPR_END);
        int c = this.nextc();
        switch (c) {
            case 95: {
                c = this.nextc();
                if (this.isIdentifierChar(c)) {
                    this.tokenBuffer.setLength(0);
                    this.tokenBuffer.append("$_");
                    this.getIdentifier(c);
                    last_state = this.lex_state;
                    this.setState(LexState.EXPR_END);
                    return this.identifierToken(last_state, 308, this.tokenBuffer.toString().intern());
                }
                this.pushback(c);
                c = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.yaccValue = new Token("$" + (char)c, 308);
                return 308;
            }
            case 45: {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                this.tokenBuffer.append((char)c);
                c = this.nextc();
                if (this.isIdentifierChar(c)) {
                    this.tokenBuffer.append((char)c);
                } else {
                    this.pushback(c);
                }
                this.yaccValue = new Token(this.tokenBuffer.toString(), 308);
                return 308;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                this.yaccValue = new Token("$" + (char)c);
                if (last_state == LexState.EXPR_FNAME) {
                    return 308;
                }
                return 376;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                do {
                    this.tokenBuffer.append((char)c);
                } while (Character.isDigit(c = this.nextc()));
                this.pushback(c);
                if (last_state == LexState.EXPR_FNAME) {
                    this.yaccValue = new Token(this.tokenBuffer.toString(), 308);
                    return 308;
                }
                this.yaccValue = new Token(this.tokenBuffer.toString());
                return 375;
            }
            case 48: {
                this.setState(LexState.EXPR_END);
                return this.identifierToken(last_state, 308, ("$" + (char)c).intern());
            }
        }
        if (!this.isIdentifierChar(c)) {
            this.pushback(c);
            return 36;
        }
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('$');
        this.getIdentifier(c);
        last_state = this.lex_state;
        this.setState(LexState.EXPR_END);
        return this.identifierToken(last_state, 308, this.tokenBuffer.toString().intern());
    }

    private int dot() throws IOException {
        this.setState(LexState.EXPR_BEG);
        int c = this.nextc();
        if (c == 46) {
            c = this.nextc();
            if (c == 46) {
                return 330;
            }
            this.pushback(c);
            return 329;
        }
        this.pushback(c);
        if (Character.isDigit(c)) {
            this.compile_error("no .<digit> floating literal anymore; put 0 before dot");
        }
        this.setState(LexState.EXPR_DOT);
        return 328;
    }

    private int doubleQuote() throws IOException {
        this.lex_strterm = new StringTerm(2, 0, 34);
        return 365;
    }

    private int greaterThan() throws IOException {
        this.determineExpressionState();
        int c = this.nextc();
        switch (c) {
            case 61: {
                return 322;
            }
            case 62: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    return 337;
                }
                this.pushback(c);
                return 334;
            }
        }
        this.pushback(c);
        return 357;
    }

    private int identifier(int c, boolean commandState) throws IOException {
        Keyword keyword;
        if (!this.isIdentifierChar(c)) {
            String badChar = "\\" + Integer.toOctalString(c & 0xFF);
            this.compile_error("Invalid char `" + badChar + "' ('" + (char)c + "') in expression");
        }
        this.tokenBuffer.setLength(0);
        int first = this.getIdentifier(c);
        c = this.nextc();
        boolean lastBangOrPredicate = false;
        if (c == 33 || c == 63) {
            if (!this.peek(61)) {
                lastBangOrPredicate = true;
                this.tokenBuffer.append((char)c);
            } else {
                this.pushback(c);
            }
        } else {
            this.pushback(c);
        }
        int result = 0;
        LexState last_state = this.lex_state;
        if (lastBangOrPredicate) {
            result = 307;
        } else {
            if (this.lex_state == LexState.EXPR_FNAME) {
                c = this.nextc();
                if (c == 61) {
                    int c2 = this.nextc();
                    if (c2 != 126 && c2 != 62 && (c2 != 61 || this.peek(62))) {
                        result = 306;
                        this.tokenBuffer.append((char)c);
                        this.pushback(c2);
                    } else {
                        this.pushback(c2);
                        this.pushback(c);
                    }
                } else {
                    this.pushback(c);
                }
            }
            result = result == 0 && Character.isUpperCase(first) ? 310 : 306;
        }
        String tempVal = this.tokenBuffer.toString().intern();
        if (this.lex_state == LexState.EXPR_BEG && !commandState || this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
            int c2 = this.nextc();
            if (c2 == 58 && !this.peek(58)) {
                this.setState(LexState.EXPR_BEG);
                this.yaccValue = new Token(tempVal + ':');
                return 312;
            }
            this.pushback(c2);
        }
        if (this.lex_state != LexState.EXPR_DOT && (keyword = RipperLexer.getKeyword(tempVal)) != null) {
            LexState state = this.lex_state;
            if (keyword == Keyword.NOT) {
                this.setState(LexState.EXPR_ARG);
            } else {
                this.setState(keyword.state);
            }
            if (state == LexState.EXPR_FNAME) {
                this.yaccValue = new Token(keyword.name);
            } else {
                this.yaccValue = new Token(tempVal);
                if (keyword.id0 == 280) {
                    return this.doKeyword(state);
                }
            }
            if (state == LexState.EXPR_BEG || state == LexState.EXPR_VALUE) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.setState(LexState.EXPR_BEG);
            }
            return keyword.id1;
        }
        if (this.isBEG() || this.lex_state == LexState.EXPR_DOT || this.isARG()) {
            this.setState(commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG);
        } else if (this.lex_state == LexState.EXPR_ENDFN) {
            this.setState(LexState.EXPR_ENDFN);
        } else {
            this.setState(LexState.EXPR_END);
        }
        return this.identifierToken(last_state, result, tempVal);
    }

    private int leftBracket(boolean spaceSeen) throws IOException {
        ++this.parenNest;
        int c = 91;
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.setState(LexState.EXPR_ARG);
            c = this.nextc();
            if (c == 93) {
                if (this.peek(61)) {
                    this.nextc();
                    return 332;
                }
                return 331;
            }
            this.pushback(c);
            return 91;
        }
        if (this.isBEG() || this.isARG() && spaceSeen) {
            c = 343;
        }
        this.setState(LexState.EXPR_BEG);
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        return c;
    }

    private int leftCurly() {
        if (this.leftParenBegin > 0 && this.leftParenBegin == this.parenNest) {
            this.setState(LexState.EXPR_BEG);
            this.leftParenBegin = 0;
            --this.parenNest;
            this.conditionState.stop();
            this.cmdArgumentState.stop();
            return 374;
        }
        int c = this.isARG() || this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDFN ? 361 : (this.lex_state == LexState.EXPR_ENDARG ? 346 : 345);
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(LexState.EXPR_BEG);
        if (c != 345) {
            this.commandStart = true;
        }
        return c;
    }

    private int leftParen(boolean spaceSeen) throws IOException {
        int result = 340;
        if (this.isBEG()) {
            result = 339;
        } else if (spaceSeen) {
            if (this.lex_state == LexState.EXPR_CMDARG) {
                result = 342;
            } else if (this.lex_state == LexState.EXPR_ARG) {
                result = 342;
            }
        }
        ++this.parenNest;
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(LexState.EXPR_BEG);
        return result;
    }

    private int lessThan(boolean spaceSeen) throws IOException {
        int tok;
        int c = this.nextc();
        if (!(c != 60 || this.lex_state == LexState.EXPR_DOT || this.lex_state == LexState.EXPR_CLASS || this.isEND() || this.isARG() && !spaceSeen || (tok = this.hereDocumentIdentifier()) == 0)) {
            return tok;
        }
        this.determineExpressionState();
        switch (c) {
            case 61: {
                c = this.nextc();
                if (c == 62) {
                    return 318;
                }
                this.pushback(c);
                return 323;
            }
            case 60: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    return 337;
                }
                this.pushback(c);
                return 333;
            }
        }
        this.pushback(c);
        return 356;
    }

    private int minus(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.setState(LexState.EXPR_ARG);
            if (c == 64) {
                return 315;
            }
            this.pushback(c);
            return 355;
        }
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            return 337;
        }
        if (c == 62) {
            this.setState(LexState.EXPR_ARG);
            return 373;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen)) {
            if (this.isARG()) {
                this.arg_ambiguous();
            }
            this.setState(LexState.EXPR_BEG);
            this.pushback(c);
            if (Character.isDigit(c)) {
                return 316;
            }
            return 315;
        }
        this.setState(LexState.EXPR_BEG);
        this.pushback(c);
        return 355;
    }

    private int percent(boolean spaceSeen) throws IOException {
        if (this.isBEG()) {
            return this.parseQuote(this.nextc());
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            return 337;
        }
        if (this.isSpaceArg(c, spaceSeen)) {
            return this.parseQuote(c);
        }
        this.determineExpressionState();
        this.pushback(c);
        return 352;
    }

    private int pipe() throws IOException {
        int c = this.nextc();
        switch (c) {
            case 124: {
                this.setState(LexState.EXPR_BEG);
                c = this.nextc();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    return 337;
                }
                this.pushback(c);
                return 325;
            }
            case 61: {
                this.setState(LexState.EXPR_BEG);
                return 337;
            }
        }
        this.determineExpressionState();
        this.pushback(c);
        return 358;
    }

    private int plus(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.setState(LexState.EXPR_ARG);
            if (c == 64) {
                return 314;
            }
            this.pushback(c);
            return 354;
        }
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            return 337;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen)) {
            if (this.isARG()) {
                this.arg_ambiguous();
            }
            this.setState(LexState.EXPR_BEG);
            this.pushback(c);
            if (Character.isDigit(c)) {
                c = 43;
                return this.parseNumber(c);
            }
            return 314;
        }
        this.setState(LexState.EXPR_BEG);
        this.pushback(c);
        return 354;
    }

    private int questionMark() throws IOException {
        if (this.isEND()) {
            this.setState(LexState.EXPR_VALUE);
            return 63;
        }
        int c = this.nextc();
        if (c == -1) {
            this.compile_error("incomplete character syntax");
            return -1;
        }
        if (Character.isWhitespace(c)) {
            if (!this.isARG()) {
                int c2 = 0;
                switch (c) {
                    case 32: {
                        c2 = 115;
                        break;
                    }
                    case 10: {
                        c2 = 110;
                        break;
                    }
                    case 9: {
                        c2 = 116;
                        break;
                    }
                    case 13: {
                        c2 = 114;
                        break;
                    }
                    case 12: {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warn("invalid character syntax; use ?\\" + c2);
                }
            }
            this.pushback(c);
            this.setState(LexState.EXPR_VALUE);
            return 63;
        }
        if (this.isIdentifierChar(c) && !this.peek(10) && this.isNext_identchar()) {
            this.pushback(c);
            this.setState(LexState.EXPR_VALUE);
            return 63;
        }
        if (c == 92) {
            if (this.peek(117)) {
                this.nextc();
                ByteList oneCharBL = new ByteList(2);
                c = this.readUTFEscape(oneCharBL, false, false);
                if (c >= 128) {
                    this.tokenAddMBC(c, oneCharBL);
                } else {
                    oneCharBL.append(c);
                }
                this.setState(LexState.EXPR_END);
                this.yaccValue = new Token(oneCharBL);
                return 378;
            }
            c = this.readEscape();
        }
        this.setState(LexState.EXPR_END);
        ByteList oneCharBL = new ByteList(1);
        oneCharBL.append(c);
        this.yaccValue = new Token(oneCharBL);
        return 313;
    }

    private int rightBracket() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(LexState.EXPR_ENDARG);
        return 344;
    }

    private int rightCurly() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(LexState.EXPR_ENDARG);
        return 362;
    }

    private int rightParen() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(LexState.EXPR_ENDFN);
        return 341;
    }

    private int singleQuote() throws IOException {
        this.lex_strterm = new StringTerm(0, 0, 39);
        return 365;
    }

    private int slash(boolean spaceSeen) throws IOException {
        if (this.isBEG()) {
            this.lex_strterm = new StringTerm(7, 0, 47);
            return 367;
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(LexState.EXPR_BEG);
            return 337;
        }
        this.pushback(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, 0, 47);
            return 367;
        }
        this.determineExpressionState();
        return 353;
    }

    private int star(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        switch (c) {
            case 42: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(LexState.EXPR_BEG);
                    return 337;
                }
                this.pushback(c);
                c = 317;
                break;
            }
            case 61: {
                this.setState(LexState.EXPR_BEG);
                return 337;
            }
            default: {
                this.pushback(c);
                if (this.isSpaceArg(c, spaceSeen)) {
                    if (this.isVerbose()) {
                        this.warning("`*' interpreted as argument prefix");
                    }
                    c = 347;
                    break;
                }
                c = this.isBEG() ? 347 : 348;
            }
        }
        this.determineExpressionState();
        return c;
    }

    private int tilde() throws IOException {
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            int c = this.nextc();
            if (c != 64) {
                this.pushback(c);
            }
            this.setState(LexState.EXPR_ARG);
        } else {
            this.setState(LexState.EXPR_BEG);
        }
        return 351;
    }

    private int parseNumber(int c) throws IOException {
        this.setState(LexState.EXPR_END);
        this.tokenBuffer.setLength(0);
        if (c == 45) {
            this.tokenBuffer.append((char)c);
            c = this.nextc();
        } else if (c == 43) {
            c = this.nextc();
        }
        int nondigit = 0;
        if (c == 48) {
            int startLen = this.tokenBuffer.length();
            c = this.nextc();
            switch (c) {
                case 88: 
                case 120: {
                    c = this.nextc();
                    if (RipperLexer.isHexChar(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!RipperLexer.isHexChar(c)) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.tokenBuffer.length() == startLen) {
                        this.compile_error("Hexadecimal number without hex-digits.");
                    } else if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 16);
                    return 378;
                }
                case 66: 
                case 98: {
                    c = this.nextc();
                    if (c == 48 || c == 49) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (c != 48 && c != 49) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.tokenBuffer.length() == startLen) {
                        this.compile_error("Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 2);
                    return 378;
                }
                case 68: 
                case 100: {
                    c = this.nextc();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.tokenBuffer.length() == startLen) {
                        this.compile_error("Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                    return 378;
                }
                case 79: 
                case 111: {
                    c = this.nextc();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (c == 95) {
                            if (nondigit != 0) break;
                            nondigit = c;
                        } else {
                            if (c < 48 || c > 55) break;
                            nondigit = 0;
                            this.tokenBuffer.append((char)c);
                        }
                        c = this.nextc();
                    }
                    if (this.tokenBuffer.length() > startLen) {
                        this.pushback(c);
                        if (nondigit != 0) {
                            this.compile_error("Trailing '_' in number.");
                        }
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 8);
                        return 378;
                    }
                }
                case 56: 
                case 57: {
                    this.compile_error("Illegal octal digit.");
                }
                case 46: 
                case 69: 
                case 101: {
                    this.tokenBuffer.append('0');
                    break;
                }
                default: {
                    this.pushback(c);
                    this.yaccValue = this.parser.getRuntime().newFixnum(0);
                    return 378;
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nondigit = 0;
                    this.tokenBuffer.append((char)c);
                    break;
                }
                case 46: {
                    if (nondigit != 0) {
                        this.pushback(c);
                        this.compile_error("Trailing '_' in number.");
                        break;
                    }
                    if (seen_point || seen_e) {
                        this.pushback(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    int c2 = this.nextc();
                    if (!Character.isDigit(c2)) {
                        this.pushback(c2);
                        this.pushback(46);
                        if (c == 95) break;
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                        return 378;
                    }
                    this.tokenBuffer.append('.');
                    this.tokenBuffer.append((char)c2);
                    seen_point = true;
                    nondigit = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                        break;
                    }
                    if (seen_e) {
                        this.pushback(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    this.tokenBuffer.append((char)c);
                    seen_e = true;
                    nondigit = c;
                    c = this.nextc();
                    if (c == 45 || c == 43) {
                        this.tokenBuffer.append((char)c);
                        nondigit = c;
                        break;
                    }
                    this.pushback(c);
                    break;
                }
                case 95: {
                    if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.pushback(c);
                    return this.getNumberToken(this.tokenBuffer.toString(), seen_e || seen_point, nondigit);
                }
            }
            c = this.nextc();
        }
    }

    private int getNumberToken(String number, boolean isFloat, int nondigit) {
        if (nondigit != 0) {
            this.compile_error("Trailing '_' in number.");
        } else if (isFloat) {
            return this.getFloatToken(number);
        }
        this.yaccValue = this.getInteger(number, 10);
        return 378;
    }

    public void readUTFEscapeRegexpLiteral(ByteList buffer) throws IOException {
        buffer.append(92);
        buffer.append(117);
        if (this.peek(123)) {
            do {
                buffer.append(this.nextc());
                if (this.scanHexLiteral(buffer, 6, false, "invalid Unicode escape") <= '\u10ffff') continue;
                this.compile_error("invalid Unicode codepoint (too large)");
            } while (this.peek(32) || this.peek(9));
            int c = this.nextc();
            if (c != 125) {
                this.compile_error("unterminated Unicode escape");
            }
            buffer.append((int)((char)c));
        } else {
            this.scanHexLiteral(buffer, 4, true, "Invalid Unicode escape");
        }
        buffer.setEncoding(UTF8_ENCODING);
    }

    public int tokenAddMBC(int codepoint, ByteList buffer) {
        int length = buffer.getEncoding().codeToMbc(codepoint, this.mbcBuf, 0);
        if (length <= 0) {
            return -1;
        }
        buffer.append(this.mbcBuf, 0, length);
        return length;
    }

    public void tokenAddMBCFromSrc(int c, ByteList buffer) throws IOException {
        int length = buffer.getEncoding().length((byte)c);
        buffer.append((byte)c);
        for (int off = 0; off < length - 1; ++off) {
            buffer.append((byte)this.nextc());
        }
    }

    public int readUTFEscape(ByteList buffer, boolean stringLiteral, boolean symbolLiteral) throws IOException {
        int codepoint;
        if (this.peek(123)) {
            do {
                this.nextc();
                codepoint = this.scanHex(6, false, "invalid Unicode escape");
                if (codepoint > 0x10FFFF) {
                    this.compile_error("invalid Unicode codepoint (too large)");
                }
                if (buffer == null) continue;
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            } while (this.peek(32) || this.peek(9));
            int c = this.nextc();
            if (c != 125) {
                this.compile_error("unterminated Unicode escape");
            }
        } else {
            codepoint = this.scanHex(4, true, "Invalid Unicode escape");
            if (buffer != null) {
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            }
        }
        return codepoint;
    }

    private void readUTF8EscapeIntoBuffer(int codepoint, ByteList buffer, boolean stringLiteral) {
        if (codepoint >= 128) {
            buffer.setEncoding(UTF8_ENCODING);
            if (stringLiteral) {
                this.tokenAddMBC(codepoint, buffer);
            }
        } else if (stringLiteral) {
            buffer.append((int)((char)codepoint));
        }
    }

    public int readEscape() throws IOException {
        int c = this.nextc();
        switch (c) {
            case 92: {
                return c;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.pushback(c);
                return this.scanOct(3);
            }
            case 120: {
                return this.scanHex(2, false, "Invalid escape character syntax");
            }
            case 98: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 77: {
                c = this.nextc();
                if (c != 45) {
                    this.compile_error("Invalid escape character syntax");
                } else {
                    c = this.nextc();
                    if (c == 92) {
                        return (char)(this.readEscape() | 0x80);
                    }
                    if (c == -1) {
                        this.compile_error("Invalid escape character syntax");
                    }
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 67: {
                c = this.nextc();
                if (c != 45) {
                    this.compile_error("Invalid escape character syntax");
                }
            }
            case 99: {
                c = this.nextc();
                if (c == 92) {
                    c = this.readEscape();
                } else {
                    if (c == 63) {
                        return 127;
                    }
                    if (c == -1) {
                        this.compile_error("Invalid escape character syntax");
                    }
                }
                return (char)(c & 0x9F);
            }
            case -1: {
                this.compile_error("Invalid escape character syntax");
            }
        }
        return c;
    }

    private char scanHexLiteral(ByteList buffer, int count, boolean strict, String errorMessage) throws IOException {
        int i;
        char hexValue = '\u0000';
        for (i = 0; i < count; ++i) {
            int h1 = this.nextc();
            if (!RipperLexer.isHexChar(h1)) {
                this.pushback(h1);
                break;
            }
            buffer.append(h1);
            hexValue = (char)(hexValue << 4);
            hexValue = (char)(hexValue | Integer.parseInt("" + (char)h1, 16) & 0xF);
        }
        if (i == 0 || strict && count != i) {
            this.compile_error(errorMessage);
        }
        return hexValue;
    }

    private int scanHex(int count, boolean strict, String errorMessage) throws IOException {
        int i;
        int hexValue = 0;
        for (i = 0; i < count; ++i) {
            int h1 = this.nextc();
            if (!RipperLexer.isHexChar(h1)) {
                this.pushback(h1);
                break;
            }
            hexValue <<= 4;
            hexValue |= Integer.parseInt("" + (char)h1, 16) & 0xF;
        }
        if (i == 0 || strict && count != i) {
            this.compile_error(errorMessage);
        }
        return hexValue;
    }

    private char scanOct(int count) throws IOException {
        char value = '\u0000';
        for (int i = 0; i < count; ++i) {
            int c = this.nextc();
            if (!RipperLexer.isOctChar(c)) {
                this.pushback(c);
                break;
            }
            value = (char)(value << 3);
            value = (char)(value | Integer.parseInt("" + (char)c, 8));
        }
        return value;
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
        map.put("__ENCODING__", Keyword.__ENCODING__);
        magicRegexp = new Regex(magicString.getBytes(), 0, magicString.length(), 0, Encoding.load((String)"ASCII"));
    }

    public static enum LexState {
        EXPR_BEG,
        EXPR_END,
        EXPR_ARG,
        EXPR_CMDARG,
        EXPR_ENDARG,
        EXPR_MID,
        EXPR_FNAME,
        EXPR_DOT,
        EXPR_CLASS,
        EXPR_VALUE,
        EXPR_ENDFN;

    }

    public static enum Keyword {
        END("end", 264, 264, LexState.EXPR_END),
        ELSE("else", 269, 269, LexState.EXPR_BEG),
        CASE("case", 270, 270, LexState.EXPR_BEG),
        ENSURE("ensure", 263, 263, LexState.EXPR_BEG),
        MODULE("module", 258, 258, LexState.EXPR_BEG),
        ELSIF("elsif", 268, 268, LexState.EXPR_BEG),
        DEF("def", 259, 259, LexState.EXPR_FNAME),
        RESCUE("rescue", 262, 297, LexState.EXPR_MID),
        NOT("not", 292, 292, LexState.EXPR_BEG),
        THEN("then", 267, 267, LexState.EXPR_BEG),
        YIELD("yield", 284, 284, LexState.EXPR_ARG),
        FOR("for", 274, 274, LexState.EXPR_BEG),
        SELF("self", 286, 286, LexState.EXPR_END),
        FALSE("false", 289, 289, LexState.EXPR_END),
        RETRY("retry", 278, 278, LexState.EXPR_END),
        RETURN("return", 283, 283, LexState.EXPR_MID),
        TRUE("true", 288, 288, LexState.EXPR_END),
        IF("if", 265, 293, LexState.EXPR_BEG),
        DEFINED_P("defined?", 299, 299, LexState.EXPR_ARG),
        SUPER("super", 285, 285, LexState.EXPR_ARG),
        UNDEF("undef", 260, 260, LexState.EXPR_FNAME),
        BREAK("break", 275, 275, LexState.EXPR_MID),
        IN("in", 279, 279, LexState.EXPR_BEG),
        DO("do", 280, 280, LexState.EXPR_BEG),
        NIL("nil", 287, 287, LexState.EXPR_END),
        UNTIL("until", 273, 296, LexState.EXPR_BEG),
        UNLESS("unless", 266, 294, LexState.EXPR_BEG),
        OR("or", 291, 291, LexState.EXPR_BEG),
        NEXT("next", 276, 276, LexState.EXPR_MID),
        WHEN("when", 271, 271, LexState.EXPR_BEG),
        REDO("redo", 277, 277, LexState.EXPR_END),
        AND("and", 290, 290, LexState.EXPR_BEG),
        BEGIN("begin", 261, 261, LexState.EXPR_BEG),
        __LINE__("__LINE__", 302, 302, LexState.EXPR_END),
        CLASS("class", 257, 257, LexState.EXPR_CLASS),
        __FILE__("__FILE__", 303, 303, LexState.EXPR_END),
        LEND("END", 301, 301, LexState.EXPR_END),
        LBEGIN("BEGIN", 300, 300, LexState.EXPR_END),
        WHILE("while", 272, 295, LexState.EXPR_BEG),
        ALIAS("alias", 298, 298, LexState.EXPR_FNAME),
        __ENCODING__("__ENCODING__", 304, 304, LexState.EXPR_END);

        public final String name;
        public final int id0;
        public final int id1;
        public final LexState state;

        private Keyword(String name, int id0, int id1, LexState state) {
            this.name = name;
            this.id0 = id0;
            this.id1 = id1;
            this.state = state;
        }
    }
}

