/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;

public final class TaggingPresetNameTemplateList {
    private static TaggingPresetNameTemplateList instance;
    private final List<TaggingPreset> presetsWithPattern = new LinkedList<TaggingPreset>();

    public static TaggingPresetNameTemplateList getInstance() {
        if (instance == null) {
            instance = new TaggingPresetNameTemplateList();
        }
        return instance;
    }

    private TaggingPresetNameTemplateList() {
        if (TaggingPresetPreference.taggingPresets != null) {
            for (TaggingPreset taggingPreset : TaggingPresetPreference.taggingPresets) {
                if (taggingPreset.nameTemplate == null) continue;
                this.presetsWithPattern.add(taggingPreset);
            }
        }
    }

    public TaggingPreset findPresetTemplate(OsmPrimitive osmPrimitive) {
        for (TaggingPreset taggingPreset : this.presetsWithPattern) {
            Set<TaggingPresetType> set;
            if (!taggingPreset.typeMatches(set = Collections.singleton(TaggingPresetType.forPrimitive(osmPrimitive))) || !(taggingPreset.nameTemplateFilter != null ? taggingPreset.nameTemplateFilter.match(osmPrimitive) : taggingPreset.matches(set, osmPrimitive.getKeys(), false))) continue;
            return taggingPreset;
        }
        return null;
    }
}

