/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PlatformHookUnixoid
implements PlatformHook {
    private String osDescription;

    @Override
    public void preStartupHook() {
    }

    @Override
    public void startupHook() {
    }

    @Override
    public void openUrl(String string) throws IOException {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"gnome-open", "kfmclient openURL", "firefox"}) {
            try {
                Runtime.getRuntime().exec(string2 + " " + string);
                return;
            }
            catch (IOException iOException) {
                Main.warn(iOException);
            }
        }
    }

    @Override
    public void initSystemShortcuts() {
        for (int i = 112; i <= 123; ++i) {
            Shortcut.registerSystemShortcut("screen:toogle" + i, I18n.tr("reserved", new Object[0]), i, 640).setAutomatic();
        }
        Shortcut.registerSystemShortcut("system:reset", I18n.tr("reserved", new Object[0]), 127, 640).setAutomatic();
        Shortcut.registerSystemShortcut("system:resetX", I18n.tr("reserved", new Object[0]), 8, 640).setAutomatic();
    }

    @Override
    public String makeTooltip(String string, Shortcut shortcut) {
        String string2 = "";
        string2 = string2 + "<html>";
        string2 = string2 + string;
        if (shortcut != null && shortcut.getKeyText().length() != 0) {
            string2 = string2 + " ";
            string2 = string2 + "<font size='-2'>";
            string2 = string2 + "(" + shortcut.getKeyText() + ")";
            string2 = string2 + "</font>";
        }
        string2 = string2 + "&nbsp;</html>";
        return string2;
    }

    @Override
    public String getDefaultStyle() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    @Override
    public boolean canFullscreen() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
    }

    @Override
    public boolean rename(File file, File file2) {
        return file.renameTo(file2);
    }

    public String getJavaPackageDetails() {
        try {
            String string = Utils.execOutput(Arrays.asList("lsb_release", "-i", "-s"));
            if ("Debian".equalsIgnoreCase(string) || "Ubuntu".equalsIgnoreCase(string)) {
                String string2 = System.getProperty("java.home");
                if ("/usr/lib/jvm/java-6-openjdk-amd64/jre".equals(string2) || "/usr/lib/jvm/java-6-openjdk-i386/jre".equals(string2) || "/usr/lib/jvm/java-6-openjdk/jre".equals(string2)) {
                    String string3 = Utils.execOutput(Arrays.asList("dpkg-query", "--show", "--showformat", "${Architecture}-${Version}", "openjdk-6-jre"));
                    return "openjdk-6-jre:" + string3;
                }
                if ("/usr/lib/jvm/java-7-openjdk-amd64/jre".equals(string2) || "/usr/lib/jvm/java-7-openjdk-i386/jre".equals(string2)) {
                    String string4 = Utils.execOutput(Arrays.asList("dpkg-query", "--show", "--showformat", "${Architecture}-${Version}", "openjdk-7-jre"));
                    return "openjdk-7-jre:" + string4;
                }
            }
        }
        catch (IOException iOException) {
            Main.warn(iOException);
        }
        return null;
    }

    protected String buildOSDescription() {
        String string = System.getProperty("os.name");
        if ("Linux".equalsIgnoreCase(string)) {
            try {
                Process process = Runtime.getRuntime().exec("lsb_release -ds");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string2 = Utils.strip(bufferedReader.readLine());
                Utils.close(bufferedReader);
                if (string2 != null && !string2.isEmpty()) {
                    string2 = string2.replaceAll("\"+", "");
                    if ((string2 = string2.replaceAll("NAME=", "")).startsWith("Linux ")) {
                        return string2;
                    }
                    if (!string2.isEmpty()) {
                        return "Linux " + string2;
                    }
                }
            }
            catch (IOException iOException) {
                for (LinuxReleaseInfo linuxReleaseInfo : new LinuxReleaseInfo[]{new LinuxReleaseInfo("/etc/lsb-release", "DISTRIB_DESCRIPTION", "DISTRIB_ID", "DISTRIB_RELEASE"), new LinuxReleaseInfo("/etc/os-release", "PRETTY_NAME", "NAME", "VERSION"), new LinuxReleaseInfo("/etc/arch-release"), new LinuxReleaseInfo("/etc/debian_version", "Debian GNU/Linux "), new LinuxReleaseInfo("/etc/fedora-release"), new LinuxReleaseInfo("/etc/gentoo-release"), new LinuxReleaseInfo("/etc/redhat-release")}) {
                    String string3 = linuxReleaseInfo.extractDescription();
                    if (string3 == null || string3.isEmpty()) continue;
                    return "Linux " + string3;
                }
            }
        }
        return string;
    }

    @Override
    public String getOSDescription() {
        if (this.osDescription == null) {
            this.osDescription = this.buildOSDescription();
        }
        return this.osDescription;
    }

    protected void askUpdateJava(String string) {
        try {
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Outdated Java version", new Object[0]), new String[]{I18n.tr("Update Java", new Object[0]), I18n.tr("Cancel", new Object[0])});
            if (!extendedDialog.toggleEnable("askUpdateJava7").toggleCheckState()) {
                extendedDialog.setButtonIcons(new String[]{"java.png", "cancel.png"}).setCancelButton(2);
                extendedDialog.setMinimumSize(new Dimension(460, 260));
                extendedDialog.setIcon(2);
                extendedDialog.setContent(I18n.tr("You are running version {0} of Java.", "<b>" + string + "</b>") + "<br><br>" + "<b>" + I18n.tr("This version is no longer supported by {0} since {1} and is not recommended for use.", "Oracle", I18n.tr("February 2013", new Object[0])) + "</b><br><br>" + "<b>" + I18n.tr("JOSM will soon stop working with this version; we highly recommend you to update to Java {0}.", "7") + "</b><br><br>" + I18n.tr("Would you like to update now ?", new Object[0]));
                if (extendedDialog.showDialog().getValue() == 1) {
                    this.openUrl("http://www.java.com/download");
                }
            }
        }
        catch (IOException iOException) {
            Main.warn(iOException);
        }
    }

    protected static class LinuxReleaseInfo {
        private final String path;
        private final String descriptionField;
        private final String idField;
        private final String releaseField;
        private final boolean plainText;
        private final String prefix;

        public LinuxReleaseInfo(String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, false, null);
        }

        public LinuxReleaseInfo(String string) {
            this(string, null, null, null, true, null);
        }

        public LinuxReleaseInfo(String string, String string2) {
            this(string, null, null, null, true, string2);
        }

        private LinuxReleaseInfo(String string, String string2, String string3, String string4, boolean bl, String string5) {
            this.path = string;
            this.descriptionField = string2;
            this.idField = string3;
            this.releaseField = string4;
            this.plainText = bl;
            this.prefix = string5;
        }

        public String toString() {
            return "ReleaseInfo [path=" + this.path + ", descriptionField=" + this.descriptionField + ", idField=" + this.idField + ", releaseField=" + this.releaseField + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public String extractDescription() {
            File file;
            String string = null;
            if (this.path != null && (file = new File(this.path)).exists()) {
                BufferedReader bufferedReader;
                block11: {
                    bufferedReader = null;
                    try {
                        String string2;
                        bufferedReader = new BufferedReader(new FileReader(file));
                        String string3 = null;
                        String string4 = null;
                        while (string == null && (string2 = bufferedReader.readLine()) != null) {
                            if (string2.contains("=")) {
                                String[] stringArray = string2.split("=");
                                if (stringArray.length < 2) continue;
                                if (this.descriptionField != null && this.descriptionField.equalsIgnoreCase(stringArray[0])) {
                                    string = Utils.strip(stringArray[1]);
                                    continue;
                                }
                                if (this.idField != null && this.idField.equalsIgnoreCase(stringArray[0])) {
                                    string3 = Utils.strip(stringArray[1]);
                                    continue;
                                }
                                if (this.releaseField == null || !this.releaseField.equalsIgnoreCase(stringArray[0])) continue;
                                string4 = Utils.strip(stringArray[1]);
                                continue;
                            }
                            if (!this.plainText || string2.isEmpty()) continue;
                            string = Utils.strip(string2);
                        }
                        if (string != null || string3 == null || string4 == null) break block11;
                        string = string3 + " " + string4;
                    }
                    catch (IOException iOException) {
                        Utils.close(bufferedReader);
                        catch (Throwable throwable) {
                            Utils.close(bufferedReader);
                            throw throwable;
                        }
                    }
                }
                Utils.close(bufferedReader);
            }
            if (string != null && !string.isEmpty() && this.prefix != null && !this.prefix.isEmpty()) {
                string = this.prefix + string;
            }
            if (string != null) {
                string = string.replaceAll("\"+", "");
            }
            return string;
        }
    }
}

