/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ReadRemotePluginInformationTask
extends PleaseWaitRunnable {
    private Collection<String> sites;
    private boolean canceled;
    private HttpURLConnection connection;
    private List<PluginInformation> availablePlugins;

    protected void init(Collection<String> collection) {
        this.sites = collection;
        if (collection == null) {
            this.sites = Collections.emptySet();
        }
        this.availablePlugins = new LinkedList<PluginInformation>();
    }

    public ReadRemotePluginInformationTask(Collection<String> collection) {
        super(I18n.tr("Download plugin list...", new Object[0]), false);
        this.init(collection);
    }

    public ReadRemotePluginInformationTask(ProgressMonitor progressMonitor, Collection<String> collection) {
        super(I18n.tr("Download plugin list...", new Object[0]), progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor, false);
        this.init(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected File createSiteCacheFile(File file, String string, CacheType cacheType) {
        String string2;
        try {
            string = string.replaceAll("%<(.*)>", "");
            URL uRL = new URL(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("site-");
            stringBuilder.append(uRL.getHost()).append("-");
            if (uRL.getPort() != -1) {
                stringBuilder.append(uRL.getPort()).append("-");
            }
            String string3 = uRL.getPath();
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append("_");
            }
            switch (cacheType) {
                case PLUGIN_LIST: {
                    stringBuilder.append(".txt");
                    break;
                }
                case ICON_LIST: {
                    stringBuilder.append("-icons.zip");
                }
            }
            string2 = stringBuilder.toString();
        }
        catch (MalformedURLException malformedURLException) {
            string2 = "site-unknown.txt";
        }
        return new File(file, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String downloadPluginList(String string, ProgressMonitor progressMonitor) {
        ReadRemotePluginInformationTask readRemotePluginInformationTask;
        String string2;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            String string4 = Utils.join(",", Main.pref.getCollection("plugins"));
            String string5 = string.replaceAll("%<(.*)>", "");
            string = string4 != null && string4.length() != 0 ? string.replaceAll("%<(.*)>", "$1" + string4) : string5;
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", string5));
            URL uRL = new URL(string);
            Object object = this;
            synchronized (object) {
                this.connection = Utils.openHttpConnection(uRL);
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("Accept-Charset", "utf-8");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
            object = new StringBuilder();
            while ((string3 = bufferedReader.readLine()) != null) {
                ((StringBuilder)object).append(string3).append("\n");
            }
            string2 = ((StringBuilder)object).toString();
            readRemotePluginInformationTask = this;
        }
        catch (MalformedURLException malformedURLException) {
            block34: {
                if (!this.canceled) break block34;
                String string6 = null;
                return string6;
            }
            malformedURLException.printStackTrace();
            String string7 = null;
            return string7;
        }
        catch (IOException iOException) {
            if (this.canceled) {
                String string8 = null;
                return string8;
            }
            this.handleIOException(progressMonitor, iOException, I18n.tr("Plugin list download error", new Object[0]), I18n.tr("JOSM failed to download plugin list:", new Object[0]));
            String string9 = null;
            return string9;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ReadRemotePluginInformationTask readRemotePluginInformationTask2 = this;
            synchronized (readRemotePluginInformationTask2) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            Utils.close(bufferedReader);
            progressMonitor.finishTask();
        }
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
            this.connection = null;
        }
        Utils.close(bufferedReader);
        progressMonitor.finishTask();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIOException(ProgressMonitor progressMonitor, IOException iOException, String string, String string2) {
        String string3;
        Object object;
        InputStream inputStream = this.connection.getErrorStream();
        StringBuilder stringBuilder = new StringBuilder();
        if (inputStream != null) {
            object = null;
            try {
                object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((string3 = ((BufferedReader)object).readLine()) != null) {
                    stringBuilder.append(string3).append("\n");
                }
            }
            catch (Exception exception) {
                Main.error(iOException);
                Main.error(exception);
            }
            finally {
                Utils.close((Closeable)object);
            }
        }
        object = iOException.getMessage();
        string3 = stringBuilder.toString();
        Main.error((String)(string3.isEmpty() ? object : (String)object + " - Details:\n" + string3));
        GuiHelper.runInEDTAndWait(new Runnable((String)object, string3, progressMonitor, string){
            final /* synthetic */ String val$msg;
            final /* synthetic */ String val$details;
            final /* synthetic */ ProgressMonitor val$monitor;
            final /* synthetic */ String val$title;
            {
                this.val$msg = string;
                this.val$details = string2;
                this.val$monitor = progressMonitor;
                this.val$title = string3;
            }

            @Override
            public void run() {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add((Component)new JLabel(I18n.tr("JOSM failed to download plugin list:", new Object[0])), GBC.eol().insets(0, 0, 0, 10));
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : this.val$msg.split("(?<=\\G.{200})")) {
                    stringBuilder.append(string).append("\n");
                }
                jPanel.add((Component)new JLabel("<html><body width=\"500\"><b>" + stringBuilder.toString().trim() + "</b></body></html>"), GBC.eol().insets(0, 0, 0, 10));
                if (!this.val$details.isEmpty()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Details:", new Object[0])), GBC.eol().insets(0, 0, 0, 10));
                    JosmTextArea josmTextArea = new JosmTextArea(this.val$details);
                    josmTextArea.setEditable(false);
                    josmTextArea.setLineWrap(true);
                    josmTextArea.setWrapStyleWord(true);
                    JScrollPane jScrollPane = new JScrollPane(josmTextArea);
                    jScrollPane.setPreferredSize(new Dimension(500, 300));
                    jPanel.add((Component)jScrollPane, GBC.eol().fill());
                }
                JOptionPane.showMessageDialog(this.val$monitor.getWindowParent(), jPanel, this.val$title, 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    protected void downloadPluginIcons(String string, File file, ProgressMonitor progressMonitor) {
        Iterator<PluginInformation> iterator;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            string = string.replaceAll("%<(.*)>", "");
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", string));
            iterator = new URL(string);
            Object object = this;
            synchronized (object) {
                this.connection = Utils.openHttpConnection((URL)((Object)iterator));
                this.connection.setRequestProperty("Cache-Control", "no-cache");
            }
            inputStream = this.connection.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            object = new byte[8192];
            int n = inputStream.read((byte[])object);
            while (n != -1) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                n = inputStream.read((byte[])object);
            }
            Utils.close(fileOutputStream);
            iterator = this;
        }
        catch (MalformedURLException malformedURLException) {
            block35: {
                if (!this.canceled) break block35;
                return;
            }
            malformedURLException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            if (this.canceled) {
                return;
            }
            this.handleIOException(progressMonitor, iOException, I18n.tr("Plugin icons download error", new Object[0]), I18n.tr("JOSM failed to download plugin icons:", new Object[0]));
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Utils.close(fileOutputStream);
            ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
            synchronized (readRemotePluginInformationTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            Utils.close(inputStream);
            progressMonitor.finishTask();
        }
        synchronized (iterator) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
            this.connection = null;
        }
        Utils.close(inputStream);
        progressMonitor.finishTask();
        for (Object object : this.availablePlugins) {
            if (((PluginInformation)object).icon != null || ((PluginInformation)object).iconPath == null) continue;
            ((PluginInformation)object).icon = new ImageProvider(((PluginInformation)object).name + ".jar/" + ((PluginInformation)object).iconPath).setArchive(file).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cachePluginList(String string, String string2) {
        PrintWriter printWriter = null;
        try {
            File file = Main.pref.getPluginsDirectory();
            if (!file.exists() && !file.mkdirs()) {
                Main.warn(I18n.tr("Failed to create plugin directory ''{0}''. Cannot cache plugin list from plugin site ''{1}''.", file.toString(), string));
            }
            File file2 = this.createSiteCacheFile(file, string, CacheType.PLUGIN_LIST);
            this.getProgressMonitor().subTask(I18n.tr("Writing plugin list to local cache ''{0}''", file2.toString()));
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8"));
            printWriter.write(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                Utils.close(printWriter);
            }
        }
    }

    protected List<PluginInformation> filterDeprecatedPlugins(List<PluginInformation> list) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(list.size());
        HashSet<String> hashSet = new HashSet<String>();
        for (PluginHandler.DeprecatedPlugin object : PluginHandler.DEPRECATED_PLUGINS) {
            hashSet.add(object.name);
        }
        for (PluginInformation pluginInformation : list) {
            if (hashSet.contains(pluginInformation.name)) continue;
            arrayList.add(pluginInformation);
        }
        return arrayList;
    }

    protected void parsePluginListDocument(String string, String string2) {
        try {
            this.getProgressMonitor().subTask(I18n.tr("Parsing plugin list from site ''{0}''", string));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            List<PluginInformation> list = new PluginListParser().parse(byteArrayInputStream);
            this.availablePlugins.addAll(this.filterDeprecatedPlugins(list));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Main.error(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", string, unsupportedEncodingException.toString()));
            unsupportedEncodingException.printStackTrace();
        }
        catch (PluginListParseException pluginListParseException) {
            Main.error(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", string, pluginListParseException.toString()));
            pluginListParseException.printStackTrace();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        Object object;
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        File file = Main.pref.getPluginsDirectory();
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String object2 : PluginInformation.getPluginLocations()) {
            object = new File(object2).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.matches("^([0-9]+-)?site.*\\.txt$") || string.matches("^([0-9]+-)?site.*-icons\\.zip$");
                }
            });
            if (object == null || ((File[])object).length <= 0) continue;
            linkedList.addAll(Arrays.asList(object));
        }
        for (String string : this.sites) {
            object = string.replaceAll("%<(.*)>", "");
            this.getProgressMonitor().subTask(I18n.tr("Processing plugin list from site ''{0}''", object));
            String string2 = this.downloadPluginList(string, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            linkedList.remove(this.createSiteCacheFile(file, string, CacheType.PLUGIN_LIST));
            linkedList.remove(this.createSiteCacheFile(file, string, CacheType.ICON_LIST));
            if (string2 != null) {
                this.getProgressMonitor().worked(1);
                this.cachePluginList(string, string2);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                this.parsePluginListDocument(string, string2);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
            }
            this.downloadPluginIcons(string + "-icons.zip", this.createSiteCacheFile(file, string, CacheType.ICON_LIST), this.getProgressMonitor().createSubTaskMonitor(0, false));
        }
        for (File file2 : linkedList) {
            file2.delete();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<PluginInformation> getAvailablePlugins() {
        return this.availablePlugins;
    }

    protected static enum CacheType {
        PLUGIN_LIST,
        ICON_LIST;

    }
}

