/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.session.GeoImageSessionExporter;
import org.openstreetmap.josm.io.session.GpxTracksSessionExporter;
import org.openstreetmap.josm.io.session.ImagerySessionExporter;
import org.openstreetmap.josm.io.session.MarkerSessionExporter;
import org.openstreetmap.josm.io.session.OsmDataSessionExporter;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SessionWriter {
    private static Map<Class<? extends Layer>, Class<? extends SessionLayerExporter>> sessionLayerExporters = new HashMap<Class<? extends Layer>, Class<? extends SessionLayerExporter>>();
    private final List<Layer> layers;
    private final int active;
    private final Map<Layer, SessionLayerExporter> exporters;
    private final MultiMap<Layer, Layer> dependencies;
    private final boolean zip;
    private ZipOutputStream zipOut;

    public static void registerSessionLayerExporter(Class<? extends Layer> clazz, Class<? extends SessionLayerExporter> clazz2) {
        sessionLayerExporters.put(clazz, clazz2);
    }

    public static SessionLayerExporter getSessionLayerExporter(Layer layer) {
        Class<?> clazz = layer.getClass();
        Class<? extends SessionLayerExporter> clazz2 = sessionLayerExporters.get(clazz);
        if (clazz2 == null) {
            return null;
        }
        try {
            Constructor<? extends SessionLayerExporter> constructor = clazz2.getConstructor(clazz);
            return constructor.newInstance(layer);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public SessionWriter(List<Layer> list, int n, Map<Layer, SessionLayerExporter> map, MultiMap<Layer, Layer> multiMap, boolean bl) {
        this.layers = list;
        this.active = n;
        this.exporters = map;
        this.dependencies = multiMap;
        this.zip = bl;
    }

    public Document createJosDocument() throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("josm-session");
        element.setAttribute("version", "0.1");
        document.appendChild(element);
        Element element2 = document.createElement("viewport");
        element.appendChild(element2);
        Element element3 = document.createElement("center");
        element2.appendChild(element3);
        EastNorth eastNorth = Main.map.mapView.getCenter();
        LatLon latLon = Projections.inverseProject(eastNorth);
        element3.setAttribute("lat", Double.toString(latLon.lat()));
        element3.setAttribute("lon", Double.toString(latLon.lon()));
        Element element4 = document.createElement("scale");
        element2.appendChild(element4);
        double d = Main.map.mapView.getDist100Pixel();
        element4.setAttribute("meter-per-pixel", Double.toString(d / 100.0));
        Element element5 = document.createElement("layers");
        if (this.active >= 0) {
            element5.setAttribute("active", Integer.toString(this.active + 1));
        }
        element.appendChild(element5);
        for (int i = 0; i < this.layers.size(); ++i) {
            Set<Layer> set;
            Layer layer = this.layers.get(i);
            SessionLayerExporter sessionLayerExporter = this.exporters.get(layer);
            ExportSupport exportSupport = new ExportSupport(document, i + 1);
            Element element6 = sessionLayerExporter.export(exportSupport);
            element6.setAttribute("index", Integer.toString(i + 1));
            element6.setAttribute("name", layer.getName());
            element6.setAttribute("visible", Boolean.toString(layer.isVisible()));
            if (layer.getOpacity() != 1.0) {
                element6.setAttribute("opacity", Double.toString(layer.getOpacity()));
            }
            if (!(set = this.dependencies.get(layer)).isEmpty()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (Layer layer2 : set) {
                    int n = this.layers.indexOf(layer2);
                    if (n == -1) {
                        throw new AssertionError();
                    }
                    arrayList.add(n + 1);
                }
                element6.setAttribute("depends", Utils.join(",", arrayList));
            }
            element5.appendChild(element6);
        }
        return document;
    }

    public void writeJos(Document document, OutputStream outputStream) throws IOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "utf-8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StreamResult streamResult = new StreamResult(outputStreamWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
    }

    public void write(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException);
        }
        this.write(fileOutputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.zip) {
            this.zipOut = new ZipOutputStream(new BufferedOutputStream(outputStream));
        }
        Document document = this.createJosDocument();
        if (this.zip) {
            ZipEntry zipEntry = new ZipEntry("session.jos");
            this.zipOut.putNextEntry(zipEntry);
            this.writeJos(document, this.zipOut);
            Utils.close(this.zipOut);
        } else {
            this.writeJos(document, new BufferedOutputStream(outputStream));
        }
        Utils.close(outputStream);
    }

    static {
        SessionWriter.registerSessionLayerExporter(OsmDataLayer.class, OsmDataSessionExporter.class);
        SessionWriter.registerSessionLayerExporter(TMSLayer.class, ImagerySessionExporter.class);
        SessionWriter.registerSessionLayerExporter(WMSLayer.class, ImagerySessionExporter.class);
        SessionWriter.registerSessionLayerExporter(GpxLayer.class, GpxTracksSessionExporter.class);
        SessionWriter.registerSessionLayerExporter(GeoImageLayer.class, GeoImageSessionExporter.class);
        SessionWriter.registerSessionLayerExporter(MarkerLayer.class, MarkerSessionExporter.class);
    }

    public class ExportSupport {
        private Document doc;
        private int layerIndex;

        public ExportSupport(Document document, int n) {
            this.doc = document;
            this.layerIndex = n;
        }

        public Element createElement(String string) {
            return this.doc.createElement(string);
        }

        public Text createTextNode(String string) {
            return this.doc.createTextNode(string);
        }

        public int getLayerIndex() {
            return this.layerIndex;
        }

        public OutputStream getOutputStreamZip(String string) throws IOException {
            if (!this.isZip()) {
                throw new RuntimeException();
            }
            ZipEntry zipEntry = new ZipEntry(string);
            SessionWriter.this.zipOut.putNextEntry(zipEntry);
            return SessionWriter.this.zipOut;
        }

        public boolean isZip() {
            return SessionWriter.this.zip;
        }
    }
}

