/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.IOException;
import java.util.HashMap;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImagerySessionImporter
implements SessionLayerImporter {
    @Override
    public Layer load(Element element, SessionReader.ImportSupport importSupport, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        Object object;
        Object object2;
        String string = element.getAttribute("version");
        if (!"0.1".equals(string)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for imagery layer is not supported. Expected: 0.1", string));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = nodeList.item(i);
            if (object2.getNodeType() != 1) continue;
            object = (Element)object2;
            hashMap.put(object.getTagName(), object.getTextContent());
        }
        ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry = Preferences.deserializeStruct(hashMap, ImageryInfo.ImageryPreferenceEntry.class);
        object2 = new ImageryInfo(imageryPreferenceEntry);
        object = ImageryLayer.create((ImageryInfo)object2);
        return object;
    }
}

