/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.imagery.WMSGrabber;
import org.openstreetmap.josm.io.imagery.WMSRequest;
import org.openstreetmap.josm.tools.Utils;

public class HTMLGrabber
extends WMSGrabber {
    public static final StringProperty PROP_BROWSER = new StringProperty("imagery.wms.browser", "webkit-image {0}");

    public HTMLGrabber(MapView mapView, WMSLayer wMSLayer, boolean bl) {
        super(mapView, wMSLayer, bl);
    }

    @Override
    protected BufferedImage grab(WMSRequest wMSRequest, URL uRL, int n) throws IOException {
        Process process;
        String string = uRL.toExternalForm();
        Main.info("Grabbing HTML " + (n > 1 ? "(attempt " + n + ") " : "") + uRL);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(MessageFormat.format(PROP_BROWSER.get(), string));
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            throw new IOException("Could not start browser. Please check that the executable path is correct.\n" + iOException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utils.copyStream(process.getInputStream(), byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedImage bufferedImage = this.layer.normalizeImage(ImageIO.read(byteArrayInputStream));
        byteArrayInputStream.reset();
        this.layer.cache.saveToCache(this.layer.isOverlapEnabled() ? bufferedImage : null, byteArrayInputStream, Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth);
        return bufferedImage;
    }
}

