/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OsmDataParsingException
extends SAXException {
    private int columnNumber;
    private int lineNumber;

    public OsmDataParsingException() {
    }

    public OsmDataParsingException(Exception exception) {
        super(exception);
    }

    public OsmDataParsingException(String string, Exception exception) {
        super(string, exception);
    }

    public OsmDataParsingException(String string) {
        super(string);
    }

    public OsmDataParsingException rememberLocation(Locator locator) {
        if (locator == null) {
            return this;
        }
        this.columnNumber = locator.getColumnNumber();
        this.lineNumber = locator.getLineNumber();
        return this;
    }

    @Override
    public String getMessage() {
        String string = super.getMessage();
        if (this.lineNumber == 0 && this.columnNumber == 0) {
            return string;
        }
        if (string == null) {
            string = this.getClass().getName();
        }
        string = string + " " + I18n.tr("(at line {0}, column {1})", this.lineNumber, this.columnNumber);
        return string;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

