/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class GpxExporter
extends FileExporter
implements GpxConstants {
    private static final String warningGpl = "<html><font color='red' size='-2'>" + I18n.tr("Note: GPL is not compatible with the OSM license. Do not upload GPL licensed tracks.", new Object[0]) + "</html>";

    public GpxExporter() {
        super(GpxImporter.FILE_FILTER);
    }

    @Override
    public boolean acceptFile(File file, Layer layer) {
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            return false;
        }
        return super.acceptFile(file, layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportData(File file, Layer layer) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer or GpxLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        String string = file.getPath();
        if (string.indexOf(46) == -1) {
            string = string + ".gpx";
            file = new File(string);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        GpxData gpxData = layer instanceof GpxLayer ? ((GpxLayer)layer).data : new GpxData();
        jPanel.add((Component)new JLabel(I18n.tr("GPS track description", new Object[0])), GBC.eol());
        JosmTextArea josmTextArea = new JosmTextArea(3, 40);
        josmTextArea.setWrapStyleWord(true);
        josmTextArea.setLineWrap(true);
        josmTextArea.setText((String)gpxData.attr.get("meta.desc"));
        jPanel.add((Component)new JScrollPane(josmTextArea), GBC.eop().fill(1));
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Add author information", new Object[0]), Main.pref.getBoolean("lastAddAuthor", true));
        jPanel.add((Component)jCheckBox, GBC.eol());
        JLabel jLabel = new JLabel(I18n.tr("Real name", new Object[0]));
        jPanel.add((Component)jLabel, GBC.std().insets(10, 0, 5, 0));
        JosmTextField josmTextField = new JosmTextField();
        jPanel.add((Component)josmTextField, GBC.eol().fill(2));
        JLabel jLabel2 = new JLabel(I18n.tr("E-Mail", new Object[0]));
        jPanel.add((Component)jLabel2, GBC.std().insets(10, 0, 5, 0));
        JosmTextField josmTextField2 = new JosmTextField();
        jPanel.add((Component)josmTextField2, GBC.eol().fill(2));
        JLabel jLabel3 = new JLabel(I18n.tr("Copyright (URL)", new Object[0]));
        jPanel.add((Component)jLabel3, GBC.std().insets(10, 0, 5, 0));
        JosmTextField josmTextField3 = new JosmTextField();
        jPanel.add((Component)josmTextField3, GBC.std().fill(2));
        JButton jButton = new JButton(I18n.tr("Predefined", new Object[0]));
        jPanel.add((Component)jButton, GBC.eol().insets(5, 0, 0, 0));
        JLabel jLabel4 = new JLabel(I18n.tr("Copyright year", new Object[0]));
        jPanel.add((Component)jLabel4, GBC.std().insets(10, 0, 5, 5));
        JosmTextField josmTextField4 = new JosmTextField("");
        jPanel.add((Component)josmTextField4, GBC.eol().fill(2));
        JLabel jLabel5 = new JLabel("<html><font size='-2'>&nbsp;</html");
        jPanel.add((Component)jLabel5, GBC.eol().fill(2).insets(15, 0, 0, 0));
        GpxExporter.addDependencies(gpxData, jCheckBox, josmTextField, josmTextField2, josmTextField3, jButton, josmTextField4, jLabel, jLabel2, jLabel3, jLabel4, jLabel5);
        jPanel.add((Component)new JLabel(I18n.tr("Keywords", new Object[0])), GBC.eol());
        JosmTextField josmTextField5 = new JosmTextField();
        josmTextField5.setText((String)gpxData.attr.get("meta.keywords"));
        jPanel.add((Component)josmTextField5, GBC.eop().fill(2));
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Export options", new Object[0]), new String[]{I18n.tr("Export and Save", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"exportgpx.png", "cancel.png"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return;
        }
        Main.pref.put("lastAddAuthor", jCheckBox.isSelected());
        if (josmTextField.getText().length() != 0) {
            Main.pref.put("lastAuthorName", josmTextField.getText());
        }
        if (josmTextField3.getText().length() != 0) {
            Main.pref.put("lastCopyright", josmTextField3.getText());
        }
        gpxData = layer instanceof OsmDataLayer ? ((OsmDataLayer)layer).toGpxData() : (layer instanceof GpxLayer ? ((GpxLayer)layer).data : OsmDataLayer.toGpxData(this.getCurrentDataSet(), file));
        if (jCheckBox.isSelected()) {
            if (josmTextField.getText().length() > 0) {
                gpxData.attr.put("meta.author.name", josmTextField.getText());
                gpxData.attr.put("meta.copyright.author", josmTextField.getText());
            }
            if (josmTextField2.getText().length() > 0) {
                gpxData.attr.put("meta.author.email", josmTextField2.getText());
            }
            if (josmTextField3.getText().length() > 0) {
                gpxData.attr.put("meta.copyright.license", josmTextField3.getText());
            }
            if (josmTextField4.getText().length() > 0) {
                gpxData.attr.put("meta.copyright.year", josmTextField4.getText());
            }
        }
        if (josmTextArea.getText().length() > 0) {
            gpxData.attr.put("meta.desc", josmTextArea.getText());
        }
        if (josmTextField5.getText().length() > 0) {
            gpxData.attr.put("meta.keywords", josmTextField5.getText());
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            new GpxWriter(fileOutputStream).write(gpxData);
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            try {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while exporting {0}:\n{1}", string, iOException.getMessage()), I18n.tr("Error", new Object[0]), 0);
            }
            catch (Throwable throwable) {
                Utils.close(fileOutputStream);
                throw throwable;
            }
            Utils.close(fileOutputStream);
        }
        Utils.close(fileOutputStream);
    }

    private static void enableCopyright(GpxData gpxData, JosmTextField josmTextField, JButton jButton, JosmTextField josmTextField2, JLabel jLabel, JLabel jLabel2, JLabel jLabel3, boolean bl) {
        josmTextField.setEnabled(bl);
        jButton.setEnabled(bl);
        josmTextField2.setEnabled(bl);
        jLabel.setEnabled(bl);
        jLabel2.setEnabled(bl);
        jLabel3.setText(bl ? warningGpl : "<html><font size='-2'>&nbsp;</html");
        if (bl) {
            String string;
            if (josmTextField2.getText().length() == 0) {
                string = (String)gpxData.attr.get("meta.copyright.year");
                if (string == null) {
                    string = Integer.toString(Calendar.getInstance().get(1));
                }
                josmTextField2.setText(string);
            }
            if (josmTextField.getText().length() == 0) {
                string = (String)gpxData.attr.get("meta.copyright.license");
                if (string == null) {
                    string = Main.pref.get("lastCopyright", "http://creativecommons.org/licenses/by-sa/2.5");
                }
                josmTextField.setText(string);
                josmTextField.setCaretPosition(0);
            }
        } else {
            josmTextField2.setText("");
            josmTextField.setText("");
        }
    }

    private static void addDependencies(final GpxData gpxData, final JCheckBox jCheckBox, final JosmTextField josmTextField, final JosmTextField josmTextField2, final JosmTextField josmTextField3, final JButton jButton, final JosmTextField josmTextField4, final JLabel jLabel, final JLabel jLabel2, final JLabel jLabel3, final JLabel jLabel4, final JLabel jLabel5) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jCheckBox.isSelected();
                josmTextField.setEnabled(bl);
                josmTextField2.setEnabled(bl);
                jLabel.setEnabled(bl);
                jLabel2.setEnabled(bl);
                if (bl) {
                    String string = (String)gpxData.attr.get("meta.author.name");
                    if (string == null) {
                        string = Main.pref.get("lastAuthorName");
                    }
                    josmTextField.setText(string);
                    String string2 = (String)gpxData.attr.get("meta.author.email");
                    if (string2 == null) {
                        string2 = Main.pref.get("lastAuthorEmail");
                    }
                    josmTextField2.setText(string2);
                } else {
                    josmTextField.setText("");
                    josmTextField2.setText("");
                }
                boolean bl2 = josmTextField.getText().length() != 0;
                GpxExporter.enableCopyright(gpxData, josmTextField3, jButton, josmTextField4, jLabel3, jLabel4, jLabel5, bl && bl2);
            }
        };
        jCheckBox.addActionListener(actionListener);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = josmTextField.getText().length() != 0 && jCheckBox.isSelected();
                GpxExporter.enableCopyright(gpxData, josmTextField3, jButton, josmTextField4, jLabel3, jLabel4, jLabel5, bl);
            }
        };
        josmTextField.addKeyListener(keyAdapter);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[]{"Creative Commons By-SA", "Open Database License (ODbL)", "public domain", "GNU Lesser Public License (LGPL)", "BSD License (MIT/X11)"};
                JList<String> jList = new JList<String>(stringArray);
                jList.setVisibleRowCount(stringArray.length);
                jList.setSelectionMode(2);
                int n = JOptionPane.showConfirmDialog(Main.parent, new JScrollPane(jList), I18n.tr("Choose a predefined license", new Object[0]), 2, 3);
                if (n != 0 || jList.getSelectedIndex() == -1) {
                    return;
                }
                String[] stringArray2 = new String[]{"http://creativecommons.org/licenses/by-sa/2.5", "http://opendatacommons.org/licenses/odbl/1.0", "public domain", "http://www.gnu.org/copyleft/lesser.html", "http://www.opensource.org/licenses/bsd-license.php"};
                String string = "";
                for (int n2 : jList.getSelectedIndices()) {
                    if (n2 == 2) {
                        string = "public domain";
                        break;
                    }
                    string = string + (string.length() == 0 ? stringArray2[n2] : ", " + stringArray2[n2]);
                }
                josmTextField3.setText(string);
                josmTextField3.setCaretPosition(0);
            }
        });
        actionListener.actionPerformed(null);
        keyAdapter.keyReleased(null);
    }

    private DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }
}

