/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Iterator;
import java.util.Map;
import org.json.JSONStringer;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class GeoJSONWriter
implements Visitor {
    private OsmDataLayer layer;
    private JSONStringer out;
    private static final boolean skipEmptyNodes = true;

    public GeoJSONWriter(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    public String write() {
        this.out = new JSONStringer();
        this.out.object().key("type").value("FeatureCollection");
        this.out.key("generator").value("JOSM");
        this.appendLayerBounds();
        this.out.key("features").array();
        for (Node osmPrimitive : this.layer.data.getNodes()) {
            this.appendPrimitive(osmPrimitive);
        }
        for (Way way : this.layer.data.getWays()) {
            this.appendPrimitive(way);
        }
        this.out.endArray().endObject();
        return this.out.toString();
    }

    @Override
    public void visit(Node node) {
        this.out.key("type").value("Point").key("coordinates");
        this.appendCoord(node.getCoor());
    }

    @Override
    public void visit(Way way) {
        this.out.key("type").value("LineString").key("coordinates").array();
        for (Node node : way.getNodes()) {
            this.appendCoord(node.getCoor());
        }
        this.out.endArray();
    }

    @Override
    public void visit(Relation relation) {
    }

    @Override
    public void visit(Changeset changeset) {
    }

    protected void appendPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive.isIncomplete()) {
            return;
        }
        if (osmPrimitive instanceof Node && osmPrimitive.getKeys().isEmpty()) {
            return;
        }
        this.out.object().key("type").value("Feature");
        Map<String, String> map = osmPrimitive.getKeys();
        this.out.key("properties").object();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.out.key(entry.getKey()).value(entry.getValue());
        }
        this.out.endObject();
        this.out.key("geometry").object();
        osmPrimitive.accept(this);
        this.out.endObject();
        this.out.endObject();
    }

    protected void appendCoord(LatLon latLon) {
        if (latLon != null) {
            this.out.array().value(latLon.lon()).value(latLon.lat()).endArray();
        }
    }

    protected void appendLayerBounds() {
        Iterator<Bounds> iterator = this.layer.data.getDataSourceBounds().iterator();
        if (iterator.hasNext()) {
            Bounds bounds = new Bounds(iterator.next());
            while (iterator.hasNext()) {
                bounds.extend(iterator.next());
            }
            this.appendBounds(bounds);
        }
    }

    protected void appendBounds(Bounds bounds) {
        if (bounds != null) {
            this.out.key("bbox").array().value(bounds.getMinLon()).value(bounds.getMinLat()).value(bounds.getMaxLon()).value(bounds.getMaxLat()).endArray();
        }
    }
}

