/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;

public abstract class FileImporter
implements Comparable<FileImporter>,
MapView.LayerChangeListener {
    public final ExtensionFileFilter filter;
    private boolean enabled;

    public FileImporter(ExtensionFileFilter extensionFileFilter) {
        this.filter = extensionFileFilter;
        this.enabled = true;
    }

    public boolean acceptFile(File file) {
        return this.filter.acceptName(file.getName());
    }

    public boolean isBatchImporter() {
        return false;
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import ''{0}''.", file.getName()));
    }

    public void importData(List<File> list, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import files.", new Object[0]));
    }

    public boolean importDataHandleExceptions(File file, ProgressMonitor progressMonitor) {
        try {
            Main.info("Open file: " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
            this.importData(file, progressMonitor);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not read file ''{0}''.<br>Error is:<br>{1}</html>", file.getName(), exception.getMessage()), I18n.tr("Error", new Object[0]), 0, null);
            return false;
        }
    }

    public boolean importDataHandleExceptions(List<File> list, ProgressMonitor progressMonitor) {
        try {
            Main.info("Open " + list.size() + " files");
            this.importData(list, progressMonitor);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not read files.<br>Error is:<br>{0}</html>", exception.getMessage()), I18n.tr("Error", new Object[0]), 0, null);
            return false;
        }
    }

    public double getPriority() {
        return 0.0;
    }

    @Override
    public int compareTo(FileImporter fileImporter) {
        return Double.compare(this.getPriority(), fileImporter.getPriority());
    }

    public static CBZip2InputStream getBZip2InputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        int n = bufferedInputStream.read();
        if (n != 66) {
            throw new IOException(I18n.tr("Invalid bz2 file.", new Object[0]));
        }
        n = bufferedInputStream.read();
        if (n != 90) {
            throw new IOException(I18n.tr("Invalid bz2 file.", new Object[0]));
        }
        return new CBZip2InputStream(bufferedInputStream);
    }

    public static GZIPInputStream getGZipInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return new GZIPInputStream(inputStream);
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
    }
}

